/*
 * Decompiled with CFR 0.152.
 */
package net.shelmarow.betterlockon.client.render.icon;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import net.shelmarow.betterlockon.client.render.icon.type.DefaultType;
import net.shelmarow.betterlockon.client.render.icon.type.IconType;
import net.shelmarow.betterlockon.client.render.icon.type.RPGType1;
import net.shelmarow.betterlockon.config.LockOnConfig;

public class IconTypeManager {
    private static final Set<IconType> ICON_TYPES = new HashSet<RPGType1>(Set.of(new DefaultType(), new RPGType1()));

    @Nonnull
    public static IconType getIconTypeOrDefault(String name) {
        for (IconType type : ICON_TYPES) {
            if (!type.getName().equals(name)) continue;
            return type;
        }
        return new DefaultType();
    }

    public static IconType getNextIconType() {
        IconType type;
        if (ICON_TYPES.isEmpty()) {
            return new DefaultType();
        }
        IconType current = IconTypeManager.getIconTypeOrDefault((String)LockOnConfig.LOCK_ON_ICON_TYPES.get());
        List iconTypes = ICON_TYPES.stream().toList();
        int index = 0;
        Iterator iterator = iconTypes.iterator();
        while (iterator.hasNext() && !(type = (IconType)iterator.next()).getName().equals(current.getName())) {
            ++index;
        }
        index = (index + 1) % iconTypes.size();
        return (IconType)iconTypes.get(index);
    }

    public static void registerIconType(IconType iconType) {
        ICON_TYPES.add(iconType);
    }

    public static boolean deleteIconType(IconType iconType) {
        if (ICON_TYPES.contains(iconType)) {
            ICON_TYPES.remove(iconType);
            return true;
        }
        return false;
    }
}

