/*
 * Decompiled with CFR 0.152.
 */
package net.shelmarow.betterlockon.config;

import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;

public class LockOnConfig {
    public static final ForgeConfigSpec CLIENT_CONFIG;
    public static final ForgeConfigSpec.ConfigValue<String> LOCK_ON_ICON_TYPES;
    public static final ForgeConfigSpec.DoubleValue LOCK_ON_ICON_SIZE;
    public static final ForgeConfigSpec.DoubleValue LOCK_ON_RED;
    public static final ForgeConfigSpec.DoubleValue LOCK_ON_GREEN;
    public static final ForgeConfigSpec.DoubleValue LOCK_ON_BLUE;
    public static final ForgeConfigSpec.DoubleValue LOCK_ON_ALPHA;
    public static final ForgeConfigSpec.BooleanValue LOCK_ON_SIZE_SCALING;
    public static final ForgeConfigSpec.DoubleValue LOCK_ON_CHANGE_DISTANCE;
    public static final ForgeConfigSpec.DoubleValue LOCK_ON_MIN_MOUSE_SPEED;
    public static final ForgeConfigSpec.BooleanValue AUTO_SWITCH_TARGET_WHEN_DIE;
    public static final ForgeConfigSpec.DoubleValue MAX_LOCK_ON_DISTANCE;
    public static final ForgeConfigSpec.DoubleValue MAX_TARGET_SELECT_DISTANCE;
    public static final ForgeConfigSpec.DoubleValue MIN_PITCH_WHEN_LOCK_ON;
    public static final ForgeConfigSpec.DoubleValue PITCH_OFFSET_WHEN_LOCK_ON;
    public static final ForgeConfigSpec.BooleanValue ENABLE_SOFT_LOCK;
    public static final ForgeConfigSpec.DoubleValue MAX_SOFT_ANGLE_X;
    public static final ForgeConfigSpec.DoubleValue MAX_SOFT_ANGLE_Y;
    public static final ForgeConfigSpec.DoubleValue CHANGE_DISTANCE_MULTIPLY;
    public static final ForgeConfigSpec.DoubleValue CHANGE_SPEED_MULTIPLY;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> WHITE_LIST;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> BLACK_LIST;
    public static final ForgeConfigSpec.BooleanValue FIX_WOM_ATTACK_LOCK_ON;

    static {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.push("Lock-On Icon Type");
        LOCK_ON_ICON_TYPES = builder.define("lockOnIconTypes", (Object)"DefaultType");
        builder.pop();
        builder.push("Lock-On UI Settings");
        LOCK_ON_ICON_SIZE = builder.comment("Lock-on icon base size, Default: 0.4").defineInRange("lockOnIconSize", 0.4, 0.1, 2.0);
        LOCK_ON_RED = builder.comment("Lock-on UI red color component Default: 1.0").defineInRange("lockOnRed", 1.0, 0.0, 1.0);
        LOCK_ON_GREEN = builder.comment("Lock-on UI green color component Default: 1.0").defineInRange("lockOnGreen", 1.0, 0.0, 1.0);
        LOCK_ON_BLUE = builder.comment("Lock-on UI blue color component Default: 1.0").defineInRange("lockOnBlue", 1.0, 0.0, 1.0);
        LOCK_ON_ALPHA = builder.comment("Lock-on UI alpha (transparency) component Default: 1.0").defineInRange("lockOnAlpha", 1.0, 0.0, 1.0);
        LOCK_ON_SIZE_SCALING = builder.comment(new String[]{"Enable automatic size scaling for large entities", "When enabled, lock-on UI will scale up for larger targets"}).define("lockOnSizeScaling", true);
        builder.pop();
        builder.push("Lock-On Change Settings");
        LOCK_ON_CHANGE_DISTANCE = builder.comment("Lock-on will only change target when mouse move more than this distance").defineInRange("lockOnChangeDistance", 600.0, 10.0, Double.MAX_VALUE);
        LOCK_ON_MIN_MOUSE_SPEED = builder.comment("Lock-on will only change target when mouse move fast than this speed").defineInRange("lockOnMinMouseSpeed", 20.0, 0.0, Double.MAX_VALUE);
        AUTO_SWITCH_TARGET_WHEN_DIE = builder.comment("Auto switch your target when the main target dies").define("autoSwitchTargetWhenDie", true);
        MAX_LOCK_ON_DISTANCE = builder.comment("The farthest distance that can keep lock on to the target").defineInRange("maxLockOnDistance", 30.0, 0.0, 128.0);
        MAX_TARGET_SELECT_DISTANCE = builder.comment("The farthest distance you can quickly lock on to the target").defineInRange("maxTargetSelectDistance", 20.0, 0.0, 128.0);
        MIN_PITCH_WHEN_LOCK_ON = builder.comment("Min camera pith when you lock on the target").defineInRange("minPitthWhenLockOn", 30.0, -45.0, 75.0);
        PITCH_OFFSET_WHEN_LOCK_ON = builder.comment("Pitch offset when you lock on the target").defineInRange("pitchOffsetWhenLockOn", 0.0, -90.0, 90.0);
        builder.pop();
        builder.push("Soft Lock Settings");
        ENABLE_SOFT_LOCK = builder.comment("Enable soft lock").define("enableSoftLock", false);
        MAX_SOFT_ANGLE_X = builder.comment("Max soft angle x").defineInRange("maxSoftAngleX", 60.0, 0.0, 120.0);
        MAX_SOFT_ANGLE_Y = builder.comment("Max soft angle yNotice: pitch will be limited by MIN_PITCH_WHEN_LOCK_ON config").defineInRange("maxSoftAngleY", 30.0, 0.0, 120.0);
        CHANGE_DISTANCE_MULTIPLY = builder.comment("change distance multiply").defineInRange("changeDistanceMultiply", 2.0, 0.0, 20.0);
        CHANGE_SPEED_MULTIPLY = builder.comment("Change speed multiply").defineInRange("changeSpeedMultiply", 4.0, 0.0, 20.0);
        builder.pop();
        builder.push("Lock-On WOM Attack Fix");
        FIX_WOM_ATTACK_LOCK_ON = builder.comment("Fix WOM disabled lock on when attacking").define("fixWomAttackLockOn", true);
        builder.pop();
        builder.push("Lock-On White/Black Entity List");
        WHITE_LIST = builder.comment("White List Living Entity (example\uff1a minecraft:zombie)").defineList("whitelist", List.of(), o -> o instanceof String);
        BLACK_LIST = builder.comment("Black List Living Entity (example\uff1a minecraft:zombie)").defineList("blacklist", List.of(), o -> o instanceof String);
        builder.pop();
        CLIENT_CONFIG = builder.build();
    }
}

