/*
 * Decompiled with CFR 0.152.
 */
package net.shelmarow.betterlockon.mixins;

import java.util.List;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.Input;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.ModList;
import net.shelmarow.betterlockon.client.control.LockOnControl;
import net.shelmarow.betterlockon.compat.HandlerShoulderSurfingCompat;
import net.shelmarow.betterlockon.config.LockOnConfig;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import yesman.epicfight.api.utils.math.MathUtils;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.client.CPSetPlayerTarget;

@Mixin(value={LocalPlayerPatch.class}, remap=false)
public class LocalPlayerPatchMixin {
    @Shadow
    private LivingEntity rayTarget;
    @Shadow
    private float lockOnXRot;
    @Shadow
    private float lockOnYRot;
    @Shadow
    private boolean targetLockedOn;
    @Shadow
    private Minecraft minecraft;

    @Unique
    private boolean betterLockOn$setClosestTarget() {
        LocalPlayerPatch playerPatch = (LocalPlayerPatch)this;
        List<LivingEntity> entityList = LockOnControl.entitiesCanBeSeen((LocalPlayer)playerPatch.getOriginal(), ((LocalPlayer)playerPatch.getOriginal()).f_108545_, null, 0.0);
        LivingEntity closest = LockOnControl.selectBestTarget((LocalPlayer)playerPatch.getOriginal(), entityList, null);
        if (closest != null) {
            this.rayTarget = closest;
            EpicFightNetworkManager.sendToServer((Object)new CPSetPlayerTarget(this.rayTarget.m_19879_()));
            return true;
        }
        this.rayTarget = null;
        EpicFightNetworkManager.sendToServer((Object)new CPSetPlayerTarget(-1));
        return false;
    }

    @Inject(method={"clientTick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;isRemoved()Z", ordinal=0)}, remap=true)
    private void atTargetLockedOnCheck(CallbackInfo ci) {
        LocalPlayerPatch playerPatch = (LocalPlayerPatch)this;
        double maxRange = (Double)LockOnConfig.MAX_LOCK_ON_DISTANCE.get();
        if (!this.rayTarget.m_6084_() || this.rayTarget.m_20177_((Player)playerPatch.getOriginal()) || ((LocalPlayer)playerPatch.getOriginal()).m_20280_((Entity)this.rayTarget) > maxRange * maxRange || playerPatch.getAngleTo((Entity)this.rayTarget) > 100.0 && !this.targetLockedOn) {
            boolean autoSwitch = (Boolean)LockOnConfig.AUTO_SWITCH_TARGET_WHEN_DIE.get();
            boolean targetFound = this.betterLockOn$setClosestTarget();
            if (!autoSwitch || !targetFound) {
                if (playerPatch.isTargetLockedOn()) {
                    ((LocalPlayer)playerPatch.getOriginal()).m_146926_(this.lockOnXRot);
                    ((LocalPlayer)playerPatch.getOriginal()).m_146922_(this.lockOnYRot);
                    this.targetLockedOn = false;
                }
                this.rayTarget = null;
                EpicFightNetworkManager.sendToServer((Object)new CPSetPlayerTarget(-1));
            }
        }
    }

    @Redirect(method={"clientTick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;isRemoved()Z"))
    private boolean redirectIsRemoved(LivingEntity instance) {
        return false;
    }

    @Redirect(method={"clientTick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;isInvisibleTo(Lnet/minecraft/world/entity/player/Player;)Z"), remap=true)
    private boolean redirectIsInvisibleTo(LivingEntity instance, Player player) {
        return false;
    }

    @Redirect(method={"clientTick"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/player/LocalPlayer;distanceToSqr(Lnet/minecraft/world/entity/Entity;)D"), remap=true)
    private double redirectDistanceToSqr(LocalPlayer instance, Entity entity) {
        return 0.0;
    }

    @Redirect(method={"clientTick"}, at=@At(value="INVOKE", target="Lyesman/epicfight/client/world/capabilites/entitypatch/player/LocalPlayerPatch;getAngleTo(Lnet/minecraft/world/entity/Entity;)D"))
    private double redirectGetAngleTo(LocalPlayerPatch instance, Entity entity) {
        return 0.0;
    }

    @Redirect(method={"clientTick"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/Mth;clamp(FFF)F", ordinal=0), remap=true)
    private float betterlockon$redirectYawClamp(float value, float min, float max) {
        CameraType cameraType = this.minecraft.f_91066_.m_92176_();
        LocalPlayerPatch playerPatch = (LocalPlayerPatch)this;
        double ratio = (this.rayTarget.m_146892_().f_82480_ - ((LocalPlayer)playerPatch.getOriginal()).m_146892_().f_82480_ + (double)((LocalPlayer)playerPatch.getOriginal()).m_20206_()) / (double)((LocalPlayer)playerPatch.getOriginal()).m_20206_();
        float heightFactor = (float)Mth.m_14008_((double)ratio, (double)1.0, (double)5.0);
        float maxPitch = 90.0f;
        float minPitch = (float)Mth.m_14139_((double)((heightFactor - 1.0f) / 4.0f), (double)((Double)LockOnConfig.MIN_PITCH_WHEN_LOCK_ON.get()), (double)-45.0);
        Double pitchOffset = (Double)LockOnConfig.PITCH_OFFSET_WHEN_LOCK_ON.get();
        if (cameraType == CameraType.FIRST_PERSON) {
            minPitch = -90.0f;
            pitchOffset = 0.0;
        }
        return Mth.m_14036_((float)((float)((double)value + pitchOffset)), (float)minPitch, (float)maxPitch);
    }

    @Redirect(method={"clientTick"}, at=@At(value="INVOKE", target="Lyesman/epicfight/api/utils/math/MathUtils;getYRotOfVector(Lnet/minecraft/world/phys/Vec3;)D"))
    private double redirectLockOnYRot(Vec3 vec) {
        float offset = 0.0f;
        if (((Boolean)LockOnConfig.ENABLE_SOFT_LOCK.get()).booleanValue()) {
            offset = LockOnControl.getLastMovedDistanceX();
        }
        return MathUtils.getYRotOfVector((Vec3)vec) + (double)offset;
    }

    @Redirect(method={"clientTick"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/player/LocalPlayer;setYRot(F)V", ordinal=0), remap=true)
    private void redirectYRot(LocalPlayer instance, float v) {
        float offset = 0.0f;
        if (((Boolean)LockOnConfig.ENABLE_SOFT_LOCK.get()).booleanValue()) {
            offset = LockOnControl.getLastMovedDistanceX();
        }
        if (this.minecraft.f_91066_.f_92091_.m_90857_() && !this.minecraft.f_91066_.f_92095_.m_90857_() && this.minecraft.f_91074_ != null) {
            boolean backward;
            Input input = this.minecraft.f_91074_.f_108618_;
            float dir = 0.0f;
            boolean forward = input.f_108568_ && !input.f_108569_;
            boolean bl = backward = !input.f_108568_ && input.f_108569_;
            if (input.f_108570_ && forward) {
                dir = 45.0f;
            } else if (input.f_108570_ && !backward) {
                dir = 90.0f;
            } else if (input.f_108570_) {
                dir = 135.0f;
            } else if (input.f_108571_ && forward) {
                dir = -45.0f;
            } else if (input.f_108571_ && !backward) {
                dir = -90.0f;
            } else if (input.f_108571_) {
                dir = -135.0f;
            } else if (backward) {
                dir = 180.0f;
            }
            offset += dir;
        }
        instance.m_146922_(v - offset);
    }

    @Redirect(method={"clientTick"}, at=@At(value="INVOKE", target="Lyesman/epicfight/api/utils/math/MathUtils;getXRotOfVector(Lnet/minecraft/world/phys/Vec3;)D"))
    private double redirectLockOnXRot(Vec3 vec) {
        float offset = 0.0f;
        if (((Boolean)LockOnConfig.ENABLE_SOFT_LOCK.get()).booleanValue()) {
            offset = LockOnControl.getLastMovedDistanceY();
        }
        return MathUtils.getXRotOfVector((Vec3)vec) + (double)offset;
    }

    @ModifyArg(method={"clientTick"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/player/LocalPlayer;setXRot(F)V", ordinal=0), remap=true)
    private float redirectXRot(float par1) {
        float offset = 0.0f;
        if (((Boolean)LockOnConfig.ENABLE_SOFT_LOCK.get()).booleanValue()) {
            offset = LockOnControl.getLastMovedDistanceY();
        }
        Vec3 playerEye = ((LocalPlayer)((LocalPlayerPatch)this).getOriginal()).m_146892_();
        Vec3 targetEye = this.rayTarget.m_20182_().m_82520_(0.0, (double)(this.rayTarget.m_20206_() * 2.0f / 3.0f), 0.0);
        Vec3 toTarget = targetEye.m_82546_(playerEye);
        double pitchDeg = MathUtils.getXRotOfVector((Vec3)toTarget);
        return (float)Mth.m_14008_((double)(pitchDeg + (double)offset), (double)-45.0, (double)45.0);
    }

    @Redirect(method={"clientTick"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/Mth;clamp(FFF)F", ordinal=1), remap=true)
    private float redirectY(float pValue, float pMin, float pMax) {
        return Mth.m_14036_((float)pValue, (float)pMin, (float)pMax);
    }

    @Redirect(method={"clientTick"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/Mth;clamp(FFF)F", ordinal=2), remap=true)
    private float redirectX(float pValue, float pMin, float pMax) {
        return Mth.m_14036_((float)pValue, (float)pMin, (float)pMax);
    }

    @Inject(method={"setLockOn"}, at={@At(value="HEAD")}, cancellable=true)
    public void setLockOn(boolean targetLockedOn, CallbackInfo ci) {
        LocalPlayerPatch playerPatch = (LocalPlayerPatch)this;
        LocalPlayer localPlayer = (LocalPlayer)playerPatch.getOriginal();
        if (!this.targetLockedOn) {
            List<LivingEntity> entityList;
            LockOnControl.setLastMovedDistanceX(0.0f);
            LockOnControl.setLastMovedDistanceY(0.0);
            if (this.rayTarget != null && !(entityList = LockOnControl.entitiesCanBeSeen(localPlayer, localPlayer.f_108545_, null, 0.0)).contains(this.rayTarget)) {
                this.rayTarget = null;
                EpicFightNetworkManager.sendToServer((Object)new CPSetPlayerTarget(-1));
            }
            if (this.rayTarget == null) {
                this.betterLockOn$setClosestTarget();
            }
            if (ModList.get().isLoaded("shouldersurfing")) {
                HandlerShoulderSurfingCompat.handlerCam();
            }
        }
        if (this.targetLockedOn && this.rayTarget != null) {
            localPlayer.m_146926_(this.lockOnXRot);
            localPlayer.m_146922_(this.lockOnYRot);
            EpicFightNetworkManager.sendToServer((Object)new CPSetPlayerTarget(this.rayTarget.m_19879_()));
        }
        this.targetLockedOn = targetLockedOn;
        ci.cancel();
    }
}

