/*
 * Decompiled with CFR 0.152.
 */
package terrails.colorfulhearts.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.renderer.GameRenderer;
import org.joml.Matrix4f;

public class RenderUtils {
    public static void drawTexture(PoseStack poseStack, int x, int y, int u, int v) {
        RenderUtils.drawTexture(poseStack, x, y, u, v, 0);
    }

    public static void drawTexture(PoseStack poseStack, int x, int y, int u, int v, int alpha) {
        RenderUtils.drawTexture(poseStack, x, x + 9, y, y + 9, u, u + 9, v, v + 9, alpha);
    }

    public static void drawTexture(PoseStack poseStack, int x, int y, int u, int v, int color, int alpha) {
        RenderUtils.drawTexture(poseStack, x, x + 9, y, y + 9, u, u + 9, v, v + 9, color, alpha);
    }

    public static void drawTexture(PoseStack poseStack, int x1, int x2, int y1, int y2, int u1, int u2, int v1, int v2) {
        RenderUtils.drawTexture(poseStack, x1, x2, y1, y2, u1, u2, v1, v2, 0, 0, 0, 0);
    }

    public static void drawTexture(PoseStack poseStack, int x1, int x2, int y1, int y2, int u1, int u2, int v1, int v2, int alpha) {
        RenderUtils.drawTexture(poseStack, x1, x2, y1, y2, u1, u2, v1, v2, 255, 255, 255, alpha);
    }

    public static void drawTexture(PoseStack poseStack, int x1, int x2, int y1, int y2, int u1, int u2, int v1, int v2, int color, int alpha) {
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        RenderUtils.drawTexture(poseStack, x1, x2, y1, y2, u1, u2, v1, v2, r, g, b, alpha);
    }

    public static void drawTexture(PoseStack poseStack, int x1, int x2, int y1, int y2, int u1, int u2, int v1, int v2, int red, int green, int blue, int alpha) {
        RenderUtils.drawColoredTexturedQuad(poseStack.m_85850_().m_252922_(), x1, x2, y1, y2, 0, (float)u1 / 256.0f, (float)u2 / 256.0f, (float)v1 / 256.0f, (float)v2 / 256.0f, red, green, blue, alpha);
    }

    public static void drawColoredTexturedQuad(Matrix4f matrix4f, int x0, int x1, int y0, int y1, int z, float u0, float u1, float v0, float v1, int red, int green, int blue, int alpha) {
        RenderSystem.setShader(() -> alpha != 0 ? GameRenderer.m_172814_() : GameRenderer.m_172817_());
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, alpha != 0 ? DefaultVertexFormat.f_85818_ : DefaultVertexFormat.f_85817_);
        bufferBuilder.m_252986_(matrix4f, (float)x0, (float)y1, (float)z).m_6122_(red, green, blue, alpha).m_7421_(u0, v1).m_5752_();
        bufferBuilder.m_252986_(matrix4f, (float)x1, (float)y1, (float)z).m_6122_(red, green, blue, alpha).m_7421_(u1, v1).m_5752_();
        bufferBuilder.m_252986_(matrix4f, (float)x1, (float)y0, (float)z).m_6122_(red, green, blue, alpha).m_7421_(u1, v0).m_5752_();
        bufferBuilder.m_252986_(matrix4f, (float)x0, (float)y0, (float)z).m_6122_(red, green, blue, alpha).m_7421_(u0, v0).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
    }
}

