/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.packager.repackager;

import com.simibubi.create.compat.computercraft.events.PackageEvent;
import com.simibubi.create.compat.computercraft.events.RepackageEvent;
import com.simibubi.create.content.logistics.BigItemStack;
import com.simibubi.create.content.logistics.box.PackageItem;
import com.simibubi.create.content.logistics.crate.BottomlessItemHandler;
import com.simibubi.create.content.logistics.packager.PackagerBlockEntity;
import com.simibubi.create.content.logistics.packager.PackagerItemHandler;
import com.simibubi.create.content.logistics.packager.PackagingRequest;
import com.simibubi.create.content.logistics.packager.repackager.PackageRepackageHelper;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandler;

public class RepackagerBlockEntity
extends PackagerBlockEntity {
    public PackageRepackageHelper repackageHelper = new PackageRepackageHelper();

    public RepackagerBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    @Override
    public boolean unwrapBox(ItemStack box, boolean simulate) {
        if (this.animationTicks > 0) {
            return false;
        }
        IItemHandler targetInv = (IItemHandler)this.targetInventory.getInventory();
        if (targetInv == null || targetInv instanceof PackagerItemHandler) {
            return false;
        }
        boolean targetIsCreativeCrate = targetInv instanceof BottomlessItemHandler;
        boolean anySpace = false;
        for (int slot = 0; slot < targetInv.getSlots(); ++slot) {
            ItemStack remainder = targetInv.insertItem(slot, box, simulate);
            if (!remainder.m_41619_()) continue;
            anySpace = true;
            break;
        }
        if (!targetIsCreativeCrate && !anySpace) {
            return false;
        }
        if (simulate) {
            return true;
        }
        this.computerBehaviour.prepareComputerEvent(new PackageEvent(box, "package_received"));
        this.previouslyUnwrapped = box;
        this.animationInward = true;
        this.animationTicks = 20;
        this.notifyUpdate();
        return true;
    }

    @Override
    public void recheckIfLinksPresent() {
    }

    @Override
    public boolean redstoneModeActive() {
        return true;
    }

    @Override
    public void attemptToSend(List<PackagingRequest> queuedRequests) {
        if (!this.heldBox.m_41619_() || this.animationTicks != 0 || this.buttonCooldown > 0) {
            return;
        }
        if (!this.queuedExitingPackages.isEmpty()) {
            return;
        }
        IItemHandler targetInv = (IItemHandler)this.targetInventory.getInventory();
        if (targetInv == null || targetInv instanceof PackagerItemHandler) {
            return;
        }
        this.attemptToRepackage(targetInv);
        if (this.heldBox.m_41619_()) {
            return;
        }
        this.updateSignAddress();
        if (!this.signBasedAddress.isBlank()) {
            PackageItem.addAddress(this.heldBox, this.signBasedAddress);
        }
    }

    protected void attemptToRepackage(IItemHandler targetInv) {
        this.repackageHelper.clear();
        int completedOrderId = -1;
        for (int slot = 0; slot < targetInv.getSlots(); ++slot) {
            ItemStack extracted = targetInv.extractItem(slot, 1, true);
            if (extracted.m_41619_() || !PackageItem.isPackage(extracted)) continue;
            if (!this.repackageHelper.isFragmented(extracted)) {
                targetInv.extractItem(slot, 1, false);
                this.heldBox = extracted.m_41777_();
                this.animationInward = false;
                this.animationTicks = 20;
                this.notifyUpdate();
                return;
            }
            completedOrderId = this.repackageHelper.addPackageFragment(extracted);
            if (completedOrderId != -1) break;
        }
        if (completedOrderId == -1) {
            return;
        }
        List<BigItemStack> boxesToExport = this.repackageHelper.repack(completedOrderId, this.f_58857_.m_213780_());
        for (int slot = 0; slot < targetInv.getSlots(); ++slot) {
            ItemStack extracted = targetInv.extractItem(slot, 1, true);
            if (extracted.m_41619_() || !PackageItem.isPackage(extracted) || PackageItem.getOrderId(extracted) != completedOrderId) continue;
            targetInv.extractItem(slot, 1, false);
        }
        if (boxesToExport.isEmpty()) {
            return;
        }
        if (this.computerBehaviour.hasAttachedComputer()) {
            for (BigItemStack box : boxesToExport) {
                this.computerBehaviour.prepareComputerEvent(new RepackageEvent(box.stack, box.count));
            }
        }
        this.queuedExitingPackages.addAll(boxesToExport);
        this.notifyUpdate();
    }
}

