/*
 * Decompiled with CFR 0.152.
 */
package ewewukek.musketmod;

import ewewukek.musketmod.MusketMod;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.util.Locale;
import java.util.Scanner;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Config {
    private static final Logger logger = LogManager.getLogger(MusketMod.class);
    public static final int VERSION = 4;
    public static float bulletMaxDistance;
    public static final float BULLET_MAX_DISTANCE = 256.0f;
    public static int loadingStages;
    public static final int LOADING_STAGES = 3;
    public static float loadingStageDuration;
    public static final float LOADING_STAGE_DURATION = 0.5f;
    public static float pvpDamageMultiplier;
    public static final float PVP_DAMAGE_MULTIPLIER = 1.0f;
    public static float mobDamageMultiplier;
    public static final float MOB_DAMAGE_MULTIPLIER = 0.5f;
    public static float pistolPillagerChance;
    public static final float PISTOL_PILLAGER_CHANCE = 0.2f;
    public static float musketSkeletonChance;
    public static final float MUSKET_SKELETON_CHANCE = 0.05f;
    public static float damagePerPowerLevel;
    public static final float DAMAGE_PER_POWER_LEVEL = 0.5f;
    public static float musketBulletStdDev;
    public static final float MUSKET_BULLET_STD_DEV = 1.0f;
    public static float musketBulletSpeed;
    public static final float MUSKET_BULLET_SPEED = 180.0f;
    public static float musketDamage;
    public static final float MUSKET_DAMAGE = 16.0f;
    public static float headshotDamageMultiplier;
    public static final float HEADSHOT_DAMAGE_MULTIPLIER = 1.3f;
    public static int bayonetDamage;
    public static final int BAYONET_DAMAGE = 5;
    public static float bayonetSpeed;
    public static final float BAYONET_SPEED = 2.0f;
    public static int musketDurability;
    public static final int MUSKET_DURABILITY = 250;
    public static float scopedMusketBulletStdDev;
    public static final float SCOPED_MUSKET_BULLET_STD_DEV = 0.2f;
    public static float scopeZoom;
    public static final float SCOPE_ZOOM = 3.0f;
    public static float bulletGravityMultiplier;
    public static final float BULLET_GRAVITY_MULTIPLIER = 0.5f;
    public static int scopedMusketDurability;
    public static final int SCOPED_MUSKET_DURABILITY = 150;
    public static float blunderbussBulletStdDev;
    public static final float BLUNDERBUSS_BULLET_STD_DEV = 2.5f;
    public static float blunderbussBulletSpeed;
    public static final float BLUNDERBUSS_BULLET_SPEED = 160.0f;
    public static float blunderbussDamage;
    public static final float BLUNDERBUSS_DAMAGE = 21.0f;
    public static int blunderbussPelletCount;
    public static final int BLUNDERBUSS_PELLET_COUNT = 9;
    public static int blunderbussDurability;
    public static final int BLUNDERBUSS_DURABILITY = 200;
    public static float pistolBulletStdDev;
    public static final float PISTOL_BULLET_STD_DEV = 1.5f;
    public static float pistolBulletSpeed;
    public static final float PISTOL_BULLET_SPEED = 140.0f;
    public static float pistolDamage;
    public static final float PISTOL_DAMAGE = 12.0f;
    public static float reductionPerQuickChargeLevel;
    public static final float REDUCTION_PER_QUICK_CHARGE_LEVEL = 0.15f;
    public static int pistolDurability;
    public static final int PISTOL_DURABILITY = 200;
    public static float dispenserBulletStdDev;
    public static final float DISPENSER_BULLET_STD_DEV = 2.0f;
    public static float dispenserBulletSpeed;
    public static final float DISPENSER_BULLET_SPEED = 120.0f;
    public static float dispenserDamage;
    public static final float DISPENSER_DAMAGE = 10.0f;

    /*
     * Unable to fully structure code
     */
    public static void load() {
        Config.bulletMaxDistance = 256.0f;
        Config.loadingStages = 3;
        Config.loadingStageDuration = 0.5f;
        Config.pvpDamageMultiplier = 1.0f;
        Config.mobDamageMultiplier = 0.5f;
        Config.pistolPillagerChance = 0.2f;
        Config.musketSkeletonChance = 0.05f;
        Config.damagePerPowerLevel = 0.5f;
        Config.musketBulletStdDev = 1.0f;
        Config.musketBulletSpeed = 180.0f;
        Config.musketDamage = 16.0f;
        Config.headshotDamageMultiplier = 1.3f;
        Config.bayonetDamage = 5;
        Config.bayonetSpeed = 2.0f;
        Config.musketDurability = 250;
        Config.scopedMusketBulletStdDev = 0.2f;
        Config.scopeZoom = 3.0f;
        Config.bulletGravityMultiplier = 0.5f;
        Config.scopedMusketDurability = 150;
        Config.blunderbussBulletStdDev = 2.5f;
        Config.blunderbussBulletSpeed = 160.0f;
        Config.blunderbussDamage = 21.0f;
        Config.blunderbussPelletCount = 9;
        Config.blunderbussDurability = 200;
        Config.pistolBulletStdDev = 1.5f;
        Config.pistolBulletSpeed = 140.0f;
        Config.pistolDamage = 12.0f;
        Config.reductionPerQuickChargeLevel = 0.15f;
        Config.pistolDurability = 200;
        Config.dispenserBulletStdDev = 2.0f;
        Config.dispenserBulletSpeed = 120.0f;
        Config.dispenserDamage = 10.0f;
        version = 0;
        try {
            reader = Files.newBufferedReader(MusketMod.CONFIG_PATH);
            try {
                lineNumber = 0;
lbl38:
                // 41 sources

                block94: while ((line = reader.readLine()) != null) {
                    ++lineNumber;
                    commentStart = line.indexOf(35);
                    if (commentStart != -1) {
                        line = line.substring(0, commentStart);
                    }
                    line.trim();
                    if (line.length() == 0) continue;
                    errorPrefix = MusketMod.CONFIG_PATH + ": line " + lineNumber + ": ";
                    s = new Scanner(line);
                    try {
                        s.useLocale(Locale.US);
                        s.useDelimiter("\\s*=\\s*");
                        if (!s.hasNext()) {
                            Config.logger.warn(errorPrefix + "parameter name is missing");
                            continue;
                        }
                        key = s.next().trim();
                        if (!s.hasNextFloat()) {
                            Config.logger.warn(errorPrefix + "value is missing/wrong/not a number");
                            continue;
                        }
                        value = s.nextFloat();
                        var9_15 = key;
                        var10_16 = -1;
                        switch (var9_15.hashCode()) {
                            case 351608024: {
                                if (!var9_15.equals("version")) break;
                                var10_16 = 0;
                                break;
                            }
                            case -1363058921: {
                                if (!var9_15.equals("bulletMaxDistance")) break;
                                var10_16 = 1;
                                break;
                            }
                            case 474779025: {
                                if (!var9_15.equals("loadingStages")) break;
                                var10_16 = 2;
                                break;
                            }
                            case 1970063062: {
                                if (!var9_15.equals("loadingStageDuration")) break;
                                var10_16 = 3;
                                break;
                            }
                            case -84014630: {
                                if (!var9_15.equals("pvpDamageMultiplier")) break;
                                var10_16 = 4;
                                break;
                            }
                            case -927493712: {
                                if (!var9_15.equals("mobDamageMultiplier")) break;
                                var10_16 = 5;
                                break;
                            }
                            case -177173577: {
                                if (!var9_15.equals("pistolPillagerChance")) break;
                                var10_16 = 6;
                                break;
                            }
                            case -330459536: {
                                if (!var9_15.equals("musketSkeletonChance")) break;
                                var10_16 = 7;
                                break;
                            }
                            case 1444772685: {
                                if (!var9_15.equals("damagePerPowerLevel")) break;
                                var10_16 = 8;
                                break;
                            }
                            case 582909588: {
                                if (!var9_15.equals("bulletStdDev")) break;
                                var10_16 = 9;
                                break;
                            }
                            case -815455517: {
                                if (!var9_15.equals("musketBulletStdDev")) break;
                                var10_16 = 10;
                                break;
                            }
                            case -1366786971: {
                                if (!var9_15.equals("bulletSpeed")) break;
                                var10_16 = 11;
                                break;
                            }
                            case -580611530: {
                                if (!var9_15.equals("musketBulletSpeed")) break;
                                var10_16 = 12;
                                break;
                            }
                            case 2020948067: {
                                if (!var9_15.equals("damageMin")) break;
                                var10_16 = 13;
                                break;
                            }
                            case 1987991294: {
                                if (!var9_15.equals("musketDamage")) break;
                                var10_16 = 14;
                                break;
                            }
                            case 2020947829: {
                                if (!var9_15.equals("damageMax")) break;
                                var10_16 = 15;
                                break;
                            }
                            case 145207178: {
                                if (!var9_15.equals("headshotDamageMultiplier")) break;
                                var10_16 = 16;
                                break;
                            }
                            case -1483905161: {
                                if (!var9_15.equals("bayonetDamage")) break;
                                var10_16 = 17;
                                break;
                            }
                            case 1767539519: {
                                if (!var9_15.equals("bayonetSpeed")) break;
                                var10_16 = 18;
                                break;
                            }
                            case 716086281: {
                                if (!var9_15.equals("durability")) break;
                                var10_16 = 19;
                                break;
                            }
                            case 1711278104: {
                                if (!var9_15.equals("musketDurability")) break;
                                var10_16 = 20;
                                break;
                            }
                            case -1285986413: {
                                if (!var9_15.equals("scopedMusketBulletStdDev")) break;
                                var10_16 = 21;
                                break;
                            }
                            case 2071891015: {
                                if (!var9_15.equals("scopeZoom")) break;
                                var10_16 = 22;
                                break;
                            }
                            case -1908801075: {
                                if (!var9_15.equals("bulletGravityMultiplier")) break;
                                var10_16 = 23;
                                break;
                            }
                            case -90326840: {
                                if (!var9_15.equals("scopedMusketDurability")) break;
                                var10_16 = 24;
                                break;
                            }
                            case 1942014197: {
                                if (!var9_15.equals("blunderbussBulletStdDev")) break;
                                var10_16 = 25;
                                break;
                            }
                            case 1725096420: {
                                if (!var9_15.equals("blunderbussBulletSpeed")) break;
                                var10_16 = 26;
                                break;
                            }
                            case -640912752: {
                                if (!var9_15.equals("blunderbussDamage")) break;
                                var10_16 = 27;
                                break;
                            }
                            case 1172039498: {
                                if (!var9_15.equals("blunderbussPelletCount")) break;
                                var10_16 = 28;
                                break;
                            }
                            case -154006870: {
                                if (!var9_15.equals("blunderbussDurability")) break;
                                var10_16 = 29;
                                break;
                            }
                            case -596850261: {
                                if (!var9_15.equals("pistolBulletStdDev")) break;
                                var10_16 = 30;
                                break;
                            }
                            case 1089008238: {
                                if (!var9_15.equals("pistolBulletSpeed")) break;
                                var10_16 = 31;
                                break;
                            }
                            case 593337516: {
                                if (!var9_15.equals("pistolDamageMin")) break;
                                var10_16 = 32;
                                break;
                            }
                            case 819770310: {
                                if (!var9_15.equals("pistolDamage")) break;
                                var10_16 = 33;
                                break;
                            }
                            case 593337278: {
                                if (!var9_15.equals("pistolDamageMax")) break;
                                var10_16 = 34;
                                break;
                            }
                            case 550818509: {
                                if (!var9_15.equals("reductionPerQuickChargeLevel")) break;
                                var10_16 = 35;
                                break;
                            }
                            case -590167840: {
                                if (!var9_15.equals("pistolDurability")) break;
                                var10_16 = 36;
                                break;
                            }
                            case -316434967: {
                                if (!var9_15.equals("dispenserBulletStdDev")) break;
                                var10_16 = 37;
                                break;
                            }
                            case 405317232: {
                                if (!var9_15.equals("dispenserBulletSpeed")) break;
                                var10_16 = 38;
                                break;
                            }
                            case -1799813500: {
                                if (!var9_15.equals("dispenserDamage")) break;
                                var10_16 = 39;
                            }
                        }
                        switch (var10_16) {
                            case 0: {
                                version = (int)value;
                                ** break;
                            }
                            case 1: {
                                Config.bulletMaxDistance = value;
                                ** break;
                            }
                            case 2: {
                                Config.loadingStages = (int)value;
                                ** break;
                            }
                            case 3: {
                                Config.loadingStageDuration = value;
                                ** break;
                            }
                            case 4: {
                                Config.pvpDamageMultiplier = value;
                                ** break;
                            }
                            case 5: {
                                Config.mobDamageMultiplier = value;
                                ** break;
                            }
                            case 6: {
                                Config.pistolPillagerChance = value;
                                ** break;
                            }
                            case 7: {
                                Config.musketSkeletonChance = value;
                                ** break;
                            }
                            case 8: {
                                Config.damagePerPowerLevel = value;
                                ** break;
                            }
                            case 9: 
                            case 10: {
                                Config.musketBulletStdDev = value;
                                ** break;
                            }
                            case 11: 
                            case 12: {
                                Config.musketBulletSpeed = value;
                                ** break;
                            }
                            case 13: 
                            case 14: {
                                Config.musketDamage = value;
                                ** break;
                            }
                            case 15: {
                                ** break;
                            }
                            case 16: {
                                Config.headshotDamageMultiplier = value;
                                ** break;
                            }
                            case 17: {
                                Config.bayonetDamage = (int)value;
                                ** break;
                            }
                            case 18: {
                                Config.bayonetSpeed = value;
                                ** break;
                            }
                            case 19: 
                            case 20: {
                                Config.musketDurability = (int)value;
                                ** break;
                            }
                            case 21: {
                                Config.scopedMusketBulletStdDev = value;
                                ** break;
                            }
                            case 22: {
                                Config.scopeZoom = value;
                                ** break;
                            }
                            case 23: {
                                Config.bulletGravityMultiplier = value;
                                ** break;
                            }
                            case 24: {
                                Config.scopedMusketDurability = (int)value;
                                ** break;
                            }
                            case 25: {
                                Config.blunderbussBulletStdDev = value;
                                ** break;
                            }
                            case 26: {
                                Config.blunderbussBulletSpeed = value;
                                ** break;
                            }
                            case 27: {
                                Config.blunderbussDamage = value;
                                ** break;
                            }
                            case 28: {
                                Config.blunderbussPelletCount = (int)value;
                                ** break;
                            }
                            case 29: {
                                Config.blunderbussDurability = (int)value;
                                ** break;
                            }
                            case 30: {
                                Config.pistolBulletStdDev = value;
                                ** break;
                            }
                            case 31: {
                                Config.pistolBulletSpeed = value;
                                ** break;
                            }
                            case 32: 
                            case 33: {
                                Config.pistolDamage = value;
                                ** break;
                            }
                            case 34: {
                                ** break;
                            }
                            case 35: {
                                Config.reductionPerQuickChargeLevel = value;
                                ** break;
                            }
                            case 36: {
                                Config.pistolDurability = (int)value;
                                ** break;
                            }
                            case 37: {
                                Config.dispenserBulletStdDev = value;
                                ** break;
                            }
                            case 38: {
                                Config.dispenserBulletSpeed = value;
                                ** break;
                            }
                            case 39: {
                                Config.dispenserDamage = value;
                                ** break;
                            }
                            default: {
                                Config.logger.warn(errorPrefix + "unrecognized parameter name: " + key);
                                continue block94;
                            }
                        }
                    }
                    finally {
                        s.close();
                    }
                }
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
        catch (NoSuchFileException e) {
            Config.save();
            Config.logger.info("Configuration file not found, default created");
        }
        catch (IOException e) {
            Config.logger.warn("Could not read configuration file: ", (Throwable)e);
        }
        if (version < 4) {
            Config.logger.info("Configuration file belongs to older version, updating");
            if (version < 4) {
                if ((double)Config.musketDamage == 20.5) {
                    Config.musketDamage = 16.0f;
                }
                if (Config.bayonetDamage == 4) {
                    Config.bayonetDamage = 5;
                }
                if (Config.pistolDurability == 150) {
                    Config.pistolDurability = 200;
                }
            }
            Config.save();
        }
        Config.logger.info("Configuration has been loaded");
    }

    public static void save() {
        try (BufferedWriter writer = Files.newBufferedWriter(MusketMod.CONFIG_PATH, new OpenOption[0]);){
            writer.write("version = 4\n");
            writer.write("\n");
            writer.write("# Maximum bullet travel distance (in blocks)\n");
            writer.write("bulletMaxDistance = " + bulletMaxDistance + "\n");
            writer.write("\n");
            writer.write("# Number of loading stages\n");
            writer.write("loadingStages = " + loadingStages + "\n");
            writer.write("# Loading stage duration (in seconds)\n");
            writer.write("loadingStageDuration = " + loadingStageDuration + "\n");
            writer.write("\n");
            writer.write("# Damage multiplier for pvp\n");
            writer.write("pvpDamageMultiplier = " + pvpDamageMultiplier + "\n");
            writer.write("# Damage multiplier for monsters\n");
            writer.write("mobDamageMultiplier = " + mobDamageMultiplier + "\n");
            writer.write("\n");
            writer.write("# Probability of Pillager having a pistol\n");
            writer.write("pistolPillagerChance = " + pistolPillagerChance + "\n");
            writer.write("# Probability of Skeleton having a musket\n");
            writer.write("musketSkeletonChance = " + musketSkeletonChance + "\n");
            writer.write("\n");
            writer.write("# Extra damage per Power enchantment level\n");
            writer.write("damagePerPowerLevel = " + damagePerPowerLevel + "\n");
            writer.write("# Musket\n");
            writer.write("\n");
            writer.write("# Standard deviation of bullet spread (in degrees)\n");
            writer.write("musketBulletStdDev = " + musketBulletStdDev + "\n");
            writer.write("# Muzzle velocity of bullet (in blocks per second)\n");
            writer.write("musketBulletSpeed = " + musketBulletSpeed + "\n");
            writer.write("# Damage at point-blank range\n");
            writer.write("musketDamage = " + musketDamage + "\n");
            writer.write("# Headshot damage multiplier\n");
            writer.write("headshotDamageMultiplier = " + headshotDamageMultiplier + "\n");
            writer.write("# Durability (applied on restart)\n");
            writer.write("musketDurability = " + musketDurability + "\n");
            writer.write("\n");
            writer.write("# Musket with bayonet\n");
            writer.write("\n");
            writer.write("# Bayonet damage (applied on restart)\n");
            writer.write("bayonetDamage = " + bayonetDamage + "\n");
            writer.write("\n");
            writer.write("# Bayonet attack speed (applied on restart)\n");
            writer.write("bayonetSpeed = " + bayonetSpeed + "\n");
            writer.write("\n");
            writer.write("# Musket with scope\n");
            writer.write("\n");
            writer.write("# Standard deviation of bullet spread (in degrees)\n");
            writer.write("scopedMusketBulletStdDev = " + scopedMusketBulletStdDev + "\n");
            writer.write("# Scope zoom factor\n");
            writer.write("scopeZoom = " + scopeZoom + "\n");
            writer.write("# Bullet gravity multiplier\n");
            writer.write("bulletGravityMultiplier = " + bulletGravityMultiplier + "\n");
            writer.write("# Durability (applied on restart)\n");
            writer.write("scopedMusketDurability = " + scopedMusketDurability + "\n");
            writer.write("\n");
            writer.write("# Blunderbuss\n");
            writer.write("\n");
            writer.write("# Standard deviation of bullet spread (in degrees)\n");
            writer.write("blunderbussBulletStdDev = " + blunderbussBulletStdDev + "\n");
            writer.write("# Muzzle velocity of bullet (in blocks per second)\n");
            writer.write("blunderbussBulletSpeed = " + blunderbussBulletSpeed + "\n");
            writer.write("# Damage at point-blank range\n");
            writer.write("blunderbussDamage = " + blunderbussDamage + "\n");
            writer.write("# Pellet count\n");
            writer.write("blunderbussPelletCount = " + blunderbussPelletCount + "\n");
            writer.write("# Durability (applied on restart)\n");
            writer.write("blunderbussDurability = " + blunderbussDurability + "\n");
            writer.write("\n");
            writer.write("# Pistol\n");
            writer.write("\n");
            writer.write("# Standard deviation of bullet spread (in degrees)\n");
            writer.write("pistolBulletStdDev = " + pistolBulletStdDev + "\n");
            writer.write("# Muzzle velocity of bullet (in blocks per second)\n");
            writer.write("pistolBulletSpeed = " + pistolBulletSpeed + "\n");
            writer.write("# Damage at point-blank range\n");
            writer.write("pistolDamage = " + pistolDamage + "\n");
            writer.write("# Loading time reduction per Quick Charge level (in seconds)\n");
            writer.write("reductionPerQuickChargeLevel = " + reductionPerQuickChargeLevel + "\n");
            writer.write("# Durability (applied on restart)\n");
            writer.write("pistolDurability = " + pistolDurability + "\n");
            writer.write("\n");
            writer.write("# Dispenser\n");
            writer.write("\n");
            writer.write("# Standard deviation of bullet spread (in degrees)\n");
            writer.write("dispenserBulletStdDev = " + dispenserBulletStdDev + "\n");
            writer.write("# Muzzle velocity of bullet (in blocks per second)\n");
            writer.write("dispenserBulletSpeed = " + dispenserBulletSpeed + "\n");
            writer.write("# Damage at point-blank range\n");
            writer.write("dispenserDamage = " + dispenserDamage + "\n");
        }
        catch (IOException e) {
            logger.warn("Could not save configuration file: ", (Throwable)e);
        }
    }
}

