/*
 * Decompiled with CFR 0.152.
 */
package ewewukek.musketmod;

import ewewukek.musketmod.BulletEntity;
import ewewukek.musketmod.Config;
import ewewukek.musketmod.Items;
import ewewukek.musketmod.MusketMod;
import ewewukek.musketmod.Sounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.Score;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.criteria.ObjectiveCriteria;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public abstract class GunItem
extends Item {
    public static ItemStack activeMainHandStack;
    public static ItemStack activeOffhandStack;

    public GunItem(Item.Properties properties) {
        super(properties);
    }

    public abstract float bulletStdDev();

    public abstract float bulletSpeed();

    public abstract float damage();

    public abstract SoundEvent fireSound(ItemStack var1);

    public int pelletCount() {
        return 1;
    }

    public boolean twoHanded() {
        return true;
    }

    public float bulletDropReduction() {
        return 0.0f;
    }

    public int hitDurabilityDamage() {
        return 1;
    }

    @Deprecated
    public SoundEvent fireSound() {
        return this.fireSound(ItemStack.f_41583_);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean canUse(LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player.m_150110_().f_35937_) {
                return true;
            }
        }
        boolean bl = false;
        boolean creative = bl;
        if (creative) return true;
        if (entity.m_204029_(FluidTags.f_13131_)) return false;
        if (entity.m_204029_(FluidTags.f_13132_)) return false;
        return true;
    }

    public boolean canUseFrom(LivingEntity entity, InteractionHand hand) {
        Item item;
        if (hand == InteractionHand.MAIN_HAND) {
            return true;
        }
        if (this.twoHanded()) {
            return false;
        }
        ItemStack stack = entity.m_21205_();
        if (!stack.m_41619_() && (item = stack.m_41720_()) instanceof GunItem) {
            GunItem gun = (GunItem)item;
            return !gun.twoHanded();
        }
        return true;
    }

    public static boolean isInHand(LivingEntity entity, InteractionHand hand) {
        ItemStack stack = entity.m_21120_(hand);
        if (stack.m_41619_()) {
            return false;
        }
        Item item = stack.m_41720_();
        if (item instanceof GunItem) {
            GunItem gun = (GunItem)item;
            return gun.canUseFrom(entity, hand);
        }
        return false;
    }

    public static boolean isHoldingGun(LivingEntity entity) {
        return GunItem.getHoldingHand(entity) != null;
    }

    @Nullable
    public static InteractionHand getHoldingHand(LivingEntity entity) {
        if (GunItem.isInHand(entity, InteractionHand.MAIN_HAND)) {
            return InteractionHand.MAIN_HAND;
        }
        if (GunItem.isInHand(entity, InteractionHand.OFF_HAND)) {
            return InteractionHand.OFF_HAND;
        }
        return null;
    }

    public Vec3 smokeOffsetFor(LivingEntity entity, InteractionHand hand) {
        HumanoidArm arm = hand == InteractionHand.MAIN_HAND ? entity.m_5737_() : entity.m_5737_().m_20828_();
        return this.smokeOffsetFor(entity, arm);
    }

    public Vec3 smokeOffsetFor(LivingEntity entity, HumanoidArm arm) {
        boolean isRightHand = arm == HumanoidArm.RIGHT;
        Vec3 side = Vec3.m_82498_((float)0.0f, (float)(entity.m_146908_() + (float)(isRightHand ? 90 : -90)));
        Vec3 down = Vec3.m_82498_((float)(entity.m_146909_() + 90.0f), (float)entity.m_146908_());
        return side.m_82549_(down).m_82490_(0.15);
    }

    public static boolean hasFlame(ItemStack stack) {
        return EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44990_, (ItemStack)stack) > 0;
    }

    public static boolean hasInfinity(ItemStack stack) {
        return EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44952_, (ItemStack)stack) > 0;
    }

    public static int getPowerLevel(ItemStack stack) {
        return EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44988_, (ItemStack)stack);
    }

    public static int getQuickChargeLevel(ItemStack stack) {
        return EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44960_, (ItemStack)stack);
    }

    public static Pair<Integer, Integer> getLoadingDuration(ItemStack stack) {
        int stages = Config.loadingStages;
        float total = (float)stages * Config.loadingStageDuration;
        int level = GunItem.getQuickChargeLevel(stack);
        float reduction = (float)level * Config.reductionPerQuickChargeLevel;
        float duration = (total - reduction) / (float)stages;
        if (duration < 0.25f) {
            duration = 0.25f;
        }
        if (level == 3) {
            --stages;
        }
        return Pair.of((Object)stages, (Object)((int)(20.0f * duration)));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack offhandStack;
        Item item;
        ItemStack stack = player.m_21120_(hand);
        if (!GunItem.canUse((LivingEntity)player) || !this.canUseFrom((LivingEntity)player, hand)) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        if (GunItem.isLoaded(stack)) {
            if (!level.f_46443_) {
                Vec3 direction = Vec3.m_82498_((float)player.m_146909_(), (float)player.m_146908_());
                this.fire((LivingEntity)player, stack, direction, this.smokeOffsetFor((LivingEntity)player, hand));
            }
            player.m_5496_(this.fireSound(stack), 3.5f, 1.0f);
            GunItem.setLoaded(stack, false);
            stack.m_41622_(1, (LivingEntity)player, ent -> ent.m_21190_(hand));
            player.m_21253_();
            if (level.f_46443_) {
                GunItem.setActiveStack(hand, stack);
            }
            return InteractionResultHolder.m_19096_((Object)stack);
        }
        if (hand == InteractionHand.MAIN_HAND && (item = (offhandStack = player.m_21206_()).m_41720_()) instanceof GunItem) {
            GunItem offhandGun = (GunItem)item;
            if (GunItem.isLoaded(offhandStack) && offhandGun.canUseFrom((LivingEntity)player, InteractionHand.OFF_HAND)) {
                return InteractionResultHolder.m_19098_((Object)stack);
            }
        }
        if (GunItem.getLoadingStage(stack) == 0) {
            if (!GunItem.checkAmmo(player, stack)) {
                return InteractionResultHolder.m_19100_((Object)stack);
            }
            GunItem.setLoadingStage(stack, 1);
        } else {
            int loadingStages = (Integer)GunItem.getLoadingDuration(stack).getLeft();
            if (GunItem.getLoadingStage(stack) == loadingStages) {
                GunItem.setLoadingStage(stack, loadingStages + 1);
            }
        }
        player.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)stack);
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.CROSSBOW;
    }

    public static Vec3 addSpread(Vec3 direction, RandomSource random, float spreadStdDev) {
        float gaussian = Math.abs((float)random.m_188583_());
        if (gaussian > 4.0f) {
            gaussian = 4.0f;
        }
        float error = (float)Math.toRadians(spreadStdDev) * gaussian;
        return GunItem.applyError(direction, random, error);
    }

    public static Vec3 addUniformSpread(Vec3 direction, RandomSource random, float spread) {
        float error = (float)Math.toRadians(spread) * random.m_188501_();
        return GunItem.applyError(direction, random, error);
    }

    public static Vec3 applyError(Vec3 direction, RandomSource random, float coneAngle) {
        Vec3 n2;
        Vec3 n1;
        if (Math.abs(direction.f_82479_) < 1.0E-5 && Math.abs(direction.f_82481_) < 1.0E-5) {
            n1 = new Vec3(1.0, 0.0, 0.0);
            n2 = new Vec3(0.0, 0.0, 1.0);
        } else {
            n1 = new Vec3(-direction.f_82481_, 0.0, direction.f_82479_).m_82541_();
            n2 = direction.m_82537_(n1);
        }
        float angle = (float)Math.PI * 2 * random.m_188501_();
        return direction.m_82490_((double)Mth.m_14089_((float)coneAngle)).m_82549_(n1.m_82490_((double)(Mth.m_14031_((float)coneAngle) * Mth.m_14031_((float)angle)))).m_82549_(n2.m_82490_((double)(Mth.m_14031_((float)coneAngle) * Mth.m_14089_((float)angle))));
    }

    public Vec3 aimAt(LivingEntity entity, LivingEntity target) {
        double dist = entity.m_20270_((Entity)target);
        double ticks = 20.0 * dist / (double)this.bulletSpeed();
        double bulletDrop = 0.5 * ticks * ticks * 0.05;
        Vec3 pos = new Vec3(target.m_20185_(), 0.5 * (target.m_20188_() + target.m_20227_(0.5)), target.m_20189_());
        return new Vec3(pos.m_7096_() - entity.m_20185_(), pos.m_7098_() + bulletDrop - entity.m_20188_(), pos.m_7094_() - entity.m_20189_()).m_82541_();
    }

    public void mobUse(LivingEntity entity, InteractionHand hand, Vec3 direction) {
        ItemStack stack = entity.m_21120_(hand);
        HumanoidArm arm = entity.m_5737_();
        if (hand == InteractionHand.OFF_HAND) {
            arm = arm.m_20828_();
        }
        this.mobUse(entity, stack, direction, this.smokeOffsetFor(entity, arm));
    }

    public void mobUse(LivingEntity entity, ItemStack stack, Vec3 direction, Vec3 smokeOffset) {
        Level level = entity.m_9236_();
        if (level.f_46443_) {
            return;
        }
        if (!GunItem.isLoaded(stack)) {
            return;
        }
        this.fire(entity, stack, direction, smokeOffset);
        entity.m_5496_(this.fireSound(stack), 3.5f, 1.0f);
        GunItem.setLoaded(stack, false);
    }

    public static int reloadDuration(ItemStack stack) {
        Pair<Integer, Integer> loadingDuration = GunItem.getLoadingDuration(stack);
        int loadingStages = (Integer)loadingDuration.getLeft();
        int ticksPerLoadingStage = (Integer)loadingDuration.getRight();
        int loadingStagesRemaining = 1 + loadingStages - GunItem.getLoadingStage(stack);
        return Math.max(0, loadingStagesRemaining) * ticksPerLoadingStage;
    }

    public static boolean checkAmmo(Player player, ItemStack stack) {
        if (player.m_150110_().f_35937_ || GunItem.hasInfinity(stack)) {
            return true;
        }
        ItemStack ammoStack = GunItem.findAmmo(player);
        return !ammoStack.m_41619_();
    }

    public static void consumeAmmo(Player player, ItemStack stack) {
        if (player.m_150110_().f_35937_ || GunItem.hasInfinity(stack)) {
            return;
        }
        ItemStack ammoStack = GunItem.findAmmo(player);
        ammoStack.m_41774_(1);
        if (ammoStack.m_41619_()) {
            player.m_150109_().m_36057_(ammoStack);
        }
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity entity, int ticksLeft) {
        if (GunItem.isLoaded(stack)) {
            GunItem.setLoadingStage(stack, 0);
        } else {
            int usingTicks = this.m_8105_(stack) - ticksLeft;
            int ticksPerLoadingStage = (Integer)GunItem.getLoadingDuration(stack).getRight();
            int prevLoadingStage = GunItem.getLoadingStage(stack);
            int loadingStage = prevLoadingStage + usingTicks / ticksPerLoadingStage;
            if (prevLoadingStage == 1) {
                if (loadingStage == 1) {
                    GunItem.setLoadingStage(stack, 0);
                } else if (!GunItem.isLoaded(stack) && entity instanceof Player) {
                    Player player = (Player)entity;
                    GunItem.consumeAmmo(player, stack);
                }
            }
            GunItem.setLoadingStage(stack, loadingStage);
        }
    }

    public void m_5929_(Level level, LivingEntity entity, ItemStack stack, int ticksLeft) {
        Pair<Integer, Integer> loadingDuration = GunItem.getLoadingDuration(stack);
        int loadingStages = (Integer)loadingDuration.getLeft();
        int ticksPerLoadingStage = (Integer)loadingDuration.getRight();
        int usingTicks = this.m_8105_(stack) - ticksLeft;
        int prevLoadingStage = GunItem.getLoadingStage(stack);
        int loadingStage = prevLoadingStage + usingTicks / ticksPerLoadingStage;
        if (loadingStage < loadingStages && usingTicks == ticksPerLoadingStage / 2) {
            entity.m_5496_(Sounds.MUSKET_LOAD_0, 0.8f, 1.0f);
        }
        if (usingTicks > 0 && usingTicks % ticksPerLoadingStage == 0) {
            if (loadingStage < loadingStages) {
                entity.m_5496_(Sounds.MUSKET_LOAD_1, 0.8f, 1.0f);
            } else if (loadingStage == loadingStages) {
                entity.m_5496_(Sounds.MUSKET_LOAD_2, 0.8f, 1.0f);
            }
        }
        if (level.f_46443_ && entity instanceof Player) {
            GunItem.setActiveStack(entity.m_7655_(), stack);
            return;
        }
        if (loadingStage > loadingStages && !GunItem.isLoaded(stack)) {
            level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), Sounds.MUSKET_READY, entity.m_5720_(), 0.8f, 1.0f);
            if (prevLoadingStage == 1 && entity instanceof Player) {
                Player player = (Player)entity;
                GunItem.consumeAmmo(player, stack);
            }
            GunItem.setLoaded(stack, true);
        }
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity entity) {
        stack.m_41622_(this.hitDurabilityDamage(), entity, ent -> ent.m_21166_(EquipmentSlot.MAINHAND));
        return false;
    }

    public boolean m_6813_(ItemStack stack, Level level, BlockState blockState, BlockPos blockPos, LivingEntity entity) {
        if (blockState.m_60800_((BlockGetter)level, blockPos) != 0.0f) {
            stack.m_41622_(this.hitDurabilityDamage(), entity, ent -> ent.m_21166_(EquipmentSlot.MAINHAND));
        }
        return false;
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public int m_6473_() {
        return 14;
    }

    @Deprecated
    public void fire(LivingEntity entity, Vec3 direction) {
        ItemStack stack = entity.m_21205_();
        InteractionHand hand = InteractionHand.MAIN_HAND;
        if (!(stack.m_41720_() instanceof GunItem)) {
            stack = entity.m_21206_();
            hand = InteractionHand.OFF_HAND;
        }
        this.fire(entity, stack, direction, this.smokeOffsetFor(entity, hand));
    }

    public void fire(LivingEntity entity, ItemStack stack, Vec3 direction, Vec3 smokeOffset) {
        Level level = entity.m_9236_();
        Vec3 origin = new Vec3(entity.m_20185_(), entity.m_20188_(), entity.m_20189_());
        boolean flame = GunItem.hasFlame(stack);
        float damage = this.damage() + Config.damagePerPowerLevel * (float)GunItem.getPowerLevel(stack);
        for (int i = 0; i < this.pelletCount(); ++i) {
            BulletEntity bullet = new BulletEntity(level);
            bullet.m_5602_((Entity)entity);
            bullet.m_146884_(origin);
            bullet.setVelocity(this.bulletSpeed(), GunItem.addSpread(direction, entity.m_217043_(), this.bulletStdDev()));
            bullet.damage = damage;
            bullet.setDropReduction(this.bulletDropReduction());
            bullet.setPelletCount(this.pelletCount());
            if (flame) {
                bullet.m_20254_(100);
                bullet.m_146868_(true);
            }
            level.m_7967_((Entity)bullet);
        }
        MusketMod.sendSmokeEffect((ServerLevel)level, origin.m_82549_(smokeOffset), direction);
    }

    public static void fireParticles(Level level, Vec3 origin, Vec3 direction) {
        RandomSource random = RandomSource.m_216327_();
        for (int i = 0; i < 10; ++i) {
            double t = Math.pow(random.m_188501_(), 1.5);
            Vec3 p = origin.m_82549_(direction.m_82490_(1.25 + t));
            p = p.m_82549_(new Vec3((double)random.m_188501_() - 0.5, (double)random.m_188501_() - 0.5, (double)random.m_188501_() - 0.5).m_82490_(0.1));
            Vec3 v = direction.m_82490_(0.1 * (1.0 - t));
            level.m_7106_((ParticleOptions)ParticleTypes.f_123759_, p.f_82479_, p.f_82480_, p.f_82481_, v.f_82479_, v.f_82480_, v.f_82481_);
        }
    }

    public static void increaseGunExperience(Player player) {
        String NAME = "gun_experience";
        Scoreboard board = player.m_36329_();
        Objective objective = board.m_83477_("gun_experience");
        if (objective == null) {
            objective = board.m_83436_("gun_experience", ObjectiveCriteria.f_83588_, (Component)Component.m_237113_((String)"gun_experience"), ObjectiveCriteria.RenderType.INTEGER);
        }
        Score score = board.m_83471_(player.m_6302_(), objective);
        score.m_83392_();
    }

    public static ItemStack getActiveStack(InteractionHand hand) {
        if (hand == InteractionHand.MAIN_HAND) {
            return activeMainHandStack;
        }
        return activeOffhandStack;
    }

    public static void setActiveStack(InteractionHand hand, ItemStack stack) {
        if (hand == InteractionHand.MAIN_HAND) {
            activeMainHandStack = stack;
        } else {
            activeOffhandStack = stack;
        }
    }

    public static boolean isAmmo(ItemStack stack) {
        return stack.m_41720_() == Items.CARTRIDGE;
    }

    public static ItemStack findAmmo(Player player) {
        ItemStack stack = player.m_6844_(EquipmentSlot.OFFHAND);
        if (GunItem.isAmmo(stack)) {
            return stack;
        }
        stack = player.m_6844_(EquipmentSlot.MAINHAND);
        if (GunItem.isAmmo(stack)) {
            return stack;
        }
        int size = player.m_150109_().m_6643_();
        for (int i = 0; i < size; ++i) {
            stack = player.m_150109_().m_8020_(i);
            if (!GunItem.isAmmo(stack)) continue;
            return stack;
        }
        return ItemStack.f_41583_;
    }

    public static boolean isReady(ItemStack stack) {
        return GunItem.isLoaded(stack) && GunItem.getLoadingStage(stack) == 0;
    }

    public static boolean isLoaded(ItemStack stack) {
        return stack.m_41784_().m_128445_("loaded") != 0;
    }

    public static void setLoaded(ItemStack stack, boolean loaded) {
        if (loaded) {
            stack.m_41784_().m_128344_("loaded", (byte)1);
        } else {
            stack.m_41784_().m_128473_("loaded");
        }
    }

    public static int getLoadingStage(ItemStack stack) {
        return stack.m_41784_().m_128451_("loadingStage");
    }

    public static void setLoadingStage(ItemStack stack, int loadingStage) {
        if (loadingStage > 0) {
            stack.m_41784_().m_128405_("loadingStage", loadingStage);
        } else {
            stack.m_41784_().m_128473_("loadingStage");
        }
    }
}

