/*
 * Decompiled with CFR 0.152.
 */
package ewewukek.musketmod;

import ewewukek.musketmod.BulletEntity;
import ewewukek.musketmod.ClientSetup;
import ewewukek.musketmod.Config;
import ewewukek.musketmod.DeferredDamage;
import ewewukek.musketmod.Items;
import ewewukek.musketmod.ModLootModifier;
import ewewukek.musketmod.Sounds;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.Unit;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;

@Mod(value="musketmod")
public class MusketMod {
    public static final String MODID = "musketmod";
    public static final Path CONFIG_PATH = FMLPaths.CONFIGDIR.get().resolve("musketmod.txt");
    public static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel NETWORK_CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)MusketMod.resource("main"), () -> "1", "1"::equals, "1"::equals);

    public static ResourceLocation resource(String path) {
        return new ResourceLocation(MODID, path);
    }

    public MusketMod() {
        Config.load();
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::register);
        bus.addListener(this::creativeTabs);
        MinecraftForge.EVENT_BUS.addListener(this::worldTick);
        MinecraftForge.EVENT_BUS.addListener(this::reload);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> new ClientSetup(bus));
        NETWORK_CHANNEL.registerMessage(1, SmokeEffectPacket.class, SmokeEffectPacket::encode, SmokeEffectPacket::new, SmokeEffectPacket::handle);
    }

    public void register(RegisterEvent event) {
        Items.register((path, item) -> event.register(Registries.f_256913_, MusketMod.resource(path), () -> item));
        Sounds.register(sound -> event.register(Registries.f_256840_, sound.m_11660_(), () -> sound));
        event.register(ForgeRegistries.Keys.ENTITY_TYPES, helper -> {
            BulletEntity.ENTITY_TYPE = EntityType.Builder.m_20704_(BulletEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.5f, 0.5f).setTrackingRange(64).setUpdateInterval(20).setShouldReceiveVelocityUpdates(false).m_20712_("bullet");
            helper.register(MusketMod.resource("bullet"), BulletEntity.ENTITY_TYPE);
        });
        event.register(ForgeRegistries.Keys.GLOBAL_LOOT_MODIFIER_SERIALIZERS, MusketMod.resource("loot_modifier"), () -> ModLootModifier.CODEC);
    }

    public void creativeTabs(BuildCreativeModeTabContentsEvent event) {
        Items.addToCreativeTab((ResourceKey<CreativeModeTab>)event.getTabKey(), item -> event.m_246326_((ItemLike)item));
    }

    public void worldTick(TickEvent.LevelTickEvent event) {
        if (event.side == LogicalSide.SERVER && event.phase == TickEvent.Phase.END) {
            DeferredDamage.apply();
        }
    }

    public void reload(AddReloadListenerEvent event) {
        event.addListener(new PreparableReloadListener(){

            public CompletableFuture<Void> m_5540_(PreparableReloadListener.PreparationBarrier stage, ResourceManager resourceManager, ProfilerFiller preparationsProfiler, ProfilerFiller reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
                return stage.m_6769_((Object)Unit.INSTANCE).thenRunAsync(() -> Config.load(), gameExecutor);
            }
        });
    }

    public static void disableVelocityUpdate(EntityType.Builder<?> builder) {
        builder.setShouldReceiveVelocityUpdates(false);
    }

    public static void sendSmokeEffect(ServerLevel level, Vec3 origin, Vec3 direction) {
        PacketDistributor.TargetPoint point = new PacketDistributor.TargetPoint(origin.f_82479_, origin.f_82480_, origin.f_82481_, 64.0, level.m_46472_());
        NETWORK_CHANNEL.send(PacketDistributor.NEAR.with(() -> point), (Object)new SmokeEffectPacket(origin, direction));
    }

    public static class SmokeEffectPacket {
        public final Vec3 origin;
        public final Vec3 direction;

        public SmokeEffectPacket(Vec3 origin, Vec3 direction) {
            this.origin = origin;
            this.direction = direction;
        }

        public SmokeEffectPacket(FriendlyByteBuf buf) {
            this.origin = new Vec3((double)buf.readFloat(), (double)buf.readFloat(), (double)buf.readFloat());
            this.direction = new Vec3((double)buf.readFloat(), (double)buf.readFloat(), (double)buf.readFloat());
        }

        public void encode(FriendlyByteBuf buf) {
            buf.writeFloat((float)this.origin.f_82479_);
            buf.writeFloat((float)this.origin.f_82480_);
            buf.writeFloat((float)this.origin.f_82481_);
            buf.writeFloat((float)this.direction.f_82479_);
            buf.writeFloat((float)this.direction.f_82480_);
            buf.writeFloat((float)this.direction.f_82481_);
        }

        public void handle(Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> this.lambda$handle$1((Supplier)ctx)));
            ctx.get().setPacketHandled(true);
        }

        private /* synthetic */ Runnable lambda$handle$1(Supplier ctx) {
            return () -> this.lambda$handle$0((Supplier)ctx);
        }

        private /* synthetic */ void lambda$handle$0(Supplier ctx) {
            ClientSetup.handleSmokeEffectPacket(this, ctx);
        }
    }
}

