/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.munitions.fragment_burst;

import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import rbasamoyai.createbigcannons.CreateBigCannons;
import rbasamoyai.createbigcannons.config.CBCConfigs;
import rbasamoyai.createbigcannons.index.CBCMunitionPropertiesHandlers;
import rbasamoyai.createbigcannons.munitions.AbstractCannonProjectile;
import rbasamoyai.createbigcannons.munitions.config.DimensionMunitionPropertiesHandler;
import rbasamoyai.createbigcannons.munitions.config.components.BallisticPropertiesComponent;
import rbasamoyai.createbigcannons.munitions.fragment_burst.ProjectileBurstProperties;
import rbasamoyai.ritchiesprojectilelib.RitchiesProjectileLib;
import rbasamoyai.ritchiesprojectilelib.projectile_burst.ProjectileBurst;

public abstract class CBCProjectileBurst
extends ProjectileBurst {
    protected CBCProjectileBurst(EntityType<? extends CBCProjectileBurst> entityType, Level level) {
        super(entityType, level);
    }

    protected void applyForces(double[] velocity, double[] displacement) {
        double length = Math.sqrt(velocity[0] * velocity[0] + velocity[1] * velocity[1] + velocity[2] * velocity[2]);
        double drag = length < 0.01 ? 1.0 : this.getDragCoefficient(length) / length;
        velocity[0] = velocity[0] - velocity[0] * drag;
        velocity[1] = velocity[1] - velocity[1] * drag;
        velocity[2] = velocity[2] - velocity[2] * drag;
        velocity[1] = velocity[1] + this.getGravity();
    }

    public void m_8119_() {
        super.m_8119_();
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel slevel = (ServerLevel)level;
            if (!this.m_213877_() && ((Boolean)CBCConfigs.server().munitions.projectilesCanChunkload.get()).booleanValue()) {
                ChunkPos cpos1 = new ChunkPos(this.m_20183_());
                RitchiesProjectileLib.queueForceLoad((ServerLevel)slevel, (int)cpos1.f_45578_, (int)cpos1.f_45579_);
            }
        }
    }

    protected double getDragCoefficient(double magnitude) {
        BallisticPropertiesComponent properties = this.getProperties().ballistics();
        double drag = properties.drag() * DimensionMunitionPropertiesHandler.getProperties(this.m_9236_()).dragMultiplier() * magnitude;
        if (properties.isQuadraticDrag()) {
            drag *= magnitude;
        }
        return Math.min(drag, magnitude);
    }

    protected double getGravity() {
        BallisticPropertiesComponent properties = this.getProperties().ballistics();
        return properties.gravity() * DimensionMunitionPropertiesHandler.getProperties(this.m_9236_()).gravityMultiplier();
    }

    public boolean m_5603_(Entity target) {
        if (target instanceof AbstractCannonProjectile) {
            return false;
        }
        return super.m_5603_(target);
    }

    public static <T extends ProjectileBurst> T spawnConeBurst(Level level, EntityType<T> type, Vec3 position, Vec3 initialVelocity, int count, double spread) {
        ProjectileBurst burst = (ProjectileBurst)type.m_20615_(level);
        burst.m_146884_(position);
        Vec3 forward = initialVelocity.m_82541_();
        Vec3 right = forward.m_82537_(new Vec3(Direction.UP.m_253071_()));
        Vec3 up = forward.m_82537_(right);
        double length = initialVelocity.m_82553_();
        RandomSource random = level.m_213780_();
        for (int i = 0; i < count; ++i) {
            double velScale = length * (1.4 + 0.2 * random.m_188500_());
            double rx = (random.m_188500_() - random.m_188500_()) * 0.0625;
            double ry = (random.m_188500_() - random.m_188500_()) * 0.0625;
            double rz = (random.m_188500_() - random.m_188500_()) * 0.0625;
            Vec3 vel = forward.m_82490_(velScale).m_82549_(right.m_82490_((random.m_188500_() - random.m_188500_()) * velScale * spread)).m_82549_(up.m_82490_((random.m_188500_() - random.m_188500_()) * velScale * spread));
            burst.addSubProjectile(rx, ry, rz, vel.f_82479_, vel.f_82480_, vel.f_82481_);
        }
        if (burst.getSubProjectileCount() != count) {
            CreateBigCannons.LOGGER.info("Projectile burst failed to spawn {} out of {} projectiles", (Object)(count - burst.getSubProjectileCount()), (Object)count);
        }
        level.m_7967_((Entity)burst);
        return (T)burst;
    }

    protected int getLifetime() {
        return this.getProperties().lifetime();
    }

    protected ProjectileBurstProperties getProperties() {
        return (ProjectileBurstProperties)CBCMunitionPropertiesHandlers.PROJECTILE_BURST.getPropertiesOf((Entity)this);
    }
}

