/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.darkdoppelganger.entity;

import io.redspace.ironsspellbooks.api.entity.IMagicEntity;
import io.redspace.ironsspellbooks.api.registry.AttributeRegistry;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.entity.mobs.IAnimatedAttacker;
import io.redspace.ironsspellbooks.entity.mobs.abstract_spell_casting_mob.AbstractSpellCastingMob;
import io.redspace.ironsspellbooks.entity.mobs.goals.AttackAnimationData;
import io.redspace.ironsspellbooks.entity.mobs.goals.PatrolNearLocationGoal;
import io.redspace.ironsspellbooks.entity.mobs.goals.SpellBarrageGoal;
import io.redspace.ironsspellbooks.entity.mobs.wizards.GenericAnimatedWarlockAttackGoal;
import io.redspace.ironsspellbooks.registries.MobEffectRegistry;
import io.redspace.ironsspellbooks.spells.NoneSpell;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import net.bandit.darkdoppelganger.Config;
import net.bandit.darkdoppelganger.DarkDoppelgangerMod;
import net.bandit.darkdoppelganger.entity.DarkDoppelgangerMinionEntity;
import net.bandit.darkdoppelganger.entity.EntityRegistry;
import net.bandit.darkdoppelganger.entity.PortalJoinEntity;
import net.bandit.darkdoppelganger.registry.ItemRegistry;
import net.bandit.darkdoppelganger.registry.ModSounds;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.advancements.Advancement;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundStopSoundPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.Team;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class DarkDoppelgangerEntity
extends AbstractSpellCastingMob
implements Enemy,
IAnimatedAttacker {
    @Nullable
    private Player summonerPlayer;
    private final ServerBossEvent bossEvent;
    private boolean secondPhaseTriggered = false;
    private boolean thirdPhaseTriggered = false;
    public boolean isClone = false;
    private boolean musicPlaying = false;
    private int minionSummonCooldown = 700;
    private int lifeDrainCooldown = 150;
    private int roarSoundCooldown = 800;
    private int laughSoundCooldown = 800;
    private final List<UUID> activeMinionUUIDs = new ArrayList<UUID>();
    private final int MAX_MINIONS = 3;
    private int laughCooldown = 800;
    private int age;
    private int musicTimer = 0;
    private static final int MUSIC_DURATION = 6160;
    private boolean hasFallenIntoVoid = false;
    private int teleportCooldown = 0;
    RawAnimation animationToPlay = null;
    private final RawAnimation ANIMATION_SPAWN = RawAnimation.begin().thenPlay("join_1");
    private final AnimationController<DarkDoppelgangerEntity> meleeController = new AnimationController((GeoAnimatable)this, "keeper_animations", 0, this::predicate);
    private final AnimationController<DarkDoppelgangerEntity> spawnController = new AnimationController((GeoAnimatable)this, "spawn_animations", 0, this::spawnPredicate);

    public DarkDoppelgangerEntity(EntityType<? extends AbstractSpellCastingMob> type, Level world) {
        super(type, world);
        this.m_6593_((Component)Component.m_237113_((String)"Dark Doppelganger"));
        this.bossEvent = new ServerBossEvent((Component)Component.m_237113_((String)"Dark Doppelganger"), BossEvent.BossBarColor.PURPLE, BossEvent.BossBarOverlay.PROGRESS);
        this.f_21365_ = this.createLookControl();
        this.f_21342_ = this.createMoveControl();
    }

    protected LookControl createLookControl() {
        return new LookControl((Mob)this){

            protected float m_24956_(float pFrom, float pTo, float pMaxDelta) {
                return super.m_24956_(pFrom, pTo, pMaxDelta * 2.5f);
            }

            protected boolean m_8106_() {
                return DarkDoppelgangerEntity.this.m_5448_() == null;
            }
        };
    }

    protected MoveControl createMoveControl() {
        return new MoveControl((Mob)this){

            protected float m_24991_(float pSourceAngle, float pTargetAngle, float pMaximumChange) {
                double d1;
                double d0 = this.f_24975_ - this.f_24974_.m_20185_();
                if (d0 * d0 + (d1 = this.f_24977_ - this.f_24974_.m_20189_()) * d1 < 0.5) {
                    return pSourceAngle;
                }
                return super.m_24991_(pSourceAngle, pTargetAngle, pMaximumChange * 0.25f);
            }
        };
    }

    public void setSummonerPlayer(Player summoner) {
        this.summonerPlayer = summoner;
        if (summoner != null) {
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                this.m_8061_(slot, summoner.m_6844_(slot));
            }
            this.copyAttribute((Attribute)AttributeRegistry.HOLY_SPELL_POWER.get());
            this.copyAttribute((Attribute)AttributeRegistry.BLOOD_SPELL_POWER.get());
            this.copyAttribute((Attribute)AttributeRegistry.NATURE_SPELL_POWER.get());
            this.copyAttribute((Attribute)AttributeRegistry.ELDRITCH_SPELL_POWER.get());
            this.copyAttribute((Attribute)AttributeRegistry.FIRE_SPELL_POWER.get());
            this.copyAttribute((Attribute)AttributeRegistry.ICE_SPELL_POWER.get());
            this.copyAttribute((Attribute)AttributeRegistry.LIGHTNING_SPELL_POWER.get());
            this.copyAttribute((Attribute)AttributeRegistry.EVOCATION_SPELL_POWER.get());
            this.copyAttribute((Attribute)AttributeRegistry.ENDER_SPELL_POWER.get());
            this.copyAttribute((Attribute)AttributeRegistry.SPELL_POWER.get());
            if (((Boolean)Config.DOPPLEGANGER_HARD_MODE.get()).booleanValue()) {
                this.m_21051_((Attribute)AttributeRegistry.HOLY_MAGIC_RESIST.get()).m_22100_((double)1.3f);
                this.m_21051_((Attribute)AttributeRegistry.FIRE_MAGIC_RESIST.get()).m_22100_(1.5);
                this.m_21051_((Attribute)AttributeRegistry.BLOOD_MAGIC_RESIST.get()).m_22100_(1.5);
                this.m_21051_((Attribute)AttributeRegistry.NATURE_MAGIC_RESIST.get()).m_22100_((double)1.4f);
                this.m_21051_((Attribute)AttributeRegistry.ELDRITCH_MAGIC_RESIST.get()).m_22100_((double)1.6f);
                this.m_21051_((Attribute)AttributeRegistry.ICE_MAGIC_RESIST.get()).m_22100_((double)1.4f);
                this.m_21051_((Attribute)AttributeRegistry.LIGHTNING_MAGIC_RESIST.get()).m_22100_((double)1.4f);
                this.m_21051_((Attribute)AttributeRegistry.EVOCATION_MAGIC_RESIST.get()).m_22100_((double)1.3f);
                this.m_21051_((Attribute)AttributeRegistry.ENDER_MAGIC_RESIST.get()).m_22100_((double)1.4f);
                this.m_21051_((Attribute)AttributeRegistry.SPELL_RESIST.get()).m_22100_(1.5);
            }
        }
    }

    protected void m_8099_() {
        this.setFirstPhaseGoals();
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    protected void setFirstPhaseGoals() {
        this.f_21345_.m_25386_().forEach(WrappedGoal::m_8041_);
        this.f_21345_.m_262460_(x -> true);
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new SpellBarrageGoal((IMagicEntity)this, (AbstractSpell)SpellRegistry.DEVOUR_SPELL.get(), 3, 6, 100, 250, 1));
        this.f_21345_.m_25352_(3, (Goal)new GenericAnimatedWarlockAttackGoal((PathfinderMob)this, 1.25, 50, 75, 3.0f).setMoveset(List.of(new AttackAnimationData(9, "simple_sword_upward_swipe", new int[]{5}), new AttackAnimationData(8, "simple_sword_lunge_stab", new int[]{6}), new AttackAnimationData(10, "simple_sword_stab_alternate", new int[]{8}), new AttackAnimationData(10, "simple_sword_horizontal_cross_swipe", new int[]{8}))).setComboChance(0.4f).setMeleeAttackInverval(10, 30).setMeleeMovespeedModifier(1.5f).setSpells(List.of((AbstractSpell)SpellRegistry.GUIDING_BOLT_SPELL.get(), (AbstractSpell)SpellRegistry.BLOOD_NEEDLES_SPELL.get(), (AbstractSpell)SpellRegistry.BLOOD_SLASH_SPELL.get()), List.of((AbstractSpell)SpellRegistry.FANG_WARD_SPELL.get(), (AbstractSpell)SpellRegistry.GUST_SPELL.get()), List.of((AbstractSpell)SpellRegistry.BURNING_DASH_SPELL.get()), List.of((AbstractSpell)SpellRegistry.BLIGHT_SPELL.get(), (AbstractSpell)SpellRegistry.INVISIBILITY_SPELL.get())));
        this.f_21345_.m_25352_(4, (Goal)new PatrolNearLocationGoal((PathfinderMob)this, 30.0f, 0.75));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
    }

    protected void setSecondPhaseGoals() {
        this.f_21345_.m_25386_().forEach(WrappedGoal::m_8041_);
        this.f_21345_.m_262460_(x -> true);
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new SpellBarrageGoal((IMagicEntity)this, (AbstractSpell)SpellRegistry.FIREBALL_SPELL.get(), 3, 5, 100, 250, 1));
        this.f_21345_.m_25352_(3, (Goal)new GenericAnimatedWarlockAttackGoal((PathfinderMob)this, 1.25, 50, 75, 3.0f).setMoveset(List.of(new AttackAnimationData(9, "simple_sword_upward_swipe", new int[]{5}), new AttackAnimationData(8, "simple_sword_lunge_stab", new int[]{6}), new AttackAnimationData(10, "simple_sword_stab_alternate", new int[]{8}), new AttackAnimationData(10, "simple_sword_horizontal_cross_swipe", new int[]{8}))).setComboChance(0.4f).setMeleeAttackInverval(10, 30).setMeleeMovespeedModifier(1.5f).setSpells(List.of((AbstractSpell)SpellRegistry.MAGIC_ARROW_SPELL.get(), (AbstractSpell)SpellRegistry.POISON_ARROW_SPELL.get(), (AbstractSpell)SpellRegistry.MAGMA_BOMB_SPELL.get()), List.of((AbstractSpell)SpellRegistry.HEAT_SURGE_SPELL.get(), (AbstractSpell)SpellRegistry.FLAMING_STRIKE_SPELL.get()), List.of((AbstractSpell)SpellRegistry.FROST_STEP_SPELL.get()), List.of((AbstractSpell)SpellRegistry.ROOT_SPELL.get(), (AbstractSpell)SpellRegistry.THUNDERSTORM_SPELL.get())));
        this.f_21345_.m_25352_(4, (Goal)new PatrolNearLocationGoal((PathfinderMob)this, 30.0f, 0.75));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
    }

    protected void setThirdPhaseGoals() {
        this.f_21345_.m_25386_().forEach(WrappedGoal::m_8041_);
        this.f_21345_.m_262460_(x -> true);
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new SpellBarrageGoal((IMagicEntity)this, (AbstractSpell)SpellRegistry.RAY_OF_FROST_SPELL.get(), 3, 5, 100, 250, 1));
        this.f_21345_.m_25352_(3, (Goal)new GenericAnimatedWarlockAttackGoal((PathfinderMob)this, 1.25, 50, 75, 3.0f).setMoveset(List.of(new AttackAnimationData(9, "simple_sword_upward_swipe", new int[]{5}), new AttackAnimationData(8, "simple_sword_lunge_stab", new int[]{6}), new AttackAnimationData(10, "simple_sword_stab_alternate", new int[]{8}), new AttackAnimationData(10, "simple_sword_horizontal_cross_swipe", new int[]{8}))).setComboChance(0.4f).setMeleeAttackInverval(10, 30).setMeleeMovespeedModifier(1.5f).setSpells(List.of((AbstractSpell)SpellRegistry.LIGHTNING_LANCE_SPELL.get(), (AbstractSpell)SpellRegistry.STOMP_SPELL.get()), List.of((AbstractSpell)SpellRegistry.SHOCKWAVE_SPELL.get(), (AbstractSpell)SpellRegistry.ASCENSION_SPELL.get()), List.of((AbstractSpell)SpellRegistry.BLOOD_STEP_SPELL.get()), List.of((AbstractSpell)SpellRegistry.EVASION_SPELL.get(), (AbstractSpell)SpellRegistry.ECHOING_STRIKES_SPELL.get())));
        this.f_21345_.m_25352_(4, (Goal)new PatrolNearLocationGoal((PathfinderMob)this, 30.0f, 0.75));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
    }

    protected void setFinalPhaseGoals() {
        this.f_21345_.m_25386_().forEach(WrappedGoal::m_8041_);
        this.f_21345_.m_262460_(x -> true);
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        ArrayList<AbstractSpell> allSpells = new ArrayList<AbstractSpell>(this.getConfiguredSpells((List)Config.DOPPELGANGER_FINAL_PHASE_SPELLS.get()));
        Collections.shuffle(allSpells, new Random(this.m_217043_().m_188505_()));
        AbstractSpell barrageSpell = allSpells.isEmpty() ? (AbstractSpell)SpellRegistry.ELDRITCH_BLAST_SPELL.get() : (AbstractSpell)allSpells.get(0);
        this.f_21345_.m_25352_(2, (Goal)new SpellBarrageGoal((IMagicEntity)this, barrageSpell, 3, 4, 160, 240, 1));
        List<AbstractSpell> group1 = this.getSpellGroup(allSpells, 0, 3);
        List<AbstractSpell> group2 = this.getSpellGroup(allSpells, 3, 3);
        List<AbstractSpell> group3 = this.getSpellGroup(allSpells, 6, 2);
        List<AbstractSpell> group4 = this.getSpellGroup(allSpells, 8, 4);
        this.f_21345_.m_25352_(3, (Goal)new GenericAnimatedWarlockAttackGoal((PathfinderMob)this, (double)1.4f, 30, 50, 3.0f).setMoveset(List.of(new AttackAnimationData(9, "simple_sword_upward_swipe", new int[]{5}), new AttackAnimationData(8, "simple_sword_lunge_stab", new int[]{6}), new AttackAnimationData(10, "simple_sword_stab_alternate", new int[]{8}), new AttackAnimationData(10, "simple_sword_horizontal_cross_swipe", new int[]{8}))).setComboChance(0.4f).setMeleeAttackInverval(10, 20).setMeleeMovespeedModifier(1.7f).setSpells(group1, group2, group3, group4));
        this.f_21345_.m_25352_(5, (Goal)new PatrolNearLocationGoal((PathfinderMob)this, 30.0f, 0.75));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
    }

    private List<AbstractSpell> getSpellGroup(List<AbstractSpell> list, int start, int count) {
        if (start >= list.size()) {
            return List.of();
        }
        return list.subList(start, Math.min(start + count, list.size()));
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        this.m_21530_();
        if (this.isClone) {
            this.m_20049_("dark_doppelganger_clone");
        } else {
            this.m_20049_("dark_doppelganger_boss");
        }
        if (!this.m_9236_().f_46443_) {
            if (!this.isClone && !this.musicPlaying) {
                this.playBossMusic();
            }
            if (!this.isClone) {
                this.adjustAttributesFromConfig();
            }
        } else {
            this.spawnSummoningParticles();
        }
        PortalJoinEntity portal = new PortalJoinEntity((EntityType)EntityRegistry.PORTAL_JOIN_ENTITY.get(), this.m_9236_());
        portal.m_146884_(this.m_20182_());
        portal.m_146922_(this.m_146908_());
        portal.f_19859_ = this.m_146908_();
        this.m_9236_().m_7967_((Entity)portal);
    }

    private void copyAttribute(Attribute attribute) {
        AttributeInstance sourceAttribute = this.summonerPlayer.m_21051_(attribute);
        AttributeInstance targetAttribute = this.m_21051_(attribute);
        if (sourceAttribute != null && targetAttribute != null) {
            targetAttribute.m_22100_(sourceAttribute.m_22115_());
            for (AttributeModifier modifier : targetAttribute.m_22122_()) {
                targetAttribute.m_22130_(modifier);
            }
            for (AttributeModifier modifier : sourceAttribute.m_22122_()) {
                targetAttribute.m_22125_(modifier);
            }
        }
    }

    private void adjustAttributesFromConfig() {
        if (Config.DOPPELGANGER_HEALTH != null) {
            this.m_21051_(Attributes.f_22276_).m_22100_(((Double)Config.DOPPELGANGER_HEALTH.get()).doubleValue());
        }
        if (Config.DOPPELGANGER_ATTACK_DAMAGE != null) {
            this.m_21051_(Attributes.f_22281_).m_22100_(((Double)Config.DOPPELGANGER_ATTACK_DAMAGE.get()).doubleValue());
        }
        if (Config.DOPPELGANGER_MOVEMENT_SPEED != null) {
            this.m_21051_(Attributes.f_22279_).m_22100_(((Double)Config.DOPPELGANGER_MOVEMENT_SPEED.get()).doubleValue());
        }
        if (Config.DOPPELGANGER_KNOCKBACK_RESISTANCE != null) {
            this.m_21051_(Attributes.f_22278_).m_22100_(((Double)Config.DOPPELGANGER_KNOCKBACK_RESISTANCE.get()).doubleValue());
        }
        if (Config.DOPPELGANGER_ARMOR != null) {
            this.m_21051_(Attributes.f_22284_).m_22100_(((Double)Config.DOPPELGANGER_ARMOR.get()).doubleValue());
        }
        if (Config.DOPPELGANGER_FOLLOW_RANGE != null) {
            this.m_21051_(Attributes.f_22277_).m_22100_(((Double)Config.DOPPELGANGER_FOLLOW_RANGE.get()).doubleValue());
        }
        this.m_21153_(this.m_21233_());
    }

    private void applyAttributesFromConfig() {
        if (Config.DOPPELGANGER_HEALTH != null) {
            this.m_21051_(Attributes.f_22276_).m_22100_(((Double)Config.DOPPELGANGER_HEALTH.get()).doubleValue());
        }
        if (Config.DOPPELGANGER_ATTACK_DAMAGE != null) {
            this.m_21051_(Attributes.f_22281_).m_22100_(((Double)Config.DOPPELGANGER_ATTACK_DAMAGE.get()).doubleValue());
        }
        if (Config.DOPPELGANGER_MOVEMENT_SPEED != null) {
            this.m_21051_(Attributes.f_22279_).m_22100_(((Double)Config.DOPPELGANGER_MOVEMENT_SPEED.get()).doubleValue());
        }
        if (Config.DOPPELGANGER_KNOCKBACK_RESISTANCE != null) {
            this.m_21051_(Attributes.f_22278_).m_22100_(((Double)Config.DOPPELGANGER_KNOCKBACK_RESISTANCE.get()).doubleValue());
        }
        if (Config.DOPPELGANGER_ARMOR != null) {
            this.m_21051_(Attributes.f_22284_).m_22100_(((Double)Config.DOPPELGANGER_ARMOR.get()).doubleValue());
        }
        if (Config.DOPPELGANGER_FOLLOW_RANGE != null) {
            this.m_21051_(Attributes.f_22277_).m_22100_(((Double)Config.DOPPELGANGER_FOLLOW_RANGE.get()).doubleValue());
        }
        this.m_21153_(this.m_21233_());
    }

    private void spawnSummoningParticles() {
        for (int i = 0; i < 20; ++i) {
            double xOffset = (this.f_19796_.m_188500_() - 0.5) * 2.0;
            double yOffset = this.f_19796_.m_188500_();
            double zOffset = (this.f_19796_.m_188500_() - 0.5) * 2.0;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123744_, this.m_20185_() + xOffset, this.m_20186_() + yOffset, this.m_20189_() + zOffset, 0.0, 0.0, 0.0);
        }
    }

    private void stopAllMusic() {
        if (!this.m_9236_().f_46443_ && this.m_9236_().m_7654_() != null) {
            Objects.requireNonNull(this.m_9236_().m_7654_()).m_6846_().m_11314_().forEach(player -> player.f_8906_.m_9829_((Packet)new ClientboundStopSoundPacket(null, SoundSource.MUSIC)));
        }
    }

    private void stopMinecraftAmbientMusic() {
        if (!this.m_9236_().f_46443_ && this.m_9236_().m_7654_() != null) {
            for (ServerPlayer player : Objects.requireNonNull(this.m_9236_().m_7654_()).m_6846_().m_11314_()) {
                player.f_8906_.m_9829_((Packet)new ClientboundStopSoundPacket(new ResourceLocation("minecraft:music.game"), SoundSource.MUSIC));
                player.f_8906_.m_9829_((Packet)new ClientboundStopSoundPacket(new ResourceLocation("minecraft:music.creative"), SoundSource.MUSIC));
                player.f_8906_.m_9829_((Packet)new ClientboundStopSoundPacket(new ResourceLocation("minecraft:music.menu"), SoundSource.MUSIC));
                player.f_8906_.m_9829_((Packet)new ClientboundStopSoundPacket(new ResourceLocation("minecraft:music.overworld.day"), SoundSource.MUSIC));
                player.f_8906_.m_9829_((Packet)new ClientboundStopSoundPacket(new ResourceLocation("minecraft:music.overworld.night"), SoundSource.MUSIC));
                player.f_8906_.m_9829_((Packet)new ClientboundStopSoundPacket(new ResourceLocation("minecraft:music.overworld.hills"), SoundSource.MUSIC));
                player.f_8906_.m_9829_((Packet)new ClientboundStopSoundPacket(new ResourceLocation("minecraft:music.overworld.water"), SoundSource.MUSIC));
            }
        }
    }

    public void m_6457_(@NotNull ServerPlayer player) {
        super.m_6457_(player);
        if (!this.isClone) {
            this.bossEvent.m_6543_(player);
        }
    }

    public void m_6452_(@NotNull ServerPlayer player) {
        super.m_6452_(player);
        if (!this.isClone) {
            this.bossEvent.m_6539_(player);
        }
    }

    public void m_8119_() {
        Player summoner;
        super.m_8119_();
        this.createOrJoinDoppelTeam();
        if (!this.m_9236_().f_46443_ && this.isClone && !this.hasFallenIntoVoid && this.m_9236_().m_46472_() == Level.f_46430_ && this.m_20186_() < -100.0) {
            Player target2 = null;
            if (this.m_19880_().contains("dark_doppelganger_clone")) {
                target2 = this.getSummonerPlayer();
            }
            if (target2 == null) {
                target2 = this.m_9236_().m_45930_((Entity)this, 64.0);
            }
            if (target2 != null && !target2.m_21224_()) {
                this.m_6021_(target2.m_20185_(), target2.m_20186_() + 1.5, target2.m_20189_());
                this.m_146922_(target2.m_146908_());
                this.hasFallenIntoVoid = true;
                this.teleportCooldown = 100;
            }
        }
        if (this.teleportCooldown > 0) {
            --this.teleportCooldown;
            if (this.teleportCooldown == 0) {
                this.hasFallenIntoVoid = false;
            }
        }
        if (this.isClone || this.m_21224_()) {
            return;
        }
        this.bossEvent.m_142711_(this.m_21223_() / this.m_21233_());
        if (this.musicPlaying) {
            this.stopMinecraftAmbientMusic();
            if (this.musicTimer > 0) {
                --this.musicTimer;
            } else {
                this.playBossMusic();
            }
        }
        if (!this.musicPlaying) {
            this.stopMinecraftAmbientMusic();
            this.playBossMusic();
        }
        if (!this.isClone && this.laughCooldown > 0) {
            --this.laughCooldown;
        }
        if ((double)this.m_21223_() < (double)this.m_21233_() * 0.4 && this.minionSummonCooldown <= 0) {
            this.summonMinions();
            this.minionSummonCooldown = 1000;
        }
        if (!(this.m_9236_().f_46443_ || this.isClone || this.hasFallenIntoVoid || this.m_9236_().m_46472_() != Level.f_46430_ || !(this.m_20186_() < -100.0) || (summoner = this.getSummonerPlayer()) == null || summoner.m_21224_())) {
            double targetX = summoner.m_20185_();
            double targetY = summoner.m_20186_() + 1.5;
            double targetZ = summoner.m_20189_();
            PortalJoinEntity exitPortal = new PortalJoinEntity((EntityType)EntityRegistry.PORTAL_JOIN_ENTITY.get(), this.m_9236_());
            exitPortal.m_146884_(this.m_20182_());
            this.m_9236_().m_7967_((Entity)exitPortal);
            this.m_6021_(targetX, targetY, targetZ);
            this.m_146922_(summoner.m_146908_());
            this.m_9236_().m_5594_(null, summoner.m_20183_(), SoundEvents.f_12287_, SoundSource.HOSTILE, 1.0f, 1.0f);
            PortalJoinEntity entrancePortal = new PortalJoinEntity((EntityType)EntityRegistry.PORTAL_JOIN_ENTITY.get(), this.m_9236_());
            entrancePortal.m_6034_(targetX, targetY - 1.5, targetZ);
            this.m_9236_().m_7967_((Entity)entrancePortal);
            summoner.m_213846_((Component)Component.m_237113_((String)"The Dark Doppelganger has returned from the void...").m_130940_(ChatFormatting.DARK_PURPLE));
            this.hasFallenIntoVoid = true;
            this.teleportCooldown = 100;
        }
        if (((Boolean)Config.DOPPLEGANGER_HARD_MODE.get()).booleanValue()) {
            this.m_7292_(new MobEffectInstance((MobEffect)MobEffectRegistry.OAKSKIN.get(), 10, 8, false, false, true));
            this.m_7292_(new MobEffectInstance((MobEffect)MobEffectRegistry.CHARGED.get(), 10, 2, false, false, true));
            this.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 10, 0, false, false));
        }
        if (((Boolean)Config.DOPPLEGANGER_HARD_MODE.get()).booleanValue() && this.f_19797_ % 10 == 0) {
            this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82377_(20.0, 10.0, 20.0)).forEach(target -> {
                if (target != this) {
                    if (target.m_21023_(MobEffects.f_19598_)) {
                        target.m_21195_(MobEffects.f_19598_);
                    }
                    if (target.m_21023_((MobEffect)MobEffectRegistry.ABYSSAL_SHROUD.get())) {
                        target.m_21195_((MobEffect)MobEffectRegistry.ABYSSAL_SHROUD.get());
                    }
                    if (target.m_21023_((MobEffect)MobEffectRegistry.EVASION.get())) {
                        target.m_21195_((MobEffect)MobEffectRegistry.EVASION.get());
                    }
                    if (target.m_21023_((MobEffect)MobEffectRegistry.HASTENED.get())) {
                        target.m_21195_((MobEffect)MobEffectRegistry.HASTENED.get());
                    }
                    if (target.m_21023_((MobEffect)MobEffectRegistry.ECHOING_STRIKES.get())) {
                        target.m_21195_((MobEffect)MobEffectRegistry.ECHOING_STRIKES.get());
                    }
                }
            });
        }
        if (this.thirdPhaseTriggered) {
            if (this.minionSummonCooldown-- <= 0) {
                this.summonMinions();
                this.minionSummonCooldown = 500;
            }
            if (this.lifeDrainCooldown-- <= 0) {
                this.lifeDrainAttack();
                this.lifeDrainCooldown = 150;
            }
        }
        if (this.roarSoundCooldown > 0) {
            --this.roarSoundCooldown;
        }
        if (this.laughSoundCooldown > 0) {
            --this.laughSoundCooldown;
        }
        ++this.age;
    }

    private void playBossMusic() {
        if (!(this.m_9236_().f_46443_ || this.musicPlaying || this.m_21224_())) {
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)ModSounds.BOSS_FIGHT_MUSIC.get(), SoundSource.MUSIC, 1.0f, 1.0f);
            this.musicPlaying = true;
            this.musicTimer = 6160;
        }
    }

    private void stopBossMusic() {
        if (!this.m_9236_().f_46443_ && this.m_9236_().m_7654_() != null) {
            Objects.requireNonNull(this.m_9236_().m_7654_()).m_6846_().m_11314_().forEach(player -> player.f_8906_.m_9829_((Packet)new ClientboundStopSoundPacket(((SoundEvent)ModSounds.BOSS_FIGHT_MUSIC.get()).m_11660_(), SoundSource.MUSIC)));
        }
    }

    @Nullable
    public Player getSummonerPlayer() {
        return this.summonerPlayer;
    }

    public boolean m_147207_(MobEffectInstance p_147208_, @Nullable Entity p_147209_) {
        if (!p_147208_.m_19544_().m_19486_()) {
            return false;
        }
        return super.m_147207_(p_147208_, p_147209_);
    }

    private void triggerSecondPhase() {
        this.secondPhaseTriggered = true;
        this.m_21153_(this.m_21233_());
        for (ServerPlayer player : this.m_9236_().m_45976_(ServerPlayer.class, this.m_20191_().m_82400_(50.0))) {
            player.m_213846_((Component)Component.m_237113_((String)"The Dark Doppelganger has entered its Second Phase!").m_130940_(ChatFormatting.DARK_PURPLE));
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)ModSounds.BOSS_ROAR.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
            player.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 60, 0));
        }
        this.m_9236_().m_254849_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0f, Level.ExplosionInteraction.NONE);
        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123812_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
        for (int i = 0; i < 10; ++i) {
            double angle = Math.toRadians(i * 36);
            double x = this.m_20185_() + Math.cos(angle) * 10.0;
            double z = this.m_20189_() + Math.sin(angle) * 10.0;
            LightningBolt lightning = (LightningBolt)EntityType.f_20465_.m_20615_(this.m_9236_());
            if (lightning == null) continue;
            lightning.m_6027_(x, this.m_20186_(), z);
            this.m_9236_().m_7967_((Entity)lightning);
        }
    }

    private void triggerThirdPhase() {
        this.thirdPhaseTriggered = true;
        this.m_21153_(this.m_21233_());
        this.bossEvent.m_6456_((Component)Component.m_237113_((String)"Dark Doppelganger - Final Phase"));
        for (ServerPlayer player : this.m_9236_().m_45976_(ServerPlayer.class, this.m_20191_().m_82400_(50.0))) {
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)ModSounds.BOSS_ROAR.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
            player.m_5661_((Component)Component.m_237113_((String)"Final Form! Prepare yourself!").m_130940_(ChatFormatting.RED), true);
        }
        for (ServerPlayer player : this.m_9236_().m_6907_()) {
            player.m_36335_().m_41524_(Items.f_42747_, 60);
        }
        this.m_9236_().m_254849_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0f, Level.ExplosionInteraction.TNT);
        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123812_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
        for (int i = 0; i < 10; ++i) {
            double angle = Math.toRadians(i * 36);
            double x = this.m_20185_() + Math.cos(angle) * 10.0;
            double z = this.m_20189_() + Math.sin(angle) * 10.0;
            LightningBolt lightning = (LightningBolt)EntityType.f_20465_.m_20615_(this.m_9236_());
            if (lightning == null) continue;
            lightning.m_6027_(x, this.m_20186_(), z);
            this.m_9236_().m_7967_((Entity)lightning);
        }
        this.minionSummonCooldown = 1050;
        this.lifeDrainCooldown = 200;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source == this.m_9236_().m_269111_().m_269341_()) {
            return false;
        }
        if (this.m_21224_()) {
            return false;
        }
        if (this.isClone || this.m_19880_().contains("dark_doppelganger_clone")) {
            return super.m_6469_(source, amount);
        }
        float newHealth = this.m_21223_() - amount;
        if (!this.secondPhaseTriggered && newHealth <= this.m_21233_() * 0.1f) {
            this.triggerSecondPhase();
            if (((Boolean)Config.DOPPLEGANGER_HARD_MODE.get()).booleanValue()) {
                this.setThirdPhaseGoals();
            } else {
                this.setSecondPhaseGoals();
            }
            return false;
        }
        if (!this.thirdPhaseTriggered && newHealth <= this.m_21233_() * 0.1f) {
            this.triggerThirdPhase();
            if (((Boolean)Config.DOPPLEGANGER_HARD_MODE.get()).booleanValue()) {
                this.setFinalPhaseGoals();
            } else {
                this.setThirdPhaseGoals();
            }
            return false;
        }
        Entity attacker = source.m_7639_();
        if (attacker instanceof LivingEntity && attacker != this) {
            this.m_6710_((LivingEntity)attacker);
        }
        return super.m_6469_(source, amount);
    }

    private void summonMinions() {
        if (this.isClone || this.minionSummonCooldown > 0 || this.activeMinionUUIDs.size() >= 3) {
            return;
        }
        for (int i = 0; i < 2 && this.activeMinionUUIDs.size() < 3; ++i) {
            DarkDoppelgangerMinionEntity minion = (DarkDoppelgangerMinionEntity)((EntityType)EntityRegistry.DARK_DOPPELGANGER_MINION.get()).m_20615_(this.m_9236_());
            if (minion == null) continue;
            minion.m_6034_(this.m_20185_() + (double)this.f_19796_.m_188503_(5) - 2.0, this.m_20186_(), this.m_20189_() + (double)this.f_19796_.m_188503_(5) - 2.0);
            minion.m_21153_(minion.m_21233_() * 0.3f);
            minion.setSummonerUUID(this.m_20148_());
            minion.m_20049_("dark_doppelganger_clone");
            Team team = this.m_5647_();
            if (team instanceof PlayerTeam) {
                PlayerTeam playerTeam = (PlayerTeam)team;
                this.m_9236_().m_6188_().m_6546_(minion.m_6302_(), playerTeam);
            }
            minion.m_6593_((Component)Component.m_237113_((String)"Doppelganger Minion").m_130940_(ChatFormatting.DARK_GRAY));
            this.m_9236_().m_7967_((Entity)minion);
            this.activeMinionUUIDs.add(minion.m_20148_());
        }
        this.minionSummonCooldown = 500;
    }

    protected void m_7840_(double y, boolean onGround, BlockState state, BlockPos pos) {
    }

    public void removeMinion(UUID uuid) {
        this.activeMinionUUIDs.remove(uuid);
    }

    private void lifeDrainAttack() {
        this.m_9236_().m_45976_(Player.class, this.m_20191_().m_82400_(8.0)).forEach(player -> {
            player.m_6469_(this.m_9236_().m_269111_().m_269425_(), 4.0f);
            this.m_5634_(4.0f);
        });
        if (this.laughCooldown <= 0) {
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)ModSounds.BOSS_LAUGH.get(), SoundSource.HOSTILE, 0.0f, 1.0f);
            this.laughCooldown = 400;
        }
    }

    public void m_6667_(@NotNull DamageSource cause) {
        if (this.isClone) {
            for (Mob mob : this.m_9236_().m_45976_(Mob.class, this.m_20191_().m_82400_(64.0))) {
                if (!(mob instanceof DarkDoppelgangerEntity)) continue;
                DarkDoppelgangerEntity doppel = (DarkDoppelgangerEntity)mob;
                if (doppel.isClone) continue;
                doppel.removeMinion(this.m_20148_());
                break;
            }
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123759_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
            super.m_6667_(cause);
            return;
        }
        if (!this.thirdPhaseTriggered) {
            this.m_21153_(1.0f);
            return;
        }
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            this.m_8061_(slot, ItemStack.f_41583_);
        }
        if (this.musicPlaying) {
            this.stopBossMusic();
            this.musicPlaying = false;
            this.musicTimer = 0;
        }
        if (!this.m_9236_().f_46443_) {
            ServerPlayer serverPlayer;
            Advancement advancement;
            Entity mob = cause.m_7639_();
            if (mob instanceof ServerPlayer && (advancement = Objects.requireNonNull((serverPlayer = (ServerPlayer)mob).m_20194_()).m_129889_().m_136041_(new ResourceLocation("darkdoppelganger", "kill_dark_doppelganger"))) != null) {
                serverPlayer.m_8960_().m_135988_(advancement, "kill");
                serverPlayer.m_213846_((Component)Component.m_237113_((String)"You have slain the Dark Doppelganger!"));
            }
            List<Item> lootPool = List.of((Item)ItemRegistry.DOPPELGANGER_RING.get(), (Item)ItemRegistry.ELDER_NECKLACE.get(), (Item)ItemRegistry.SUMMONS_NECKLACE.get());
            Item selectedDrop = (Item)Util.m_214621_(lootPool, (RandomSource)this.m_217043_());
            this.m_19998_((ItemLike)selectedDrop);
            this.m_19998_((ItemLike)Items.f_42686_);
            this.m_20000_((ItemLike)Items.f_220224_, 3);
            this.m_20000_((ItemLike)Items.f_41959_, 3);
            this.m_9236_().m_7967_((Entity)new ExperienceOrb(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), 2500));
        }
        this.bossEvent.m_7706_();
        super.m_6667_(cause);
    }

    protected void m_6668_(DamageSource source) {
    }

    protected void m_7472_(DamageSource source, int looting, boolean recentlyHit) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 6000.0).m_22268_(Attributes.f_22281_, 20.0).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22278_, 0.6).m_22268_(Attributes.f_22284_, 20.0).m_22268_(Attributes.f_22277_, 64.0);
    }

    public void playAnimation(String animationId) {
        try {
            this.animationToPlay = RawAnimation.begin().thenPlay(animationId);
        }
        catch (Exception ignored) {
            DarkDoppelgangerMod.LOGGER.error("Entity {} Failed to play animation: {}", (Object)this, (Object)animationId);
        }
    }

    private PlayState predicate(AnimationState<DarkDoppelgangerEntity> animationEvent) {
        AnimationController controller = animationEvent.getController();
        if (this.age > 45 && this.animationToPlay != null) {
            controller.forceAnimationReset();
            controller.setAnimation(this.animationToPlay);
            this.animationToPlay = null;
        }
        return this.spawnController.getAnimationState() == AnimationController.State.STOPPED ? PlayState.CONTINUE : PlayState.STOP;
    }

    private PlayState spawnPredicate(AnimationState<DarkDoppelgangerEntity> animationEvent) {
        AnimationController controller = animationEvent.getController();
        if (this.age < 45) {
            controller.setAnimation(this.ANIMATION_SPAWN);
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    private void createOrJoinDoppelTeam() {
        String teamName;
        if (this.m_9236_().f_46443_ || this.m_5647_() != null) {
            return;
        }
        Scoreboard scoreboard = this.m_9236_().m_6188_();
        PlayerTeam team = scoreboard.m_83489_(teamName = "dark_doppelganger_team");
        if (team == null) {
            team = scoreboard.m_83492_(teamName);
            team.m_83355_(false);
            team.m_83362_(true);
        }
        scoreboard.m_6546_(this.m_6302_(), team);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{this.meleeController});
        controllerRegistrar.add(new AnimationController[]{this.spawnController});
        super.registerControllers(controllerRegistrar);
    }

    public boolean isAnimating() {
        return this.meleeController.getAnimationState() != AnimationController.State.STOPPED || this.spawnController.getAnimationState() != AnimationController.State.STOPPED || super.isAnimating();
    }

    private List<AbstractSpell> getConfiguredSpells(List<? extends String> ids) {
        return ids.stream().map(ResourceLocation::new).map(SpellRegistry::getSpell).filter(spell -> !(spell instanceof NoneSpell)).toList();
    }
}

