/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.darkdoppelganger.item;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import io.redspace.ironsspellbooks.api.registry.AttributeRegistry;
import java.util.UUID;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class DoppelgangerRingItem
extends Item
implements ICurioItem {
    private static final UUID HEALTH_BOOST_UUID = UUID.fromString("1d1a82d8-c9d2-11ed-afa1-0242ac120002");
    private static final UUID MAX_MANA_UUID = UUID.fromString("2d2a92d8-c9d2-11ed-afa1-0242ac120003");

    public DoppelgangerRingItem(Item.Properties properties) {
        super(properties);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid, ItemStack stack) {
        HashMultimap modifiers = HashMultimap.create();
        modifiers.put((Object)Attributes.f_22276_, (Object)new AttributeModifier(HEALTH_BOOST_UUID, "Ring health boost", 30.0, AttributeModifier.Operation.ADDITION));
        modifiers.put((Object)((Attribute)AttributeRegistry.MAX_MANA.get()), (Object)new AttributeModifier(MAX_MANA_UUID, "Ring mana boost", 150.0, AttributeModifier.Operation.ADDITION));
        return modifiers;
    }

    public boolean canEquip(SlotContext slotContext, ItemStack stack) {
        return "ring".equals(slotContext.identifier());
    }

    public boolean canUnequip(SlotContext slotContext, ItemStack stack) {
        return true;
    }

    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        Level level = slotContext.entity().m_9236_();
        if (!level.f_46443_) {
            // empty if block
        }
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        Level level = slotContext.entity().m_9236_();
        if (!level.f_46443_) {
            // empty if block
        }
    }

    @NotNull
    public // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull @NotNull ICurio.SoundInfo getEquipSound(SlotContext slotContext, ItemStack stack) {
        return new ICurio.SoundInfo(SoundEvents.f_11672_, 1.0f, 1.0f);
    }
}

