/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.darkdoppelganger.spells;

import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.AnimationHolder;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.network.spell.ClientboundTeleportParticles;
import io.redspace.ironsspellbooks.setup.Messages;
import io.redspace.ironsspellbooks.spells.ender.TeleportSpell;
import java.util.List;
import java.util.Optional;
import net.bandit.darkdoppelganger.entity.EntityRegistry;
import net.bandit.darkdoppelganger.entity.PortalJoinEntity;
import net.bandit.darkdoppelganger.entity.PortalLeaveEntity;
import net.bandit.darkdoppelganger.registry.ModAnimations;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

@AutoSpellConfig
public class DoppelPortalSpell
extends AbstractSpell {
    private boolean portalSpawned = false;
    private final ResourceLocation spellId = new ResourceLocation("darkdoppelganger", "doppel_portal");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.LEGENDARY).setSchoolResource(SchoolRegistry.ENDER_RESOURCE).setMaxLevel(1).setCooldownSeconds(5.0).build();

    public DoppelPortalSpell() {
        this.manaCostPerLevel = 1;
        this.baseSpellPower = 5;
        this.spellPowerPerLevel = 1;
        this.castTime = 30;
        this.baseManaCost = 3;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public int getCastTime(int spellLevel) {
        return this.castTime + 5 * spellLevel;
    }

    public CastType getCastType() {
        return CastType.CONTINUOUS;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public Optional<SoundEvent> getCastStartSound() {
        return Optional.empty();
    }

    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.of(SoundEvents.f_11852_);
    }

    public AnimationHolder getCastFinishAnimation() {
        return ModAnimations.PLAYER_JOIN;
    }

    public AnimationHolder getCastStartAnimation() {
        return ModAnimations.PLAYER_LEAVE;
    }

    public boolean allowCrafting() {
        return false;
    }

    public boolean allowLooting() {
        return false;
    }

    public void onCast(Level level, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        if (!this.portalSpawned) {
            PortalLeaveEntity portal = new PortalLeaveEntity((EntityType)EntityRegistry.PORTAL_LEAVE_ENTITY.get(), level);
            this.portalSpawned = true;
            portal.m_146922_(entity.m_146908_());
            portal.f_19859_ = entity.m_146908_();
            portal.m_146884_(entity.m_20182_());
            level.m_7967_((Entity)portal);
        }
        super.onCast(level, spellLevel, entity, castSource, playerMagicData);
    }

    public void onServerCastComplete(Level level, int spellLevel, LivingEntity entity, MagicData playerMagicData, boolean cancelled) {
        if (playerMagicData != null) {
            Vec3 potentialTarget;
            TeleportSpell.TeleportData teleportData = (TeleportSpell.TeleportData)playerMagicData.getAdditionalCastData();
            Vec3 dest = null;
            if (teleportData != null && (potentialTarget = teleportData.getTeleportTargetPosition()) != null) {
                dest = potentialTarget;
            }
            if (dest == null) {
                dest = DoppelPortalSpell.findTeleportLocation(level, entity, this.getDistance(spellLevel, entity));
            }
            Messages.sendToPlayersTrackingEntity((Object)new ClientboundTeleportParticles(entity.m_20182_(), dest), (Entity)entity, (boolean)true);
            if (entity.m_20159_()) {
                entity.m_8127_();
            }
            entity.m_6021_(dest.f_82479_, dest.f_82480_, dest.f_82481_);
            entity.m_183634_();
            playerMagicData.resetAdditionalCastData();
            entity.m_5496_(this.getCastFinishSound().get(), 2.0f, 1.0f);
            PortalJoinEntity portal = new PortalJoinEntity((EntityType)EntityRegistry.PORTAL_JOIN_ENTITY.get(), level);
            portal.m_146922_(entity.m_146908_());
            portal.f_19859_ = entity.m_146908_();
            portal.m_146884_(dest);
            level.m_7967_((Entity)portal);
        }
        this.portalSpawned = false;
        super.onServerCastComplete(level, spellLevel, entity, playerMagicData, cancelled);
    }

    public static Vec3 findTeleportLocation(Level level, LivingEntity entity, float maxDistance) {
        boolean los;
        BlockHitResult blockHitResult = Utils.getTargetBlock((Level)level, (LivingEntity)entity, (ClipContext.Fluid)ClipContext.Fluid.NONE, (double)maxDistance);
        BlockPos pos = blockHitResult.m_82425_();
        Vec3 bbOffset = entity.m_20156_().m_82541_().m_82542_((double)(entity.m_20205_() / 3.0f), 0.0, (double)(entity.m_20206_() / 3.0f));
        Vec3 bbImpact = blockHitResult.m_82450_().m_82546_(bbOffset);
        int ledgeY = (int)level.m_45547_((ClipContext)new ClipContext((Vec3)Vec3.m_82539_((Vec3i)pos).m_82520_((double)0.0, (double)3.0, (double)0.0), (Vec3)Vec3.m_82539_((Vec3i)pos), (ClipContext.Block)ClipContext.Block.COLLIDER, (ClipContext.Fluid)ClipContext.Fluid.NONE, null)).m_82450_().f_82480_;
        boolean isAir = level.m_8055_(new BlockPos(new Vec3i(pos.m_123341_(), ledgeY, pos.m_123343_()))).m_60795_();
        boolean bl = los = level.m_45547_(new ClipContext(bbImpact, bbImpact.m_82520_(0.0, (double)(ledgeY - pos.m_123342_()), 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)entity)).m_6662_() == HitResult.Type.MISS;
        if (isAir && los && Math.abs(ledgeY - pos.m_123342_()) <= 3) {
            Vec3 correctedPos = new Vec3((double)pos.m_123341_(), (double)ledgeY, (double)pos.m_123343_());
            return correctedPos.m_82520_(0.5, 0.076, 0.5);
        }
        return level.m_45547_(new ClipContext(bbImpact, bbImpact.m_82520_(0.0, (double)(-entity.m_20206_()), 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)entity)).m_82450_().m_82520_(0.0, 0.076, 0.0);
    }

    private float getDistance(int spellLevel, LivingEntity sourceEntity) {
        return (float)(Utils.softCapFormula((double)this.getEntityPowerMultiplier(sourceEntity)) * (double)this.getSpellPower(spellLevel + 8, null));
    }

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.m_237110_((String)"ui.irons_spellbooks.distance", (Object[])new Object[]{Utils.stringTruncation((double)this.getDistance(spellLevel, caster), (int)1)}));
    }
}

