/*
 * Decompiled with CFR 0.152.
 */
package com.jkvin114.displaydelight.block;

import com.jkvin114.displaydelight.DisplayDelight;
import com.jkvin114.displaydelight.block.AbstractStackablePlatedFoodBlock;
import com.jkvin114.displaydelight.block.SmallPlatedFoodBlock;
import com.jkvin114.displaydelight.init.BlockAssociations;
import com.jkvin114.displaydelight.init.DisplayConfig;
import com.jkvin114.displaydelight.init.DisplayItems;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SupportType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.HitResult;
import org.antlr.v4.runtime.misc.NotNull;

public abstract class AbstractItemBlock
extends HorizontalDirectionalBlock {
    public AbstractItemBlock(BlockBehaviour.Properties props) {
        super(props);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH));
    }

    @NotNull
    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder params) {
        List droppedStacks = super.m_49635_(state, params);
        boolean silktouch = false;
        if (((Boolean)DisplayConfig.SILKTOUCH_DROPS_FOOD_BLOCK_ITEM.get()).booleanValue()) {
            try {
                ItemStack tool = (ItemStack)params.m_287261_(LootContextParams.f_81463_);
                if (tool.getEnchantmentLevel(Enchantments.f_44985_) > 0) {
                    silktouch = true;
                }
            }
            catch (Exception e) {
                DisplayDelight.LOGGER.error(e.toString());
            }
        }
        Block block = state.m_60734_();
        Item foodItem = this.getStackFor().m_41720_();
        boolean fallBack = false;
        if (block instanceof AbstractStackablePlatedFoodBlock) {
            AbstractStackablePlatedFoodBlock platedFoodBlock = (AbstractStackablePlatedFoodBlock)block;
            if (foodItem.equals(Items.f_41852_) || silktouch && platedFoodBlock.getStacks(state) >= platedFoodBlock.getMaxStackable()) {
                foodItem = this.m_5456_();
                fallBack = true;
            }
            droppedStacks.add(new ItemStack((ItemLike)foodItem, !fallBack ? platedFoodBlock.getStacks(state) : 1));
            if (!fallBack) {
                droppedStacks.add(new ItemStack((ItemLike)DisplayItems.PLATE.get()));
            }
        } else if (block instanceof SmallPlatedFoodBlock) {
            if (foodItem.equals(Items.f_41852_) || silktouch) {
                foodItem = this.m_5456_();
                fallBack = true;
            }
            droppedStacks.add(new ItemStack((ItemLike)foodItem));
            if (!fallBack) {
                droppedStacks.add(new ItemStack((ItemLike)DisplayItems.SMALL_PLATE.get()));
            }
        } else {
            if (foodItem.equals(Items.f_41852_) || silktouch) {
                foodItem = this.m_5456_();
            }
            droppedStacks.add(new ItemStack((ItemLike)foodItem));
        }
        return droppedStacks;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        ItemStack stk = this.getStackFor();
        if (stk.m_41720_().equals(Items.f_41852_)) {
            stk = new ItemStack((ItemLike)state.m_60734_().m_5456_());
        }
        return stk;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)context.m_8125_().m_122424_());
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        return world.m_8055_(pos.m_7495_()).m_60659_((BlockGetter)world, pos.m_7495_(), Direction.UP, SupportType.CENTER);
    }

    public ItemStack getStackFor() {
        return new ItemStack((ItemLike)BlockAssociations.getItemFor((Block)this));
    }
}

