/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.dpr.skill;

import com.p1nero.dpr.gameassets.DPRDatakeys;
import com.p1nero.dpr.mixin.MobEffectInstanceAccessor;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundUpdateMobEffectPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillBuilder;
import yesman.epicfight.skill.SkillCategories;
import yesman.epicfight.skill.SkillCategory;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;

public abstract class RewardSkill
extends Skill {
    protected int duration;
    protected int amplifier;
    protected boolean ambient;
    protected boolean visible;
    protected boolean showIcon = true;
    @Nullable
    protected Supplier<MobEffect> mobEffectSupplier;
    protected int delay;
    @Nullable
    protected Consumer<PlayerPatch<?>> playerPatchConsumer;
    protected final UUID EVENT_UUID;
    protected final ResourceLocation sKillTexture;
    protected ResourceLocation effectTexture;

    public static Builder createParryRewardSkill() {
        return (Builder)new Builder().setCategory((SkillCategory)SkillCategories.PASSIVE).setResource(Skill.Resource.NONE);
    }

    public RewardSkill(Builder builder) {
        super((SkillBuilder)builder);
        this.duration = builder.effectDuration;
        this.amplifier = builder.effectAmplifier;
        this.mobEffectSupplier = builder.mobEffectSupplier;
        this.delay = builder.delay;
        this.playerPatchConsumer = builder.playerPatchConsumer;
        this.sKillTexture = builder.sKillTexture;
        this.EVENT_UUID = builder.uuid;
    }

    public void setParams(CompoundTag parameters) {
        super.setParams(parameters);
        if (parameters.m_128441_("duration")) {
            this.duration = parameters.m_128451_("duration");
        }
        if (parameters.m_128441_("amplifier")) {
            this.amplifier = parameters.m_128451_("amplifier");
        }
        if (parameters.m_128441_("ambient")) {
            this.ambient = parameters.m_128471_("ambient");
        }
        if (parameters.m_128441_("visible")) {
            this.visible = parameters.m_128471_("visible");
        }
        if (parameters.m_128441_("showIcon")) {
            this.showIcon = parameters.m_128471_("showIcon");
        }
    }

    public void updateContainer(SkillContainer container) {
        super.updateContainer(container);
        int delayTimer = (Integer)container.getDataManager().getDataValue((SkillDataKey)DPRDatakeys.DELAY_TIMER.get());
        if (delayTimer > 0) {
            if (!container.getExecutor().isLogicalClient()) {
                container.getDataManager().setDataSync((SkillDataKey)DPRDatakeys.DELAY_TIMER.get(), (Object)(delayTimer - 1));
            }
            if (delayTimer == 1 && this.playerPatchConsumer != null) {
                this.playerPatchConsumer.accept(container.getExecutor());
            }
        }
    }

    public void apply(SkillContainer container) {
        Player player = (Player)container.getExecutor().getOriginal();
        if (this.delay > 0) {
            if (player instanceof ServerPlayer) {
                container.getDataManager().setDataSync((SkillDataKey)DPRDatakeys.DELAY_TIMER.get(), (Object)this.delay);
            }
        } else if (this.playerPatchConsumer != null) {
            this.playerPatchConsumer.accept(container.getExecutor());
        }
        if (this.mobEffectSupplier != null && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            MobEffect mobEffect = this.mobEffectSupplier.get();
            MobEffectInstance instance = player.m_21124_(mobEffect);
            if (instance != null) {
                ((MobEffectInstanceAccessor)instance).setDuration(this.duration);
                serverPlayer.f_8906_.m_9829_((Packet)new ClientboundUpdateMobEffectPacket(serverPlayer.m_19879_(), instance));
            }
            player.m_7292_(new MobEffectInstance(mobEffect, this.duration, this.amplifier, this.ambient, this.visible, this.showIcon));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public ResourceLocation getSkillTexture() {
        if (this.mobEffectSupplier != null) {
            if (this.effectTexture != null) {
                return ResourceLocation.fromNamespaceAndPath((String)this.effectTexture.m_135827_(), (String)("textures/mob_effect/" + this.effectTexture.m_135815_() + ".png"));
            }
            MobEffect mobEffect = this.mobEffectSupplier.get();
            this.effectTexture = ForgeRegistries.MOB_EFFECTS.getKey((Object)mobEffect);
        }
        if (this.sKillTexture != null) {
            return this.sKillTexture;
        }
        return super.getSkillTexture();
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<Object> getTooltipArgsOfScreen(List<Object> list) {
        list.add(this.amplifier);
        if (this.mobEffectSupplier != null) {
            list.add(this.mobEffectSupplier.get().m_19482_().m_6881_().m_130948_(Style.f_131099_.m_178520_(this.mobEffectSupplier.get().m_19484_()).m_131136_(Boolean.valueOf(true))));
        }
        list.add(this.duration);
        return list;
    }

    public static class Builder
    extends SkillBuilder<RewardSkill> {
        private int effectDuration;
        protected int effectAmplifier;
        private Supplier<MobEffect> mobEffectSupplier;
        private int delay;
        private Consumer<PlayerPatch<?>> playerPatchConsumer;
        private UUID uuid = UUID.fromString("fdc09ee8-fcfc-19eb-9a03-0242ac114514");
        protected ResourceLocation sKillTexture;

        public Builder setEffectDuration(int effectDuration) {
            this.effectDuration = effectDuration;
            return this;
        }

        public Builder setEffectAmplifier(int effectAmplifier) {
            this.effectAmplifier = effectAmplifier;
            return this;
        }

        public Builder setsKillTexture(ResourceLocation sKillTexture) {
            this.sKillTexture = sKillTexture;
            return this;
        }

        public Builder setMobEffectSupplier(Supplier<MobEffect> mobEffectSupplier) {
            this.mobEffectSupplier = mobEffectSupplier;
            return this;
        }

        public Builder setWhenExecute(Consumer<PlayerPatch<?>> playerPatchConsumer) {
            this.playerPatchConsumer = playerPatchConsumer;
            return this;
        }

        public Builder setWhenExecute(Consumer<PlayerPatch<?>> playerPatchConsumer, int delay) {
            this.playerPatchConsumer = playerPatchConsumer;
            this.delay = delay;
            return this;
        }

        public Builder setUuid(UUID uuid) {
            this.uuid = uuid;
            return this;
        }
    }
}

