/*
 * Decompiled with CFR 0.152.
 */
package com.yukami.efiscompat.data;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import com.yukami.efiscompat.animation.Animation;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.types.StaticAnimation;

public class SpellAnimationLoader
extends SimpleJsonResourceReloadListener {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = new Gson();
    private static final Map<String, AnimationSet> SPELL_ANIMATIONS = new HashMap<String, AnimationSet>();

    public SpellAnimationLoader() {
        super(GSON, "spell_animations");
    }

    protected void apply(@NotNull Map<ResourceLocation, JsonElement> resourceList, @NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profiler) {
        SPELL_ANIMATIONS.clear();
        resourceList.forEach((location, json) -> {
            JsonObject root = json.getAsJsonObject();
            if (root.has("spells")) {
                JsonObject spells = root.getAsJsonObject("spells");
                spells.entrySet().forEach(entry -> {
                    String spellName = (String)entry.getKey();
                    JsonObject data = ((JsonElement)entry.getValue()).getAsJsonObject();
                    try {
                        AnimationSet animations = new AnimationSet(Animation.getAnimation(this.getStringOrNull(data, "chant_animation")), Animation.getAnimation(this.getStringOrNull(data, "cast_animation")), Animation.getAnimation(this.getStringOrNull(data, "continuous_animation")), Animation.getAnimation(this.getStringOrNull(data, "staff_chant_animation_r")), Animation.getAnimation(this.getStringOrNull(data, "staff_cast_animation_r")), Animation.getAnimation(this.getStringOrNull(data, "staff_chant_animation_l")), Animation.getAnimation(this.getStringOrNull(data, "staff_cast_animation_l")), Animation.getAnimation(this.getStringOrNull(data, "staff_continuous_animation_r")), Animation.getAnimation(this.getStringOrNull(data, "staff_continuous_animation_l")));
                        SPELL_ANIMATIONS.put(spellName, animations);
                    }
                    catch (Exception e) {
                        LOGGER.warn("Failed to load animations for spell '{}': {}", (Object)spellName, (Object)e.getMessage());
                    }
                });
            }
        });
    }

    public static AnimationSet getAnimations(String spellName) {
        AnimationSet animations = SPELL_ANIMATIONS.get(spellName);
        if (animations == null) {
            return SPELL_ANIMATIONS.get("default");
        }
        AnimationSet defaultAnimations = SPELL_ANIMATIONS.get("default");
        if (defaultAnimations != null && SpellAnimationLoader.hasNullFields(animations)) {
            return SpellAnimationLoader.createMergedAnimationSet(animations, defaultAnimations);
        }
        return animations;
    }

    private static boolean hasNullFields(AnimationSet animations) {
        return animations.chant() == null || animations.cast() == null || animations.continuous() == null || animations.staffChantRight() == null || animations.staffCastRight() == null || animations.staffChantLeft() == null || animations.staffCastLeft() == null || animations.staffContinuousRight() == null || animations.staffContinuousLeft() == null;
    }

    private static AnimationSet createMergedAnimationSet(AnimationSet spellAnimations, AnimationSet defaultAnimations) {
        return new AnimationSet(spellAnimations.chant() != null ? spellAnimations.chant() : defaultAnimations.chant(), spellAnimations.cast() != null ? spellAnimations.cast() : defaultAnimations.cast(), spellAnimations.continuous() != null ? spellAnimations.continuous() : defaultAnimations.continuous(), spellAnimations.staffChantRight() != null ? spellAnimations.staffChantRight() : defaultAnimations.staffChantRight(), spellAnimations.staffCastRight() != null ? spellAnimations.staffCastRight() : defaultAnimations.staffCastRight(), spellAnimations.staffChantLeft() != null ? spellAnimations.staffChantLeft() : defaultAnimations.staffChantLeft(), spellAnimations.staffCastLeft() != null ? spellAnimations.staffCastLeft() : defaultAnimations.staffCastLeft(), spellAnimations.staffContinuousRight() != null ? spellAnimations.staffContinuousRight() : defaultAnimations.staffContinuousRight(), spellAnimations.staffContinuousLeft() != null ? spellAnimations.staffContinuousLeft() : defaultAnimations.staffContinuousLeft());
    }

    private String getStringOrNull(JsonObject obj, String key) {
        if (!obj.has(key)) {
            return null;
        }
        String value = obj.get(key).getAsString();
        return value.isEmpty() ? null : value;
    }

    public record AnimationSet(AnimationManager.AnimationAccessor<StaticAnimation> chant, AnimationManager.AnimationAccessor<StaticAnimation> cast, AnimationManager.AnimationAccessor<StaticAnimation> continuous, AnimationManager.AnimationAccessor<StaticAnimation> staffChantRight, AnimationManager.AnimationAccessor<StaticAnimation> staffCastRight, AnimationManager.AnimationAccessor<StaticAnimation> staffChantLeft, AnimationManager.AnimationAccessor<StaticAnimation> staffCastLeft, AnimationManager.AnimationAccessor<StaticAnimation> staffContinuousRight, AnimationManager.AnimationAccessor<StaticAnimation> staffContinuousLeft) {
    }
}

