/*
 * Decompiled with CFR 0.152.
 */
package com.yukami.efiscompat.data;

import com.yukami.efiscompat.data.SpellAnimationLoader;
import com.yukami.efiscompat.utils.CompatUtils;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.types.StaticAnimation;

public class SpellAnimationProvider {
    public static AnimationManager.AnimationAccessor<StaticAnimation> getAnimation(String spellName, AnimationType animationType, Player player) {
        SpellAnimationLoader.AnimationSet animations = SpellAnimationLoader.getAnimations(spellName);
        if (animations == null) {
            return null;
        }
        return switch (animationType) {
            default -> throw new IncompatibleClassChangeError();
            case AnimationType.CHANT -> SpellAnimationProvider.getChantAnimation(animations, player);
            case AnimationType.CAST -> SpellAnimationProvider.getCastAnimation(animations, player);
            case AnimationType.CONTINUOUS -> SpellAnimationProvider.getContinuousAnimation(animations, player);
        };
    }

    private static AnimationManager.AnimationAccessor<StaticAnimation> getChantAnimation(SpellAnimationLoader.AnimationSet set, Player player) {
        if (CompatUtils.isHoldingStaffMainHand((LivingEntity)player)) {
            return set.staffChantRight();
        }
        if (CompatUtils.isHoldingStaffOffHand((LivingEntity)player)) {
            return set.staffChantLeft();
        }
        return set.chant();
    }

    private static AnimationManager.AnimationAccessor<StaticAnimation> getCastAnimation(SpellAnimationLoader.AnimationSet set, Player player) {
        if (CompatUtils.isHoldingStaffMainHand((LivingEntity)player)) {
            return set.staffCastRight();
        }
        if (CompatUtils.isHoldingStaffOffHand((LivingEntity)player)) {
            return set.staffCastLeft();
        }
        return set.cast();
    }

    private static AnimationManager.AnimationAccessor<StaticAnimation> getContinuousAnimation(SpellAnimationLoader.AnimationSet set, Player player) {
        if (CompatUtils.isHoldingStaffMainHand((LivingEntity)player)) {
            return set.staffContinuousRight();
        }
        if (CompatUtils.isHoldingStaffOffHand((LivingEntity)player)) {
            return set.staffContinuousLeft();
        }
        return set.continuous();
    }

    public static enum AnimationType {
        CHANT,
        CAST,
        CONTINUOUS;

    }
}

