/*
 * Decompiled with CFR 0.152.
 */
package com.yukami.efiscompat.effect;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public class ClientVisualEffectManager {
    private static final List<VisualEffect> activeEffects = new ArrayList<VisualEffect>();

    public static void createPlayerFollowingEffect(int playerId, Vec3 positionOffset, float maxScale, int durationTicks, float startScale, float endScale) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ != null) {
            activeEffects.removeIf(effect -> Objects.equals(effect.followingPlayerId, playerId));
            VisualEffect effect2 = new VisualEffect(null, maxScale, durationTicks, startScale, endScale, mc.f_91073_.m_46467_(), playerId, positionOffset);
            activeEffects.add(effect2);
        }
    }

    public static List<VisualEffect> getAllActiveEffects() {
        return new ArrayList<VisualEffect>(activeEffects);
    }

    public static void tick() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null) {
            activeEffects.clear();
            return;
        }
        long currentTime = mc.f_91073_.m_46467_();
        activeEffects.removeIf(effect -> effect.isExpired(currentTime) || effect.followingPlayerId != null && mc.f_91073_.m_6815_(effect.followingPlayerId.intValue()) == null);
    }

    public static void clearAllEffects() {
        activeEffects.clear();
    }

    public static void cancelEffect(int playerId) {
        activeEffects.removeIf(effect -> Objects.equals(effect.followingPlayerId, playerId));
    }

    public static class VisualEffect {
        public Vec3 position;
        public final float maxScale;
        public final int durationTicks;
        public final float startScale;
        public final float endScale;
        public final long startTime;
        public final Integer followingPlayerId;
        public final Vec3 positionOffset;

        public VisualEffect(Vec3 position, float maxScale, int durationTicks, float startScale, float endScale, long startTime, Integer followingPlayerId, Vec3 positionOffset) {
            this.position = position;
            this.maxScale = maxScale;
            this.durationTicks = durationTicks;
            this.startScale = startScale;
            this.endScale = endScale;
            this.startTime = startTime;
            this.followingPlayerId = followingPlayerId;
            this.positionOffset = positionOffset;
        }

        public float getAnimationProgress(float partialTicks) {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91073_ == null) {
                return 1.0f;
            }
            long currentTime = mc.f_91073_.m_46467_();
            return Math.min(((float)(currentTime - this.startTime) + partialTicks) / (float)this.durationTicks, 1.0f);
        }

        public float getCurrentScale(float partialTicks) {
            float progress = this.getAnimationProgress(partialTicks);
            float smoothProgress = 1.0f - (1.0f - progress) * (1.0f - progress);
            return this.startScale + (this.endScale - this.startScale) * smoothProgress;
        }

        public boolean isExpired(long currentTime) {
            return currentTime - this.startTime >= (long)this.durationTicks;
        }

        public Vec3 getPosition(float partialTicks) {
            if (this.followingPlayerId != null) {
                Entity player;
                Minecraft mc = Minecraft.m_91087_();
                if (mc.f_91073_ != null && (player = mc.f_91073_.m_6815_(this.followingPlayerId.intValue())) != null) {
                    return player.m_20299_(partialTicks).m_82549_(player.m_20154_().m_82490_(2.0));
                }
            }
            return this.position;
        }
    }
}

