/*
 * Decompiled with CFR 0.152.
 */
package com.yukami.efiscompat.effect;

import com.yukami.efiscompat.network.ClientboundCancelVisualEffectPacket;
import com.yukami.efiscompat.network.ClientboundVisualEffectPacket;
import com.yukami.efiscompat.network.Networking;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;

public class VisualEffectManager {
    public static final int DEFAULT_DURATION_TICKS = 100;
    public static final float DEFAULT_SCALE = 1.0f;

    public static void startBlackHoleEffect(Player player, Vec3 position, float scale, int durationTicks) {
        VisualEffectManager.startBlackHoleEffect(player, position, scale, durationTicks, 0.1f, scale);
    }

    public static void startBlackHoleEffect(Player player, Vec3 position, float maxScale, int durationTicks, float startScale, float endScale) {
        if (!player.m_9236_().m_5776_()) {
            Networking.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player), (Object)new ClientboundVisualEffectPacket(position, maxScale, durationTicks, startScale, endScale, player.m_19879_()));
        }
    }

    public static void startBlackHoleEffectAbovePlayer(Player player, float scale, int durationTicks) {
        VisualEffectManager.startBlackHoleEffectAbovePlayer(player, scale, durationTicks, 0.1f, scale);
    }

    public static void startBlackHoleEffectAbovePlayer(Player player, float maxScale, int durationTicks, float startScale, float endScale) {
        Vec3 effectPos = player.m_20182_().m_82520_(0.0, (double)player.m_20206_() + 1.5, 0.0);
        VisualEffectManager.startBlackHoleEffect(player, effectPos, maxScale, durationTicks, startScale, endScale);
    }

    public static void startRisingBlackHoleEffect(Player player, float maxScale, int durationTicks, float startScale, float endScale, float startHeight, float endHeight) {
        if (!player.m_9236_().m_5776_()) {
            Vec3 initialPos = player.m_20182_().m_82520_(0.0, (double)(player.m_20206_() + endHeight), 0.0);
            VisualEffectManager.startBlackHoleEffect(player, initialPos, maxScale, durationTicks, startScale, endScale);
        }
    }

    public static void startBlackHoleEffectInFrontOfPlayer(Player player, float scale, int durationTicks) {
        VisualEffectManager.startBlackHoleEffectInFrontOfPlayer(player, scale, durationTicks, 0.1f, scale);
    }

    public static void startBlackHoleEffectInFrontOfPlayer(Player player, float maxScale, int durationTicks, float startScale, float endScale) {
        Vec3 lookDirection = player.m_20154_();
        Vec3 effectPos = player.m_20182_().m_82549_(lookDirection.m_82490_(2.0)).m_82520_(0.0, (double)player.m_20206_() / 2.0, 0.0);
        VisualEffectManager.startBlackHoleEffect(player, effectPos, maxScale, durationTicks, startScale, endScale);
    }

    public static void startBlackHoleEffect(Player player) {
        VisualEffectManager.startBlackHoleEffectAbovePlayer(player, 1.0f, 100);
    }

    public static void cancelBlackHoleEffect(Player player) {
        if (!player.m_9236_().m_5776_()) {
            Networking.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player), (Object)new ClientboundCancelVisualEffectPacket(player.m_19879_()));
        }
    }
}

