/*
 * Decompiled with CFR 0.152.
 */
package com.yukami.efiscompat.effect;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.yukami.efiscompat.effect.ClientVisualEffectManager;
import io.redspace.ironsspellbooks.IronsSpellbooks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class VisualEffectRenderer {
    private static final ResourceLocation CENTER_TEXTURE = IronsSpellbooks.id((String)"textures/entity/black_hole/black_hole.png");
    private static final ResourceLocation BEAM_TEXTURE = IronsSpellbooks.id((String)"textures/entity/black_hole/beam.png");

    @SubscribeEvent
    public static void renderBlackHoles(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            return;
        }
        PoseStack poseStack = event.getPoseStack();
        MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
        float partialTicks = event.getPartialTick();
        Vec3 cameraPos = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        for (ClientVisualEffectManager.VisualEffect effect : ClientVisualEffectManager.getAllActiveEffects()) {
            poseStack.m_85836_();
            Vec3 effectPos = effect.getPosition(partialTicks);
            if (effectPos == null) {
                poseStack.m_85849_();
                continue;
            }
            poseStack.m_85837_(effectPos.f_82479_ - cameraPos.f_82479_, effectPos.f_82480_ - cameraPos.f_82480_, effectPos.f_82481_ - cameraPos.f_82481_);
            float scale = effect.getCurrentScale(partialTicks);
            float progress = effect.getAnimationProgress(partialTicks);
            VisualEffectRenderer.renderCenterTexture(poseStack, (MultiBufferSource)bufferSource, scale);
            VisualEffectRenderer.renderEnergySwirls(poseStack, (MultiBufferSource)bufferSource, progress, scale);
            poseStack.m_85849_();
        }
        bufferSource.m_109911_();
    }

    private static void renderCenterTexture(PoseStack poseStack, MultiBufferSource bufferSource, float scale) {
        poseStack.m_85836_();
        float entityScale = scale * 0.025f;
        poseStack.m_85841_(0.5f * entityScale, 0.5f * entityScale, 0.5f * entityScale);
        Minecraft mc = Minecraft.m_91087_();
        poseStack.m_252781_(mc.m_91290_().m_253208_());
        poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
        poseStack.m_252880_(5.0f, 0.0f, 0.0f);
        PoseStack.Pose pose = poseStack.m_85850_();
        Matrix4f poseMatrix = pose.m_252922_();
        Matrix3f normalMatrix = pose.m_252943_();
        VertexConsumer consumer = bufferSource.m_6299_(RenderType.m_110473_((ResourceLocation)CENTER_TEXTURE));
        consumer.m_252986_(poseMatrix, 0.0f, -8.0f, -8.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_252986_(poseMatrix, 0.0f, 8.0f, -8.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_252986_(poseMatrix, 0.0f, 8.0f, 8.0f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_252986_(poseMatrix, 0.0f, -8.0f, 8.0f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_5752_();
        poseStack.m_85849_();
    }

    private static void renderEnergySwirls(PoseStack poseStack, MultiBufferSource bufferSource, float animationProgress, float scale) {
        poseStack.m_85836_();
        float entityScale = scale * 0.025f;
        float fadeProgress = 0.5f;
        RandomSource randomSource = RandomSource.m_216335_((long)432L);
        VertexConsumer vertexConsumer = bufferSource.m_6299_(RenderType.m_110436_((ResourceLocation)BEAM_TEXTURE, (float)0.0f, (float)0.0f));
        float segments = Math.min(animationProgress, 0.8f);
        int maxIterations = (int)((segments + segments * segments) / 2.0f * 60.0f);
        for (int i = 0; i < maxIterations; ++i) {
            poseStack.m_252781_(Axis.f_252529_.m_252977_(randomSource.m_188501_() * 360.0f));
            poseStack.m_252781_(Axis.f_252436_.m_252977_(randomSource.m_188501_() * 360.0f));
            poseStack.m_252781_(Axis.f_252403_.m_252977_(randomSource.m_188501_() * 360.0f));
            poseStack.m_252781_(Axis.f_252529_.m_252977_(randomSource.m_188501_() * 360.0f));
            poseStack.m_252781_(Axis.f_252436_.m_252977_(randomSource.m_188501_() * 360.0f));
            poseStack.m_252781_(Axis.f_252403_.m_252977_(randomSource.m_188501_() * 360.0f + animationProgress * 90.0f));
            float size1 = (randomSource.m_188501_() * 10.0f + 5.0f + fadeProgress * 5.0f) * entityScale * 0.4f;
            Matrix4f matrix = poseStack.m_85850_().m_252922_();
            Matrix3f normalMatrix2 = poseStack.m_85850_().m_252943_();
            int alpha = (int)(255.0f * (1.0f - fadeProgress));
            VisualEffectRenderer.drawTriangle(vertexConsumer, matrix, normalMatrix2, size1, alpha);
        }
        poseStack.m_85849_();
    }

    private static void drawTriangle(VertexConsumer consumer, Matrix4f poseMatrix, Matrix3f normalMatrix, float size, int alpha) {
        consumer.m_252986_(poseMatrix, 0.0f, 0.0f, 0.0f).m_6122_(255, 0, 255, alpha).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_252986_(poseMatrix, 0.0f, 3.0f * size, -1.0f * size).m_6122_(0, 0, 0, 0).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_252986_(poseMatrix, 0.0f, 3.0f * size, 1.0f * size).m_6122_(0, 0, 0, 0).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_252986_(poseMatrix, 0.0f, 0.0f, 0.0f).m_6122_(255, 0, 255, alpha).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_5752_();
    }
}

