/*
 * Decompiled with CFR 0.152.
 */
package com.yukami.efiscompat.mixin;

import io.redspace.ironsspellbooks.player.ClientMagicData;
import net.minecraft.resources.ResourceLocation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import yesman.epicfight.api.animation.AnimationPlayer;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.client.animation.ClientAnimator;
import yesman.epicfight.api.client.animation.Layer;
import yesman.epicfight.api.client.forgeevent.RenderEpicFightPlayerEvent;
import yesman.epicfight.compat.PlayerAnimatorCompat;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;

@Mixin(value={PlayerAnimatorCompat.class}, remap=false)
public class MixinPlayerAnimatorCompat {
    private static final String EFISCOMPAT_NAMESPACE = "efiscompat";

    @Inject(method={"renderEvent"}, at={@At(value="HEAD")}, cancellable=true)
    private void onRenderEvent(RenderEpicFightPlayerEvent event, CallbackInfo ci) {
        PlayerPatch playerPatch = event.getPlayerPatch();
        if (playerPatch == null) {
            return;
        }
        ClientAnimator animator = (ClientAnimator)playerPatch.getAnimator();
        if (animator == null) {
            return;
        }
        Layer highestLayer = animator.baseLayer.getLayer(Layer.Priority.HIGHEST);
        if (ClientMagicData.isCasting()) {
            ci.cancel();
            return;
        }
        if (highestLayer == null || highestLayer.isOff()) {
            return;
        }
        AnimationPlayer animationPlayer = highestLayer.animationPlayer;
        if (animationPlayer == null) {
            return;
        }
        ResourceLocation animation = ((StaticAnimation)animationPlayer.getRealAnimation().get()).getRegistryName();
        if (animation != null && EFISCOMPAT_NAMESPACE.equals(animation.m_135827_())) {
            ci.cancel();
        }
    }
}

