/*
 * Decompiled with CFR 0.152.
 */
package com.yukami.efiscompat.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import com.yukami.efiscompat.AnimProps;
import com.yukami.efiscompat.AnimType;
import com.yukami.efiscompat.config.CommonConfig;
import com.yukami.efiscompat.utils.CompatUtils;
import io.redspace.ironsspellbooks.player.ClientMagicData;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import yesman.epicfight.api.animation.AnimationPlayer;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.client.animation.ClientAnimator;
import yesman.epicfight.api.client.animation.Layer;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.client.renderer.patched.item.RenderItemBase;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

@Mixin(value={RenderItemBase.class})
public class MixinRenderItemBase {
    @Inject(method={"renderItemInHand"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void onRenderItemInHandStart(ItemStack stack, LivingEntityPatch<?> entitypatch, InteractionHand hand, OpenMatrix4f[] poses, MultiBufferSource buffer, PoseStack poseStack, int packedLight, float partialTicks, CallbackInfo ci) {
        LivingEntity originalEntity = (LivingEntity)entitypatch.getOriginal();
        if (originalEntity instanceof LocalPlayer) {
            LocalPlayer player = (LocalPlayer)originalEntity;
            if (ClientMagicData.isCasting()) {
                ClientAnimator animator = (ClientAnimator)entitypatch.getAnimator();
                AnimationPlayer animationPlayer = animator.baseLayer.getLayer((Layer.Priority)Layer.Priority.HIGHEST).animationPlayer;
                AnimType animType = null;
                if (animationPlayer != null && animationPlayer.getRealAnimation().isPresent()) {
                    animType = ((StaticAnimation)animationPlayer.getRealAnimation().get()).getProperty(AnimProps.ANIM_TYPE).orElse(null);
                }
                if (animType == AnimType.TWO_HAND) {
                    if (!CompatUtils.isHoldingStaffMainHand((LivingEntity)player) && !CompatUtils.isHoldingStaffOffHand((LivingEntity)player) && CommonConfig.hideTwoHandedItems) {
                        ci.cancel();
                    } else if (!CompatUtils.isHoldingStaffOffHand((LivingEntity)player) && CommonConfig.hideOffHandItems && hand == InteractionHand.OFF_HAND) {
                        ci.cancel();
                    }
                }
            }
        }
    }
}

