/*
 * Decompiled with CFR 0.152.
 */
package com.yukami.efiscompat.network;

import com.yukami.efiscompat.effect.ClientVisualEffectManager;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;

public class ClientboundVisualEffectPacket {
    private final Vec3 position;
    private final float scale;
    private final int durationTicks;
    private final float startScale;
    private final float endScale;
    private final int playerId;

    public ClientboundVisualEffectPacket(Vec3 position, float scale, int durationTicks, float startScale, float endScale, int playerId) {
        this.position = position;
        this.scale = scale;
        this.durationTicks = durationTicks;
        this.startScale = startScale;
        this.endScale = endScale;
        this.playerId = playerId;
    }

    public ClientboundVisualEffectPacket(FriendlyByteBuf buf) {
        this.position = this.readVec3(buf);
        this.scale = buf.readFloat();
        this.durationTicks = buf.readInt();
        this.startScale = buf.readFloat();
        this.endScale = buf.readFloat();
        this.playerId = buf.readInt();
    }

    public void toBytes(FriendlyByteBuf buf) {
        this.writeVec3(this.position, buf);
        buf.writeFloat(this.scale);
        buf.writeInt(this.durationTicks);
        buf.writeFloat(this.startScale);
        buf.writeFloat(this.endScale);
        buf.writeInt(this.playerId);
    }

    private Vec3 readVec3(FriendlyByteBuf buf) {
        double x = buf.readDouble();
        double y = buf.readDouble();
        double z = buf.readDouble();
        return new Vec3(x, y, z);
    }

    private void writeVec3(Vec3 vec3, FriendlyByteBuf buf) {
        buf.writeDouble(vec3.f_82479_);
        buf.writeDouble(vec3.f_82480_);
        buf.writeDouble(vec3.f_82481_);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            try {
                ClientVisualEffectManager.createPlayerFollowingEffect(this.playerId, this.position, this.scale, this.durationTicks, this.startScale, this.endScale);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        return true;
    }

    public Vec3 getPosition() {
        return this.position;
    }

    public float getScale() {
        return this.scale;
    }

    public int getDurationTicks() {
        return this.durationTicks;
    }

    public float getStartScale() {
        return this.startScale;
    }

    public float getEndScale() {
        return this.endScale;
    }
}

