/*
 * Decompiled with CFR 0.152.
 */
package com.yukami.efiscompat.player;

import com.yukami.efiscompat.config.CommonConfig;
import com.yukami.efiscompat.data.SpellAnimationProvider;
import io.redspace.ironsspellbooks.api.events.SpellOnCastEvent;
import io.redspace.ironsspellbooks.api.events.SpellPreCastEvent;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.CastType;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;

@Mod.EventBusSubscriber(modid="efiscompat")
public class PlayerAnimationEvents {
    private static boolean canCastSpell(ServerPlayerPatch playerpatch, Player player) {
        return !playerpatch.isStunned() && !((double)playerpatch.getTickSinceLastAction() <= (double)player.m_36333_() * CommonConfig.castingDelay);
    }

    @SubscribeEvent
    public static void beforeSpellCast(SpellPreCastEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        ServerPlayerPatch playerpatch = (ServerPlayerPatch)EpicFightCapabilities.getEntityPatch((Entity)player2, ServerPlayerPatch.class);
        if (!PlayerAnimationEvents.canCastSpell(playerpatch, (Player)player2)) {
            event.setCanceled(true);
            return;
        }
        String sid = event.getSpellId();
        AbstractSpell spell = SpellRegistry.getSpell((String)sid);
        AnimationManager.AnimationAccessor<StaticAnimation> animation = null;
        if (spell.getCastType() == CastType.LONG) {
            animation = SpellAnimationProvider.getAnimation(spell.getSpellName(), SpellAnimationProvider.AnimationType.CHANT, (Player)player2);
        } else if (spell.getCastType() == CastType.CONTINUOUS) {
            animation = SpellAnimationProvider.getAnimation(spell.getSpellName(), SpellAnimationProvider.AnimationType.CONTINUOUS, (Player)player2);
        }
        if (animation != null) {
            playerpatch.playAnimationSynchronized(animation, 0.0f);
        }
    }

    @SubscribeEvent
    public static void onSpellCast(SpellOnCastEvent event) {
        AnimationManager.AnimationAccessor<StaticAnimation> castAnimation;
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        ServerPlayerPatch playerpatch = (ServerPlayerPatch)EpicFightCapabilities.getEntityPatch((Entity)player2, ServerPlayerPatch.class);
        String sid = event.getSpellId();
        AbstractSpell spell = SpellRegistry.getSpell((String)sid);
        if (spell.getCastType() != CastType.CONTINUOUS && (castAnimation = SpellAnimationProvider.getAnimation(spell.getSpellName(), SpellAnimationProvider.AnimationType.CAST, (Player)player2)) != null) {
            playerpatch.playAnimationSynchronized(castAnimation, 0.0f);
        }
    }
}

