/*
 * Decompiled with CFR 0.152.
 */
package com.yesman.epicparcool;

import com.mojang.logging.LogUtils;
import com.yesman.epicparcool.ParcoolLivingMotions;
import com.yesman.epicparcool.client.event.ParCoolClientEvents;
import com.yesman.epicparcool.client.screen.EpicParCoolConfigurations;
import com.yesman.epicparcool.event.ParCoolEvents;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingException;
import net.minecraftforge.fml.ModLoadingStage;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLConstructModEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.forgespi.language.IModInfo;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.slf4j.Logger;
import yesman.epicfight.api.animation.LivingMotion;

@Mod(value="epicparcool")
public class EpicParCool {
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final String MODID = "epicparcool";
    public static final String LEAST_PARCOOL_VERSION = "3.4.0.6";

    public EpicParCool(FMLJavaModLoadingContext context) {
        ModContainer mc = (ModContainer)ModList.get().getModContainerById("parcool").orElseThrow();
        IModInfo mInfo = mc.getModInfo();
        ArtifactVersion currentVersion = mc.getModInfo().getVersion();
        DefaultArtifactVersion target = new DefaultArtifactVersion(LEAST_PARCOOL_VERSION);
        if (currentVersion.compareTo((Object)target) < 0) {
            throw new ModLoadingException(mInfo, ModLoadingStage.COMMON_SETUP, "Epic Parcool requires Parcool version 3.4.0.6 or over", null, new Object[0]);
        }
        IEventBus modEventbus = context.getModEventBus();
        modEventbus.addListener(ParCoolEvents::onSetup);
        modEventbus.addListener(this::constructMod);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> modEventbus.addListener(ParCoolClientEvents::onSetup));
        context.registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory(EpicParCoolConfigurations::new));
    }

    public void constructMod(FMLConstructModEvent event) {
        LivingMotion.ENUM_MANAGER.registerEnumCls(MODID, ParcoolLivingMotions.class);
    }
}

