/*
 * Decompiled with CFR 0.152.
 */
package com.magistuarmory.client.render.entity.layer;

import com.magistuarmory.client.render.entity.layer.ArmorPatternLayer;
import com.magistuarmory.client.render.model.ModModels;
import com.magistuarmory.client.render.model.decoration.HorseArmorDecorationModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.minecraft.client.model.HorseModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Holder;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.HorseArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.block.entity.BannerBlockEntity;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class HorseArmorDecorationLayer
extends RenderLayer<Horse, HorseModel<Horse>>
implements ArmorPatternLayer {
    private static final String BASE_DIR = "textures/entity/horse/armor/";
    private final HorseArmorDecorationModel<Horse> model;
    private final ResourceLocation baseTexture;
    private final String name;
    private final String dirprefix;

    public HorseArmorDecorationLayer(RenderLayerParent<Horse, HorseModel<Horse>> parent, EntityRendererProvider.Context context, ResourceLocation texture, String name) {
        super(parent);
        this.name = name;
        this.dirprefix = BASE_DIR + name + "/";
        this.baseTexture = texture;
        this.model = new HorseArmorDecorationModel(context.m_174023_(ModModels.createDecorationLocation(new ResourceLocation(texture.m_135827_(), name))));
    }

    public void render(PoseStack pose, MultiBufferSource buffer, int p, Horse entity, float f, float f2, float f3, float f4, float f5, float f6) {
        ItemStack stack = entity.m_30722_();
        if (stack.m_41720_() instanceof HorseArmorItem) {
            ((HorseModel)this.m_117386_()).m_102624_(this.model);
            this.model.m_6839_((AbstractHorse)entity, f, f2, f3);
            this.model.m_6973_((AbstractHorse)entity, f, f2, f4, f5, f6);
            if (BlockItem.m_186336_((ItemStack)stack) != null) {
                List list = BannerBlockEntity.m_58484_((DyeColor)ShieldItem.m_43102_((ItemStack)stack), (ListTag)BannerBlockEntity.m_58487_((ItemStack)stack));
                this.renderPatterns(pose, buffer, p, OverlayTexture.f_118083_, list, false, this.model);
            }
        }
    }

    @Override
    public ResourceLocation getBaseTexture() {
        return this.baseTexture;
    }

    @Override
    public ResourceLocation getPatternTexture(ResourceLocation patternlocation) {
        return new ResourceLocation(this.baseTexture.m_135827_(), this.dirprefix + patternlocation.m_135815_() + ".png");
    }

    public void renderPatterns(PoseStack pose, MultiBufferSource buffer, int p, int overlay, List<Pair<Holder<BannerPattern>, DyeColor>> list, boolean hasfoil, HorseArmorDecorationModel<Horse> model) {
        this.renderPatterns(pose, buffer, p, overlay, list, hasfoil, model.parts(), 1.0f, 1.0f, 1.0f);
    }
}

