/*
 * Decompiled with CFR 0.152.
 */
package com.magistuarmory.item.armor;

import com.magistuarmory.client.render.model.ModModels;
import java.util.EnumMap;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public final class ArmorType
implements ArmorMaterial {
    private final ResourceLocation location;
    private final ResourceLocation modellocation;
    private final float toughness;
    private final float knockbackResistance;
    private final EnumMap<ArmorItem.Type, Integer> durability;
    private final EnumMap<ArmorItem.Type, Integer> defenseForSlot;
    private final int enchantmentValue;
    private final SoundEvent equipSound;
    private final boolean enabled;
    private Supplier<Ingredient> repairIngredient = () -> Ingredient.f_43901_;

    public ArmorType(ResourceLocation location, ResourceLocation modellocation, ArmorMaterial material, boolean enabled) {
        this(location, modellocation, material.m_6651_(), material.m_6649_(), new Integer[]{material.m_266425_(ArmorItem.Type.BOOTS), material.m_266425_(ArmorItem.Type.LEGGINGS), material.m_266425_(ArmorItem.Type.CHESTPLATE), material.m_266425_(ArmorItem.Type.HELMET)}, new Integer[]{material.m_7366_(ArmorItem.Type.BOOTS), material.m_7366_(ArmorItem.Type.LEGGINGS), material.m_7366_(ArmorItem.Type.CHESTPLATE), material.m_7366_(ArmorItem.Type.HELMET)}, material.m_6646_(), material.m_7344_(), enabled, () -> ((ArmorMaterial)material).m_6230_());
    }

    public ArmorType(ResourceLocation location, ResourceLocation modellocation, float toughness, float knockbackResistance, Integer[] durability, Integer[] defenseForSlot, int enchantmentValue, SoundEvent equipSound, boolean enabled) {
        this.location = location;
        this.modellocation = modellocation;
        this.toughness = toughness;
        this.knockbackResistance = knockbackResistance;
        this.durability = (EnumMap)Util.m_137469_(new EnumMap(ArmorItem.Type.class), enumMap -> {
            enumMap.put(ArmorItem.Type.BOOTS, durability[0]);
            enumMap.put(ArmorItem.Type.LEGGINGS, durability[1]);
            enumMap.put(ArmorItem.Type.CHESTPLATE, durability[2]);
            enumMap.put(ArmorItem.Type.HELMET, durability[3]);
        });
        this.defenseForSlot = (EnumMap)Util.m_137469_(new EnumMap(ArmorItem.Type.class), enumMap -> {
            enumMap.put(ArmorItem.Type.BOOTS, defenseForSlot[0]);
            enumMap.put(ArmorItem.Type.LEGGINGS, defenseForSlot[1]);
            enumMap.put(ArmorItem.Type.CHESTPLATE, defenseForSlot[2]);
            enumMap.put(ArmorItem.Type.HELMET, defenseForSlot[3]);
        });
        this.enchantmentValue = enchantmentValue;
        this.equipSound = equipSound;
        this.enabled = enabled;
    }

    public ArmorType(ResourceLocation location, ResourceLocation modellocation, float toughness, float knockbackResistance, Integer[] durability, Integer[] defenseForSlot, int enchantmentValue, SoundEvent equipSound, boolean enabled, Supplier<Ingredient> repairIngredient) {
        this(location, modellocation, toughness, knockbackResistance, durability, defenseForSlot, enchantmentValue, equipSound, enabled);
        this.repairIngredient = repairIngredient;
    }

    public ArmorType(ResourceLocation location, ResourceLocation modellocation, float toughness, float knockbackResistance, Integer[] durability, Integer[] defenseForSlot, int enchantmentValue, SoundEvent equipSound, boolean enabled, String repairitemtag) {
        this(location, modellocation, toughness, knockbackResistance, durability, defenseForSlot, enchantmentValue, equipSound, enabled);
        this.repairIngredient = () -> Ingredient.m_204132_((TagKey)TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation(repairitemtag)));
    }

    public String m_6082_() {
        return this.location.toString();
    }

    public float m_6651_() {
        return this.toughness;
    }

    public float m_6649_() {
        return this.knockbackResistance;
    }

    public int m_266425_(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull ArmorItem.Type type) {
        return this.durability.get(type);
    }

    public int m_7366_(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull ArmorItem.Type type) {
        return this.defenseForSlot.get(type);
    }

    public int m_6646_() {
        return this.enchantmentValue;
    }

    public SoundEvent m_7344_() {
        return this.equipSound;
    }

    public Ingredient m_6230_() {
        return this.repairIngredient.get();
    }

    public boolean isDisabled() {
        return !this.enabled;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Optional<ModelLayerLocation> getModelLocation() {
        if (Objects.equals(this.modellocation.m_135815_(), "default")) {
            return Optional.empty();
        }
        return Optional.of(ModModels.createArmorLocation(this.modellocation));
    }
}

