/*
 * Decompiled with CFR 0.152.
 */
package com.magistuarmory.item.crafting;

import com.magistuarmory.item.ArmorDecoration;
import com.magistuarmory.item.DyeableArmorDecorationItem;
import com.magistuarmory.item.MedievalBagItem;
import com.magistuarmory.item.ModItems;
import com.magistuarmory.item.crafting.forge.DecorationRemoveRecipeImpl;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.HorseArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BannerBlock;
import org.jetbrains.annotations.NotNull;

public class DecorationRemoveRecipe
extends CustomRecipe {
    public static RecipeSerializer<DecorationRemoveRecipe> SERIALIZER = new SimpleCraftingRecipeSerializer(DecorationRemoveRecipe::new);

    public DecorationRemoveRecipe(ResourceLocation location, CraftingBookCategory category) {
        super(location, CraftingBookCategory.MISC);
    }

    public boolean matches(CraftingContainer container, Level level) {
        ItemStack stack = ItemStack.f_41583_;
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack stack2 = container.m_8020_(i);
            if (stack2.m_41619_()) continue;
            if (DecorationRemoveRecipe.isDecorated(stack2)) {
                if (!stack.m_41619_()) {
                    return false;
                }
                stack = stack2;
                continue;
            }
            return false;
        }
        return !stack.m_41619_();
    }

    public ItemStack assemble(CraftingContainer container, @NotNull RegistryAccess access) {
        ItemStack stack = ItemStack.f_41583_;
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack stack2 = container.m_8020_(i);
            if (stack2.m_41619_() || !DecorationRemoveRecipe.isDecorated(stack2)) continue;
            stack = stack2;
            break;
        }
        if (!stack.m_41619_()) {
            ItemStack bagstack = new ItemStack((ItemLike)ModItems.MEDIEVAL_BAG.get());
            List<ItemStack> stacks = DecorationRemoveRecipe.takeApart(stack);
            if (stacks.isEmpty()) {
                return ItemStack.f_41583_;
            }
            MedievalBagItem.setContents(bagstack, stacks);
            return bagstack;
        }
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int i, int j) {
        return i * j >= 1;
    }

    public RecipeSerializer<?> m_7707_() {
        return DecorationRemoveRecipe.getSerializerInstance();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static RecipeSerializer<DecorationRemoveRecipe> getSerializerInstance() {
        return DecorationRemoveRecipeImpl.getSerializerInstance();
    }

    static boolean mightBeDecorated(Item item) {
        return item instanceof ArmorItem || item instanceof ShieldItem || item instanceof HorseArmorItem;
    }

    static boolean isDecorated(ItemStack stack) {
        if (!DecorationRemoveRecipe.mightBeDecorated(stack.m_41720_())) {
            return false;
        }
        CompoundTag blockcompound = BlockItem.m_186336_((ItemStack)stack);
        if (blockcompound != null && blockcompound.m_128441_("Base")) {
            return true;
        }
        CompoundTag decorationdata = stack.m_41737_("ArmorDecoration");
        return decorationdata != null && !decorationdata.m_128437_("Items", 10).isEmpty();
    }

    static List<ItemStack> takeApart(ItemStack stack) {
        CompoundTag decorationdata;
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        ItemStack newstack = stack.m_41777_();
        CompoundTag blockcompound = BlockItem.m_186336_((ItemStack)newstack);
        if (blockcompound != null && blockcompound.m_128441_("Base")) {
            BannerItem banner = (BannerItem)BannerBlock.m_49014_((DyeColor)DyeColor.m_41053_((int)blockcompound.m_128451_("Base"))).m_5456_();
            ItemStack bannerstack = new ItemStack((ItemLike)banner);
            bannerstack.m_41700_("BlockEntityTag", (Tag)blockcompound.m_6426_());
            newstack.m_41749_("BlockEntityTag");
            stacks.add(bannerstack);
        }
        if ((decorationdata = newstack.m_41737_("ArmorDecoration")) != null) {
            ListTag listtag = decorationdata.m_128437_("Items", 10);
            while (!listtag.isEmpty()) {
                CompoundTag tag = listtag.m_128728_(listtag.size() - 1);
                String name = tag.m_128461_("name");
                int color = tag.m_128451_("color");
                ArmorDecoration decoration = (ArmorDecoration)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(name + "_decoration"));
                ItemStack decorationstack = new ItemStack((ItemLike)decoration);
                if (decoration instanceof DyeableArmorDecorationItem) {
                    DyeableArmorDecorationItem dyeabedecoration = (DyeableArmorDecorationItem)decoration;
                    dyeabedecoration.m_41115_(decorationstack, color);
                }
                listtag.remove(listtag.size() - 1);
                decorationdata.m_128365_("Items", (Tag)listtag);
                newstack.m_41700_("ArmorDecoration", (Tag)decorationdata);
                stacks.add(decorationstack);
            }
        }
        newstack.m_41787_();
        stacks.add(newstack);
        return stacks;
    }
}

