/*
 * Decompiled with CFR 0.152.
 */
package com.merlin204.avalon.entity.client.renderer.patch.item;

import com.google.gson.JsonElement;
import com.merlin204.avalon.item.animationitem.IAvalonAnimationItem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.client.model.Meshes;
import yesman.epicfight.api.client.model.SkinnedMesh;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.client.renderer.patched.item.RenderItemBase;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class RenderMeshItem
extends RenderItemBase {
    private final ResourceLocation texture;
    private final ResourceLocation texture_l;
    private final AssetAccessor<? extends SkinnedMesh> mesh_main;
    private final AssetAccessor<? extends SkinnedMesh> mesh_off;

    public RenderMeshItem(JsonElement jsonElement) {
        super(jsonElement);
        ResourceLocation resLoc;
        String meshLoc;
        this.texture = jsonElement.getAsJsonObject().has("texture") ? ResourceLocation.parse((String)jsonElement.getAsJsonObject().get("texture").getAsString()) : null;
        this.texture_l = jsonElement.getAsJsonObject().has("texture_l") ? ResourceLocation.parse((String)jsonElement.getAsJsonObject().get("texture_l").getAsString()) : null;
        if (jsonElement.getAsJsonObject().has("mesh_main")) {
            meshLoc = jsonElement.getAsJsonObject().get("mesh_main").getAsString();
            resLoc = ResourceLocation.parse((String)meshLoc);
            this.mesh_main = Meshes.MeshAccessor.create((String)resLoc.m_135827_(), (String)resLoc.m_135815_(), loader -> loader.loadSkinnedMesh(SkinnedMesh::new));
        } else {
            this.mesh_main = null;
        }
        if (jsonElement.getAsJsonObject().has("mesh_off")) {
            meshLoc = jsonElement.getAsJsonObject().get("mesh_off").getAsString();
            resLoc = ResourceLocation.parse((String)meshLoc);
            this.mesh_off = Meshes.MeshAccessor.create((String)resLoc.m_135827_(), (String)resLoc.m_135815_(), loader -> loader.loadSkinnedMesh(SkinnedMesh::new));
        } else {
            this.mesh_off = null;
        }
    }

    public void renderItemInHand(ItemStack stack, LivingEntityPatch<?> entitypatch, InteractionHand hand, OpenMatrix4f[] poses, MultiBufferSource buffer, PoseStack poseStack, int packedLight, float partialTicks) {
        SkinnedMesh renderMesh = null;
        if (hand == InteractionHand.MAIN_HAND) {
            renderMesh = (SkinnedMesh)this.mesh_main.get();
        } else if (hand == InteractionHand.OFF_HAND) {
            renderMesh = (SkinnedMesh)this.mesh_off.get();
        }
        Armature armature = entitypatch.getArmature();
        poseStack.m_85836_();
        if (stack.m_41720_() instanceof IAvalonAnimationItem) {
            poseStack.m_85849_();
            return;
        }
        armature.setPose(entitypatch.getAnimator().getPose(partialTicks));
        if (renderMesh != null) {
            renderMesh.draw(poseStack, buffer, RenderType.m_110452_((ResourceLocation)this.texture), packedLight, 1.0f, 1.0f, 1.0f, 1.0f, OverlayTexture.f_118083_, armature, armature.getPoseMatrices());
            if (this.texture_l != null) {
                renderMesh.draw(poseStack, buffer, RenderType.m_234338_((ResourceLocation)this.texture_l), packedLight, 1.0f, 1.0f, 1.0f, 0.9f, OverlayTexture.f_118083_, armature, armature.getPoseMatrices());
            }
        }
        poseStack.m_85849_();
    }
}

