/*
 * Decompiled with CFR 0.152.
 */
package com.merlin204.avalon.entity.vfx;

import com.google.common.collect.Maps;
import com.merlin204.avalon.entity.IAvalonMeshEntity;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.client.model.Meshes;
import yesman.epicfight.api.client.model.SkinnedMesh;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.gameasset.Armatures;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.EntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.entity.ai.attribute.EpicFightAttributes;

public class VFXEntity
extends PathfinderMob
implements IAvalonMeshEntity {
    protected static final EntityDataAccessor<Optional<UUID>> DATA_OWNER_UUID = SynchedEntityData.m_135353_(VFXEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    protected static final EntityDataAccessor<Integer> DATA_OWNER_ID = SynchedEntityData.m_135353_(VFXEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Float> DIS_RATIO = SynchedEntityData.m_135353_(VFXEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected static final EntityDataAccessor<Float> DIS_SPEED = SynchedEntityData.m_135353_(VFXEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected static final EntityDataAccessor<Float> SCALE = SynchedEntityData.m_135353_(VFXEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected static final EntityDataAccessor<Float> Y_ROT_OFFSET = SynchedEntityData.m_135353_(VFXEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected static final EntityDataAccessor<Float> X_ROT_OFFSET = SynchedEntityData.m_135353_(VFXEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected static final EntityDataAccessor<Float> Z_ROT_OFFSET = SynchedEntityData.m_135353_(VFXEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected static final EntityDataAccessor<Float> START_Y_ROT = SynchedEntityData.m_135353_(VFXEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected static final EntityDataAccessor<Boolean> PLAY_ANIMATION = SynchedEntityData.m_135353_(VFXEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Boolean> SHOULD_RENDER = SynchedEntityData.m_135353_(VFXEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<String> MESH_PATH = SynchedEntityData.m_135353_(VFXEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    protected static final EntityDataAccessor<String> ARMATURE_PATH = SynchedEntityData.m_135353_(VFXEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    protected static final EntityDataAccessor<String> TEXTURE_PATH = SynchedEntityData.m_135353_(VFXEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    protected static final EntityDataAccessor<String> LIGHT_TEXTURE_PATH = SynchedEntityData.m_135353_(VFXEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    protected Armatures.ArmatureAccessor<? extends Armature> ARMATURE_ACCESSOR;
    protected ResourceLocation TEXTURE;
    protected ResourceLocation LIGHT_TEXTURE;
    protected AnimationManager.AnimationAccessor<? extends StaticAnimation> DEFAULT_ANIMATION;
    public float disRatioOld;
    private final Map<MobEffect, MobEffectInstance> fakeActiveEffects = Maps.newHashMap();

    public VFXEntity(EntityType<? extends VFXEntity> entityType, LivingEntity owner, float scale) {
        super(entityType, owner.m_9236_());
        this.tame(owner);
        this.m_20088_().m_135381_(SCALE, (Object)Float.valueOf(scale));
        this.f_19811_ = true;
        this.f_19794_ = true;
        this.m_20242_(true);
        this.ARMATURE_ACCESSOR = null;
        this.TEXTURE = null;
        this.DEFAULT_ANIMATION = null;
        this.LIGHT_TEXTURE = null;
        this.m_6842_(true);
    }

    public VFXEntity(EntityType<? extends VFXEntity> entityType, LivingEntity owner, float scale, Armatures.ArmatureAccessor<? extends Armature> armatureAccessor, ResourceLocation mesh, ResourceLocation texture, ResourceLocation lightTexture, AnimationManager.AnimationAccessor<? extends StaticAnimation> defaultAnimation) {
        super(entityType, owner.m_9236_());
        this.f_19811_ = true;
        this.LIGHT_TEXTURE = lightTexture;
        this.tame(owner);
        this.m_20088_().m_135381_(SCALE, (Object)Float.valueOf(scale));
        this.f_19794_ = true;
        this.m_20242_(true);
        this.ARMATURE_ACCESSOR = armatureAccessor;
        this.TEXTURE = texture;
        this.DEFAULT_ANIMATION = defaultAnimation;
        this.f_19804_.m_135381_(ARMATURE_PATH, (Object)this.ARMATURE_ACCESSOR.registryName().toString());
        this.f_19804_.m_135381_(MESH_PATH, (Object)mesh.toString());
        this.f_19804_.m_135381_(TEXTURE_PATH, (Object)this.TEXTURE.toString());
        this.f_19804_.m_135381_(LIGHT_TEXTURE_PATH, (Object)this.LIGHT_TEXTURE.toString());
        this.m_6842_(true);
    }

    public VFXEntity(EntityType<? extends VFXEntity> entityType, LivingEntity owner, float scale, Vec3f rotOffset, Armatures.ArmatureAccessor<? extends Armature> armatureAccessor, ResourceLocation mesh, ResourceLocation texture, ResourceLocation lightTexture, AnimationManager.AnimationAccessor<? extends StaticAnimation> defaultAnimation) {
        super(entityType, owner.m_9236_());
        this.f_19811_ = true;
        this.LIGHT_TEXTURE = lightTexture;
        this.tame(owner);
        this.m_20088_().m_135381_(SCALE, (Object)Float.valueOf(scale));
        this.m_20088_().m_135381_(X_ROT_OFFSET, (Object)Float.valueOf(rotOffset.x));
        this.m_20088_().m_135381_(Y_ROT_OFFSET, (Object)Float.valueOf(rotOffset.y));
        this.m_20088_().m_135381_(Z_ROT_OFFSET, (Object)Float.valueOf(rotOffset.z));
        this.f_19794_ = true;
        this.m_20242_(true);
        this.ARMATURE_ACCESSOR = armatureAccessor;
        float ownerYRot = this.getOwner().m_146908_();
        this.setStartYRot(ownerYRot);
        this.TEXTURE = texture;
        this.DEFAULT_ANIMATION = defaultAnimation;
        this.f_19804_.m_135381_(ARMATURE_PATH, (Object)this.ARMATURE_ACCESSOR.registryName().toString());
        this.f_19804_.m_135381_(MESH_PATH, (Object)mesh.toString());
        this.f_19804_.m_135381_(TEXTURE_PATH, (Object)this.TEXTURE.toString());
        this.f_19804_.m_135381_(LIGHT_TEXTURE_PATH, (Object)this.LIGHT_TEXTURE.toString());
        this.m_6842_(true);
    }

    public VFXEntity(EntityType<? extends VFXEntity> entityType, Level level) {
        super(entityType, level);
        this.f_19794_ = true;
        this.m_20242_(true);
        this.ARMATURE_ACCESSOR = null;
        this.TEXTURE = null;
        this.DEFAULT_ANIMATION = null;
        this.LIGHT_TEXTURE = null;
    }

    public void m_8119_() {
        super.m_8119_();
        this.f_19789_ = 0.0f;
        this.f_19794_ = true;
        this.m_20242_(true);
        boolean playAnimation = this.getPlayAnimation();
        if (!playAnimation) {
            float ownerYRot = this.getStartYRot();
            this.m_146922_(ownerYRot);
            this.m_5618_(ownerYRot);
            this.m_5616_(ownerYRot);
        }
        if (this.m_9236_().f_46443_) {
            float speed = ((Float)this.f_19804_.m_135370_(DIS_SPEED)).floatValue();
            if (speed > 0.0f && speed < 1.0f) {
                this.f_19804_.m_135381_(DIS_RATIO, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(DIS_RATIO)).floatValue() - speed));
            }
            if (this.ARMATURE_ACCESSOR == null) {
                this.ARMATURE_ACCESSOR = Armatures.ArmatureAccessor.create((String)ResourceLocation.parse((String)((String)this.f_19804_.m_135370_(ARMATURE_PATH))).m_135827_(), (String)ResourceLocation.parse((String)((String)this.f_19804_.m_135370_(ARMATURE_PATH))).m_135815_(), Armature::new);
            }
            if (this.TEXTURE == null) {
                this.TEXTURE = ResourceLocation.parse((String)((String)this.f_19804_.m_135370_(TEXTURE_PATH)));
            }
            if (this.LIGHT_TEXTURE == null) {
                this.LIGHT_TEXTURE = ResourceLocation.parse((String)((String)this.f_19804_.m_135370_(LIGHT_TEXTURE_PATH)));
            }
        } else if (this.getOwner() != null && !this.getOwner().m_6084_()) {
            this.m_146870_();
        }
        this.disRatioOld = this.getDisRatio();
    }

    @Override
    @Nullable
    public Armature getArmature() {
        if (this.ARMATURE_ACCESSOR == null) {
            return Armatures.BIPED.get();
        }
        return this.ARMATURE_ACCESSOR.get();
    }

    @Override
    @Nullable
    public AssetAccessor<? extends SkinnedMesh> getMesh() {
        return Meshes.MeshAccessor.create((String)ResourceLocation.parse((String)((String)this.f_19804_.m_135370_(MESH_PATH))).m_135827_(), (String)ResourceLocation.parse((String)((String)this.f_19804_.m_135370_(MESH_PATH))).m_135815_(), jsonModelLoader -> jsonModelLoader.loadSkinnedMesh(SkinnedMesh::new));
    }

    @Override
    @Nullable
    public ResourceLocation getTexture() {
        return this.TEXTURE;
    }

    @Override
    @Nullable
    public ResourceLocation getLitTexture() {
        return this.LIGHT_TEXTURE;
    }

    public float m_6134_() {
        return ((Float)this.f_19804_.m_135370_(SCALE)).floatValue();
    }

    public float getXRotOffset() {
        return ((Float)this.f_19804_.m_135370_(X_ROT_OFFSET)).floatValue();
    }

    public float getZRotOffset() {
        return ((Float)this.f_19804_.m_135370_(Z_ROT_OFFSET)).floatValue();
    }

    public float getYRotOffset() {
        return ((Float)this.f_19804_.m_135370_(Y_ROT_OFFSET)).floatValue();
    }

    @Override
    @Nullable
    public AnimationManager.AnimationAccessor<? extends StaticAnimation> getIdleAnimation() {
        return Animations.EMPTY_ANIMATION;
    }

    @Nullable
    public AnimationManager.AnimationAccessor<? extends StaticAnimation> getDefaultAnimation() {
        return this.DEFAULT_ANIMATION;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_OWNER_UUID, Optional.empty());
        this.f_19804_.m_135372_(DATA_OWNER_ID, (Object)0);
        this.f_19804_.m_135372_(SCALE, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(DIS_RATIO, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(DIS_SPEED, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(Y_ROT_OFFSET, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(X_ROT_OFFSET, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(Z_ROT_OFFSET, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(START_Y_ROT, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(PLAY_ANIMATION, (Object)false);
        this.f_19804_.m_135372_(SHOULD_RENDER, (Object)false);
        this.f_19804_.m_135372_(ARMATURE_PATH, (Object)"");
        this.f_19804_.m_135372_(MESH_PATH, (Object)"");
        this.f_19804_.m_135372_(TEXTURE_PATH, (Object)"");
        this.f_19804_.m_135372_(LIGHT_TEXTURE_PATH, (Object)"");
    }

    public float getDisRatio() {
        return ((Float)this.f_19804_.m_135370_(DIS_RATIO)).floatValue();
    }

    public void setDisSpeed(float speed) {
        this.f_19804_.m_135381_(DIS_SPEED, (Object)Float.valueOf(speed));
    }

    @Nullable
    public UUID getOwnerUUID() {
        return ((Optional)this.f_19804_.m_135370_(DATA_OWNER_UUID)).orElse(null);
    }

    public void setOwnerUUID(@Nullable UUID pUuid) {
        this.f_19804_.m_135381_(DATA_OWNER_UUID, Optional.ofNullable(pUuid));
    }

    public int getOwnerID() {
        return (Integer)this.f_19804_.m_135370_(DATA_OWNER_ID);
    }

    public void setOwnerID(int id) {
        this.f_19804_.m_135381_(DATA_OWNER_ID, (Object)id);
    }

    public float getStartYRot() {
        return ((Float)this.f_19804_.m_135370_(START_Y_ROT)).floatValue();
    }

    public void setStartYRot(float f) {
        this.f_19804_.m_135381_(START_Y_ROT, (Object)Float.valueOf(f));
    }

    public void tame(LivingEntity livingEntity) {
        this.setOwnerUUID(livingEntity.m_20148_());
        this.setOwnerID(livingEntity.m_19879_());
    }

    @Nullable
    public LivingEntity getOwner() {
        UUID uuid = this.getOwnerUUID();
        if (uuid != null) {
            Player player = this.m_9236_().m_46003_(uuid);
            if (player == null) {
                LivingEntity livingEntity;
                Level level = this.m_9236_();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    Entity entity = serverLevel.m_8791_(uuid);
                    return entity instanceof LivingEntity ? (livingEntity = (LivingEntity)entity) : null;
                }
                Entity entity = this.m_9236_().m_6815_(this.getOwnerID());
                return entity instanceof LivingEntity ? (livingEntity = (LivingEntity)entity) : null;
            }
            return player;
        }
        return null;
    }

    public LivingEntityPatch<?> getOwnerPatch() {
        return (LivingEntityPatch)EpicFightCapabilities.getEntityPatch((Entity)this.getOwner(), LivingEntityPatch.class);
    }

    public LivingEntityPatch<?> getPatch() {
        return (LivingEntityPatch)EpicFightCapabilities.getEntityPatch((Entity)this, LivingEntityPatch.class);
    }

    public <T extends EntityPatch<?>> T getPatch(Class<T> type) {
        return (T)EpicFightCapabilities.getEntityPatch((Entity)this, type);
    }

    public boolean getPlayAnimation() {
        return (Boolean)this.f_19804_.m_135370_(PLAY_ANIMATION);
    }

    public void setPlayAnimation(boolean b) {
        this.f_19804_.m_135381_(PLAY_ANIMATION, (Object)b);
    }

    public boolean getShouldRender() {
        return (Boolean)this.f_19804_.m_135370_(SHOULD_RENDER);
    }

    public void setShouldRender(boolean b) {
        this.f_19804_.m_135381_(SHOULD_RENDER, (Object)b);
    }

    public Collection<MobEffectInstance> m_21220_() {
        return this.fakeActiveEffects.values();
    }

    public static AttributeSupplier getDefaultAttribute() {
        return Animal.m_21552_().m_22268_(Attributes.f_22276_, (double)19.9f).m_22268_(Attributes.f_22281_, 3.0).m_22268_((Attribute)EpicFightAttributes.MAX_STRIKES.get(), 10.0).m_22265_();
    }

    protected void moveToOwner(LivingEntity owner) {
        this.m_146922_(owner.f_20883_);
        this.m_5618_(owner.f_20883_);
        this.m_5616_(owner.f_20883_);
        this.m_146884_(owner.m_20182_());
    }

    protected boolean shouldRemoveWhenOwnerLost() {
        return false;
    }

    public boolean m_6469_(@NotNull DamageSource source, float p_21017_) {
        return false;
    }

    protected void m_7355_(@NotNull BlockPos pPos, @NotNull BlockState pState) {
    }

    public boolean m_142535_(float pFallDistance, float pMultiplier, @NotNull DamageSource pSource) {
        return false;
    }

    public boolean m_5843_() {
        return false;
    }
}

