/*
 * Decompiled with CFR 0.152.
 */
package com.merlin204.avalon.util;

import com.merlin204.avalon.epicfight.animations.AvalonAttackAnimation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.animation.JointTransform;
import yesman.epicfight.api.animation.Pose;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.collider.Collider;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class AvalonAnimationUtils {
    public static Vec3 getJointWorldPos(LivingEntityPatch<?> entityPatch, Joint joint) {
        return AvalonAnimationUtils.getJointWorldPos(entityPatch, joint, Vec3f.ZERO);
    }

    public static Vec3 getJointWorldRawPos(LivingEntityPatch<?> entityPatch, Joint joint, float time) {
        return AvalonAnimationUtils.getJointWorldRawPos(entityPatch, joint, time, Vec3f.ZERO);
    }

    public static Vec3 getJointWorldPos(LivingEntityPatch<?> entityPatch, Joint joint, Vec3f offset) {
        LivingEntity entity = (LivingEntity)entityPatch.getOriginal();
        OpenMatrix4f transformMatrix = entityPatch.getArmature().getBoundTransformFor(entityPatch.getAnimator().getPose(0.1f), joint);
        transformMatrix.translate(offset);
        OpenMatrix4f rotation = new OpenMatrix4f().rotate(-((float)Math.toRadians(entity.f_20884_ + 180.0f)), new Vec3f(0.0f, 1.0f, 0.0f));
        OpenMatrix4f.mul((OpenMatrix4f)rotation, (OpenMatrix4f)transformMatrix, (OpenMatrix4f)transformMatrix);
        Vec3 pos = new Vec3((double)(transformMatrix.m30 + (float)entity.m_20185_()), (double)(transformMatrix.m31 + (float)entity.m_20186_()), (double)(transformMatrix.m32 + (float)entity.m_20189_()));
        return pos;
    }

    public static Vec3 getJointWorldPos(LivingEntityPatch<?> entityPatch, Joint joint, Vec3f offset, float partialTicks) {
        LivingEntity entity = (LivingEntity)entityPatch.getOriginal();
        OpenMatrix4f transformMatrix = entityPatch.getArmature().getBoundTransformFor(entityPatch.getAnimator().getPose(partialTicks), joint);
        transformMatrix.translate(offset);
        OpenMatrix4f rotation = new OpenMatrix4f().rotate(-((float)Math.toRadians(entity.f_20884_ + 180.0f)), new Vec3f(0.0f, 1.0f, 0.0f));
        OpenMatrix4f.mul((OpenMatrix4f)rotation, (OpenMatrix4f)transformMatrix, (OpenMatrix4f)transformMatrix);
        Vec3 pos = new Vec3((double)(transformMatrix.m30 + (float)entity.m_20185_()), (double)(transformMatrix.m31 + (float)entity.m_20186_()), (double)(transformMatrix.m32 + (float)entity.m_20189_()));
        return pos;
    }

    public static Vec3 getJointWorldRawPos(LivingEntityPatch<?> entityPatch, Joint joint, float time, Vec3f offset) {
        Animator animator = entityPatch.getAnimator();
        LivingEntity entity = (LivingEntity)entityPatch.getOriginal();
        Pose pose = ((DynamicAnimation)animator.getPlayerFor(null).getAnimation().get()).getRawPose(time);
        OpenMatrix4f transformMatrix = entityPatch.getArmature().getBoundTransformFor(pose, joint);
        transformMatrix.translate(offset);
        OpenMatrix4f rotation = new OpenMatrix4f().rotate(-((float)Math.toRadians(entity.f_20884_ + 180.0f)), new Vec3f(0.0f, 1.0f, 0.0f));
        OpenMatrix4f.mul((OpenMatrix4f)rotation, (OpenMatrix4f)transformMatrix, (OpenMatrix4f)transformMatrix);
        Vec3 pos = new Vec3((double)(transformMatrix.m30 + (float)entity.m_20185_()), (double)(transformMatrix.m31 + (float)entity.m_20186_()), (double)(transformMatrix.m32 + (float)entity.m_20189_()));
        return pos;
    }

    public static void joinRotationInPose(Pose pose, LivingEntityPatch entityPatch, String joint, float x, float y, float z) {
        if (entityPatch.getArmature() == null) {
            return;
        }
        OpenMatrix4f toOriginalRotation = new OpenMatrix4f(entityPatch.getArmature().getBoundTransformFor(pose, entityPatch.getArmature().searchJointByName(joint))).removeScale().removeTranslation().invert();
        Vec3f xAxis = OpenMatrix4f.transform3v((OpenMatrix4f)toOriginalRotation, (Vec3f)Vec3f.X_AXIS, (Vec3f)null);
        Vec3f yAxis = OpenMatrix4f.transform3v((OpenMatrix4f)toOriginalRotation, (Vec3f)Vec3f.Y_AXIS, (Vec3f)null);
        Vec3f zAxis = OpenMatrix4f.transform3v((OpenMatrix4f)toOriginalRotation, (Vec3f)Vec3f.Z_AXIS, (Vec3f)null);
        OpenMatrix4f headRotation = OpenMatrix4f.createRotatorDeg((float)y, (Vec3f)yAxis).rotateDeg(x, xAxis).rotateDeg(z, zAxis);
        pose.orElseEmpty(joint).frontResult(JointTransform.fromMatrix((OpenMatrix4f)headRotation), OpenMatrix4f::mul);
    }

    public static AvalonAttackAnimation.AvalonPhase createSimplePhase(int startFrame, int endFrame, int waitFrame, InteractionHand interactionHand, Joint joint, Collider collider) {
        float start = (float)startFrame / 60.0f;
        float end = (float)endFrame / 60.0f;
        float wait = (float)waitFrame / 60.0f;
        return new AvalonAttackAnimation.AvalonPhase(0.0f, start, start, end, wait, Float.MAX_VALUE, interactionHand, joint, collider);
    }

    public static AvalonAttackAnimation.AvalonPhase createSimplePhase(int startFrame, int endFrame, int waitFrame, InteractionHand interactionHand, float damageMulti, Joint joint, Collider collider) {
        float start = (float)startFrame / 60.0f;
        float end = (float)endFrame / 60.0f;
        float wait = (float)waitFrame / 60.0f;
        return new AvalonAttackAnimation.AvalonPhase(0.0f, start, start, end, wait, Float.MAX_VALUE, interactionHand, damageMulti, joint, collider);
    }

    public static AvalonAttackAnimation.AvalonPhase createSimplePhase(int startFrame, int endFrame, int waitFrame, InteractionHand interactionHand, float damageMulti, float impactDamageMulti, Joint joint, Collider collider) {
        float start = (float)startFrame / 60.0f;
        float end = (float)endFrame / 60.0f;
        float wait = (float)waitFrame / 60.0f;
        return new AvalonAttackAnimation.AvalonPhase(0.0f, start, start, end, wait, Float.MAX_VALUE, interactionHand, damageMulti, impactDamageMulti, joint, collider);
    }

    public static AvalonAttackAnimation.AvalonPhase createSimplePhase(int startFrame, int endFrame, int waitFrame, InteractionHand interactionHand, float damageMulti, float impactDamageMulti, float phaseArmorNegationMulti, Joint joint, Collider collider) {
        float start = (float)startFrame / 60.0f;
        float end = (float)endFrame / 60.0f;
        float wait = (float)waitFrame / 60.0f;
        return new AvalonAttackAnimation.AvalonPhase(0.0f, start, start, end, wait, Float.MAX_VALUE, interactionHand, damageMulti, impactDamageMulti, phaseArmorNegationMulti, joint, collider);
    }

    public static AvalonAttackAnimation.AvalonPhase createSimplePhase(int startFrame, int endFrame, int waitFrame, InteractionHand interactionHand, AttackAnimation.JointColliderPair ... colliders) {
        float start = (float)startFrame / 60.0f;
        float end = (float)endFrame / 60.0f;
        float wait = (float)waitFrame / 60.0f;
        return new AvalonAttackAnimation.AvalonPhase(0.0f, start, start, end, wait, Float.MAX_VALUE, interactionHand, colliders);
    }

    public static AvalonAttackAnimation.AvalonPhase createSimplePhase(int startFrame, int endFrame, int waitFrame, InteractionHand interactionHand, float damageMulti, AttackAnimation.JointColliderPair ... colliders) {
        float start = (float)startFrame / 60.0f;
        float end = (float)endFrame / 60.0f;
        float wait = (float)waitFrame / 60.0f;
        return new AvalonAttackAnimation.AvalonPhase(0.0f, start, start, end, wait, Float.MAX_VALUE, interactionHand, damageMulti, colliders);
    }

    public static AvalonAttackAnimation.AvalonPhase createSimplePhase(int startFrame, int endFrame, int waitFrame, InteractionHand interactionHand, float damageMulti, float impactDamageMulti, AttackAnimation.JointColliderPair ... colliders) {
        float start = (float)startFrame / 60.0f;
        float end = (float)endFrame / 60.0f;
        float wait = (float)waitFrame / 60.0f;
        return new AvalonAttackAnimation.AvalonPhase(0.0f, start, start, end, wait, Float.MAX_VALUE, interactionHand, damageMulti, impactDamageMulti, colliders);
    }

    public static AvalonAttackAnimation.AvalonPhase createSimplePhase(int startFrame, int endFrame, int waitFrame, InteractionHand interactionHand, float damageMulti, float impactDamageMulti, float phaseArmorNegationMulti, AttackAnimation.JointColliderPair ... colliders) {
        float start = (float)startFrame / 60.0f;
        float end = (float)endFrame / 60.0f;
        float wait = (float)waitFrame / 60.0f;
        return new AvalonAttackAnimation.AvalonPhase(0.0f, start, start, end, wait, Float.MAX_VALUE, interactionHand, damageMulti, impactDamageMulti, phaseArmorNegationMulti, colliders);
    }
}

