/*
 * Decompiled with CFR 0.152.
 */
package com.ashenhart.epic_fight_musket_compat.skill.weaponinnate;

import com.ashenhart.epic_fight_musket_compat.gameassets.MusketAnimations;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.skill.SkillBuilder;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.weaponinnate.WeaponInnateSkill;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.effect.EpicFightMobEffects;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class LastPushSkill
extends WeaponInnateSkill {
    private static final UUID EVENT_UUID = UUID.fromString("1f6aea85-2194-4761-af8e-1a5c99c4f414");
    public final AssetAccessor<? extends AttackAnimation> first = MusketAnimations.LAST_PUSH_TRY;
    public final AssetAccessor<? extends AttackAnimation> second = MusketAnimations.LAST_PUSH_HIT;
    public final AssetAccessor<? extends AttackAnimation> third = MusketAnimations.LAST_PUSH_EXECUTE;
    public final AssetAccessor<? extends AttackAnimation> fail = MusketAnimations.LAST_PUSH_FAIL;

    public LastPushSkill(SkillBuilder<? extends WeaponInnateSkill> builder) {
        super(builder);
    }

    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.ATTACK_ANIMATION_END_EVENT, EVENT_UUID, event -> {
            List hurtEntities;
            if (MusketAnimations.LAST_PUSH_TRY.equals((Object)event.getAnimation())) {
                hurtEntities = ((ServerPlayerPatch)event.getPlayerPatch()).getCurrentlyActuallyHitEntities();
                ((ServerPlayerPatch)event.getPlayerPatch()).getServerAnimator().getPlayerFor(null).reset();
                ((ServerPlayerPatch)event.getPlayerPatch()).reserveAnimation(this.second);
                ((ServerPlayerPatch)event.getPlayerPatch()).getCurrentlyActuallyHitEntities().clear();
            }
            if (MusketAnimations.LAST_PUSH_HIT.equals((Object)event.getAnimation())) {
                hurtEntities = ((ServerPlayerPatch)event.getPlayerPatch()).getCurrentlyActuallyHitEntities();
                if (!hurtEntities.isEmpty() && ((LivingEntity)hurtEntities.get(0)).m_6084_()) {
                    ((ServerPlayerPatch)event.getPlayerPatch()).getServerAnimator().getPlayerFor(null).reset();
                    ((ServerPlayerPatch)event.getPlayerPatch()).reserveAnimation(this.third);
                    ((ServerPlayerPatch)event.getPlayerPatch()).getCurrentlyActuallyHitEntities().clear();
                } else {
                    ((ServerPlayerPatch)event.getPlayerPatch()).getServerAnimator().getPlayerFor(null).reset();
                    ((ServerPlayerPatch)event.getPlayerPatch()).reserveAnimation(this.fail);
                    ((ServerPlayerPatch)event.getPlayerPatch()).getCurrentlyActuallyHitEntities().clear();
                }
            }
        });
    }

    public void onRemoved(SkillContainer container) {
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.ATTACK_ANIMATION_END_EVENT, EVENT_UUID);
    }

    public void executeOnServer(SkillContainer container, FriendlyByteBuf args) {
        container.getExecutor().playAnimationSynchronized(this.first, 0.0f);
        LivingEntity target = container.getExecutor().getTarget();
        ((ServerPlayer)container.getExecutor().getOriginal()).m_7292_(new MobEffectInstance((MobEffect)EpicFightMobEffects.STUN_IMMUNITY.get(), 38, 0, true, false, false));
        if (target != null && target.m_6084_()) {
            target.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 36, 50));
        }
    }

    public List<Component> getTooltipOnItem(ItemStack itemStack, CapabilityItem cap, PlayerPatch<?> playerCap) {
        List list = super.getTooltipOnItem(itemStack, cap, playerCap);
        this.generateTooltipforPhase(list, itemStack, cap, playerCap, (Map)this.properties.get(0), "Charge");
        this.generateTooltipforPhase(list, itemStack, cap, playerCap, (Map)this.properties.get(1), "Stab");
        this.generateTooltipforPhase(list, itemStack, cap, playerCap, (Map)this.properties.get(2), "Kick");
        return list;
    }

    public WeaponInnateSkill registerPropertiesToAnimation() {
        ((AttackAnimation)this.first.get()).phases[0].addProperties(((Map)this.properties.get(0)).entrySet());
        ((AttackAnimation)this.second.get()).phases[0].addProperties(((Map)this.properties.get(1)).entrySet());
        ((AttackAnimation)this.third.get()).phases[0].addProperties(((Map)this.properties.get(2)).entrySet());
        return this;
    }
}

