/*
 * Decompiled with CFR 0.152.
 */
package com.ashenhart.epic_fight_musket_compat.world.capabilities.entitypatch;

import com.ashenhart.epic_fight_musket_compat.gameassets.MusketAnimations;
import com.ashenhart.epic_fight_musket_compat.gameassets.MusketMobCombatBehaviors;
import com.ashenhart.epic_fight_musket_compat.world.capabilities.item.MusketWeaponCategories;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import ewewukek.musketmod.GunItem;
import java.util.Map;
import java.util.Set;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.UseAnim;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.LivingMotion;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.client.animation.Layer;
import yesman.epicfight.world.capabilities.entitypatch.Faction;
import yesman.epicfight.world.capabilities.entitypatch.HumanoidMobPatch;
import yesman.epicfight.world.capabilities.entitypatch.MobPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.capabilities.item.Style;
import yesman.epicfight.world.capabilities.item.WeaponCategory;
import yesman.epicfight.world.entity.ai.goal.AnimatedAttackGoal;
import yesman.epicfight.world.entity.ai.goal.CombatBehaviors;
import yesman.epicfight.world.entity.ai.goal.TargetChasingGoal;

public abstract class MusketHumanoidMobPatch<T extends PathfinderMob>
extends HumanoidMobPatch<T> {
    protected Map<WeaponCategory, Map<Style, Set<Pair<LivingMotion, AnimationManager.AnimationAccessor<? extends StaticAnimation>>>>> weaponLivingMotions;
    protected Map<WeaponCategory, Map<Style, CombatBehaviors.Builder<HumanoidMobPatch<?>>>> weaponAttackMotions;

    public MusketHumanoidMobPatch(Faction faction) {
        super(faction);
        this.setWeaponMotions();
    }

    protected void initAI() {
        super.initAI();
        if (((PathfinderMob)this.original).m_20202_() != null && ((PathfinderMob)this.original).m_20202_() instanceof Mob) {
            this.setAIAsMounted(((PathfinderMob)this.original).m_20202_());
        } else {
            this.setAIAsMusketeer(((PathfinderMob)this.original).m_21205_().m_41720_() instanceof GunItem);
        }
        if (((PathfinderMob)this.original).m_20202_() != null && ((PathfinderMob)this.original).m_20202_() instanceof Mob) {
            this.setAIAsMounted(((PathfinderMob)this.original).m_20202_());
        } else {
            this.setAIAsInfantry(((PathfinderMob)this.original).m_21205_().m_41720_() instanceof ProjectileWeaponItem);
        }
    }

    protected void setWeaponMotions() {
        this.weaponLivingMotions = Maps.newHashMap();
        this.weaponLivingMotions.put(MusketWeaponCategories.MUSKET, (Map<Style, Set<Pair<LivingMotion, AnimationManager.AnimationAccessor<? extends StaticAnimation>>>>)ImmutableMap.of((Object)CapabilityItem.Styles.TWO_HAND, Set.of(Pair.of((Object)LivingMotions.AIM, MusketAnimations.MUSKET_AIM), Pair.of((Object)LivingMotions.SHOT, MusketAnimations.MUSKET_SHOT))));
        this.weaponLivingMotions.put(MusketWeaponCategories.PISTOL, (Map<Style, Set<Pair<LivingMotion, AnimationManager.AnimationAccessor<? extends StaticAnimation>>>>)ImmutableMap.of((Object)CapabilityItem.Styles.ONE_HAND, Set.of(Pair.of((Object)LivingMotions.AIM, MusketAnimations.PISTOL_AIM), Pair.of((Object)LivingMotions.SHOT, MusketAnimations.PISTOL_SHOT))));
        this.weaponLivingMotions.put(MusketWeaponCategories.BAYONET, (Map<Style, Set<Pair<LivingMotion, AnimationManager.AnimationAccessor<? extends StaticAnimation>>>>)ImmutableMap.of((Object)CapabilityItem.Styles.TWO_HAND, Set.of(Pair.of((Object)LivingMotions.AIM, MusketAnimations.MUSKET_AIM), Pair.of((Object)LivingMotions.SHOT, MusketAnimations.MUSKET_SHOT))));
        this.weaponLivingMotions.put(MusketWeaponCategories.SCOPED, (Map<Style, Set<Pair<LivingMotion, AnimationManager.AnimationAccessor<? extends StaticAnimation>>>>)ImmutableMap.of((Object)CapabilityItem.Styles.TWO_HAND, Set.of(Pair.of((Object)LivingMotions.AIM, MusketAnimations.MUSKET_AIM), Pair.of((Object)LivingMotions.SHOT, MusketAnimations.MUSKET_SHOT))));
        this.weaponAttackMotions = Maps.newHashMap();
        this.weaponAttackMotions.put(MusketWeaponCategories.MUSKET, (Map<Style, CombatBehaviors.Builder<HumanoidMobPatch<?>>>)ImmutableMap.of((Object)CapabilityItem.Styles.TWO_HAND, MusketMobCombatBehaviors.HUMANOID_MUSKET));
        this.weaponAttackMotions.put(MusketWeaponCategories.BAYONET, (Map<Style, CombatBehaviors.Builder<HumanoidMobPatch<?>>>)ImmutableMap.of((Object)CapabilityItem.Styles.TWO_HAND, MusketMobCombatBehaviors.HUMANOID_BAYONET));
        this.weaponAttackMotions.put(MusketWeaponCategories.SCOPED, (Map<Style, CombatBehaviors.Builder<HumanoidMobPatch<?>>>)ImmutableMap.of((Object)CapabilityItem.Styles.TWO_HAND, MusketMobCombatBehaviors.HUMANOID_MUSKET));
        this.weaponAttackMotions.put(MusketWeaponCategories.PISTOL, (Map<Style, CombatBehaviors.Builder<HumanoidMobPatch<?>>>)ImmutableMap.of((Object)CapabilityItem.Styles.ONE_HAND, MusketMobCombatBehaviors.HUMANOID_PISTOL));
        this.weaponAttackMotions.put(MusketWeaponCategories.CEREMONIAL_MUSKET, (Map<Style, CombatBehaviors.Builder<HumanoidMobPatch<?>>>)ImmutableMap.of((Object)CapabilityItem.Styles.COMMON, MusketMobCombatBehaviors.HUMANOID_MUSKET));
        this.weaponAttackMotions.put(MusketWeaponCategories.CEREMONIAL_PISTOL, (Map<Style, CombatBehaviors.Builder<HumanoidMobPatch<?>>>)ImmutableMap.of((Object)CapabilityItem.Styles.COMMON, MusketMobCombatBehaviors.HUMANOID_PISTOL));
    }

    public void setAIAsMusketeer(boolean holdingGun) {
        CombatBehaviors.Builder builder = this.getHoldingItemWeaponMotionBuilder();
        if (builder != null) {
            ((PathfinderMob)this.original).f_21345_.m_25352_(0, (Goal)new AnimatedAttackGoal((MobPatch)this, builder.build((MobPatch)this)));
            ((PathfinderMob)this.original).f_21345_.m_25352_(1, (Goal)new TargetChasingGoal((MobPatch)this, (PathfinderMob)this.getOriginal(), 1.0, true));
        }
    }

    protected final void commonAggressiveMusketMobUpdate(boolean considerInaction) {
        this.commonAggressiveRangedMobUpdateMotion(considerInaction);
        UseAnim useAction = ((PathfinderMob)this.original).m_21120_(((PathfinderMob)this.original).m_7655_()).m_41780_();
        this.currentCompositeMotion = ((StaticAnimation)this.getClientAnimator().getCompositeLayer((Layer.Priority)Layer.Priority.MIDDLE).animationPlayer.getRealAnimation().get()).isReboundAnimation() ? LivingMotions.SHOT : (((PathfinderMob)this.original).m_6117_() ? (useAction == UseAnim.CROSSBOW ? LivingMotions.RELOAD : LivingMotions.AIM) : (GunItem.isLoaded((ItemStack)((PathfinderMob)this.original).m_21205_()) ? LivingMotions.AIM : this.currentLivingMotion));
    }
}

