/*
 * Decompiled with CFR 0.152.
 */
package com.ashenhart.epic_fight_musket_compat.world.capabilities.item;

import com.ashenhart.epic_fight_musket_compat.gameassets.MusketAnimations;
import com.ashenhart.epic_fight_musket_compat.gameassets.MusketSkills;
import ewewukek.musketmod.GunItem;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.LivingMotion;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.particle.EpicFightParticles;
import yesman.epicfight.particle.HitParticleType;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.capabilities.item.RangedWeaponCapability;
import yesman.epicfight.world.capabilities.item.Style;

public class BayonetCapability
extends RangedWeaponCapability {
    private List<AnimationManager.AnimationAccessor<? extends AttackAnimation>> attackMotion = List.of(MusketAnimations.MUSKET_AUTO_1, MusketAnimations.MUSKET_AUTO_2, MusketAnimations.BAYONET_AUTO, MusketAnimations.BAYONET_DASH, Animations.SPEAR_TWOHAND_AIR_SLASH);

    protected BayonetCapability(CapabilityItem.Builder builder) {
        super(builder);
    }

    public Style getStyle(LivingEntityPatch<?> entitypatch) {
        return CapabilityItem.Styles.TWO_HAND;
    }

    public SoundEvent getHitSound() {
        return (SoundEvent)EpicFightSounds.BLUNT_HIT.get();
    }

    public HitParticleType getHitParticle() {
        return (HitParticleType)EpicFightParticles.HIT_BLUNT.get();
    }

    public List<AnimationManager.AnimationAccessor<? extends AttackAnimation>> getAutoAttackMotion(PlayerPatch<?> playerpatch) {
        return this.attackMotion;
    }

    public LivingMotion getLivingMotion(LivingEntityPatch<?> entitypatch, InteractionHand hand) {
        return entitypatch.getEntityState().canUseItem() && ((LivingEntity)entitypatch.getOriginal()).m_21205_().m_41720_() instanceof GunItem && GunItem.isLoaded((ItemStack)((LivingEntity)entitypatch.getOriginal()).m_21205_()) ? LivingMotions.AIM : null;
    }

    @Nullable
    public Skill getInnateSkill(PlayerPatch<?> playerPatch, ItemStack itemStack) {
        return MusketSkills.LAST_PUSH;
    }
}

