/*
 * Decompiled with CFR 0.152.
 */
package com.ashenhart.epic_fight_musket_compat.world.capabilities.item;

import com.ashenhart.epic_fight_musket_compat.gameassets.MusketAnimations;
import com.ashenhart.epic_fight_musket_compat.world.capabilities.item.MusketWeaponCategories;
import ewewukek.musketmod.GunItem;
import ewewukek.musketmod.PistolItem;
import java.util.List;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.LivingMotion;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.particle.EpicFightParticles;
import yesman.epicfight.particle.HitParticleType;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.capabilities.item.RangedWeaponCapability;
import yesman.epicfight.world.capabilities.item.Style;

public class PistolCapability
extends RangedWeaponCapability {
    private List<AnimationManager.AnimationAccessor<? extends AttackAnimation>> attackMotion = List.of(MusketAnimations.PISTOL_AUTO_1, MusketAnimations.PISTOL_AUTO_2, MusketAnimations.PISTOL_AUTO_3, MusketAnimations.PISTOL_DASH, Animations.SWORD_AIR_SLASH);

    protected PistolCapability(CapabilityItem.Builder builder) {
        super(builder);
    }

    public Style getStyle(LivingEntityPatch<?> entitypatch) {
        return CapabilityItem.Styles.ONE_HAND;
    }

    public SoundEvent getHitSound() {
        return (SoundEvent)EpicFightSounds.BLUNT_HIT.get();
    }

    public HitParticleType getHitParticle() {
        return (HitParticleType)EpicFightParticles.HIT_BLUNT.get();
    }

    public List<AnimationManager.AnimationAccessor<? extends AttackAnimation>> getAutoAttackMotion(PlayerPatch<?> playerpatch) {
        return this.attackMotion;
    }

    public LivingMotion getLivingMotion(LivingEntityPatch<?> entitypatch, InteractionHand hand) {
        return entitypatch.getEntityState().canUseItem() && ((LivingEntity)entitypatch.getOriginal()).m_21205_().m_41720_() instanceof GunItem && PistolItem.isLoaded((ItemStack)((LivingEntity)entitypatch.getOriginal()).m_21205_()) ? LivingMotions.AIM : null;
    }

    public boolean checkOffhandValid(LivingEntityPatch<?> entityPatch) {
        ItemStack offhandItem = ((LivingEntity)entityPatch.getOriginal()).m_21206_();
        CapabilityItem itemCap = EpicFightCapabilities.getItemStackCapability((ItemStack)offhandItem);
        boolean isPistol = itemCap.getWeaponCategory() == MusketWeaponCategories.PISTOL;
        return isPistol || !(offhandItem.m_41720_() instanceof SwordItem) && !(offhandItem.m_41720_() instanceof DiggerItem);
    }

    public boolean canHoldInOffhandAlone() {
        return true;
    }
}

