/*
 * Decompiled with CFR 0.152.
 */
package com.ashenhart.epic_fight_musket_compat.world.capabilities.provider;

import com.ashenhart.epic_fight_musket_compat.world.capabilities.entitypatch.mob.IllagerGunPatch;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.player.RemotePlayer;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.ModLoader;
import net.minecraftforge.registries.ForgeRegistries;
import yesman.epicfight.api.forgeevent.EntityPatchRegistryEvent;
import yesman.epicfight.client.world.capabilites.entitypatch.player.AbstractClientPlayerPatch;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.EntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.GlobalMobPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.gamerule.EpicFightGameRules;

public class MusketEntityPatchProvider
implements ICapabilityProvider,
NonNullSupplier<EntityPatch<?>> {
    private static final Map<EntityType<?>, Function<Entity, Supplier<EntityPatch<?>>>> CAPABILITIES = Maps.newHashMap();
    private EntityPatch<?> capability;
    private final LazyOptional<EntityPatch<?>> optional = LazyOptional.of((NonNullSupplier)this);

    public static void registerEntityPatches() {
        HashMap registry = Maps.newHashMap();
        registry.put(EntityType.f_20513_, entityIn -> IllagerGunPatch::new);
        EntityPatchRegistryEvent entitypatchRegistryEvent = new EntityPatchRegistryEvent((Map)registry);
        ModLoader.get().postEvent((Event)entitypatchRegistryEvent);
        CAPABILITIES.putAll(registry);
    }

    public static void registerEntityPatchesClient() {
        CAPABILITIES.put(EntityType.f_20532_, entityIn -> {
            if (entityIn instanceof LocalPlayer) {
                return LocalPlayerPatch::new;
            }
            if (entityIn instanceof RemotePlayer) {
                return AbstractClientPlayerPatch::new;
            }
            if (entityIn instanceof ServerPlayer) {
                return ServerPlayerPatch::new;
            }
            return () -> null;
        });
    }

    public static Function<Entity, Supplier<EntityPatch<?>>> get(String registryName) {
        ResourceLocation rl = ResourceLocation.parse((String)registryName);
        EntityType entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(rl);
        return CAPABILITIES.get(entityType);
    }

    public MusketEntityPatchProvider(Entity entity) {
        Function<Entity, Supplier<EntityPatch<?>>> provider = CAPABILITIES.get(entity.m_6095_());
        if (provider != null) {
            try {
                this.capability = provider.apply(entity).get();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (entity instanceof Mob && ((Boolean)EpicFightGameRules.GLOBAL_STUN.getRuleValue(entity.m_9236_())).booleanValue()) {
            this.capability = new GlobalMobPatch();
        }
    }

    public EntityPatch<?> get() {
        return this.capability;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        return cap == EpicFightCapabilities.CAPABILITY_ENTITY ? this.optional.cast() : LazyOptional.empty();
    }
}

