/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.client.input.action;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yesman.epicfight.api.client.input.action.InputAction;
import yesman.epicfight.client.input.EpicFightKeyMappings;

@ApiStatus.Experimental
public enum EpicFightInputActions implements InputAction
{
    VANILLA_ATTACK_DESTROY(true),
    USE(true),
    SWAP_OFF_HAND(true),
    DROP(true),
    TOGGLE_PERSPECTIVE(true),
    ATTACK(false),
    JUMP(true),
    MOBILITY(false),
    GUARD(false),
    DODGE(false),
    LOCK_ON(false),
    SWITCH_MODE(false),
    WEAPON_INNATE_SKILL(false),
    WEAPON_INNATE_SKILL_TOOLTIP(false),
    MOVE_FORWARD(true),
    MOVE_BACKWARD(true),
    MOVE_LEFT(true),
    MOVE_RIGHT(true),
    SPRINT(true),
    SNEAK(true),
    OPEN_SKILL_SCREEN(false),
    OPEN_CONFIG_SCREEN(false),
    SWITCH_VANILLA_MODEL_DEBUGGING(false);

    private final int id = InputAction.ENUM_MANAGER.assign(this);
    private final boolean isVanilla;
    @NotNull
    private static final Map<KeyMapping, EpicFightInputActions> BY_KEY_MAPPING;

    public boolean isVanilla() {
        return this.isVanilla;
    }

    private EpicFightInputActions(boolean isVanilla) {
        this.isVanilla = isVanilla;
    }

    @Override
    public int universalOrdinal() {
        return this.id;
    }

    @Override
    @NotNull
    public KeyMapping keyMapping() {
        Options options = Minecraft.m_91087_().f_91066_;
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case VANILLA_ATTACK_DESTROY -> options.f_92096_;
            case USE -> options.f_92095_;
            case SWAP_OFF_HAND -> options.f_92093_;
            case DROP -> options.f_92094_;
            case TOGGLE_PERSPECTIVE -> options.f_92103_;
            case ATTACK -> EpicFightKeyMappings.ATTACK;
            case JUMP -> options.f_92089_;
            case MOBILITY -> EpicFightKeyMappings.MOVER_SKILL;
            case GUARD -> EpicFightKeyMappings.GUARD;
            case DODGE -> EpicFightKeyMappings.DODGE;
            case LOCK_ON -> EpicFightKeyMappings.LOCK_ON;
            case SWITCH_MODE -> EpicFightKeyMappings.SWITCH_MODE;
            case WEAPON_INNATE_SKILL -> EpicFightKeyMappings.WEAPON_INNATE_SKILL;
            case WEAPON_INNATE_SKILL_TOOLTIP -> EpicFightKeyMappings.WEAPON_INNATE_SKILL_TOOLTIP;
            case MOVE_FORWARD -> options.f_92085_;
            case MOVE_BACKWARD -> options.f_92087_;
            case MOVE_LEFT -> options.f_92086_;
            case MOVE_RIGHT -> options.f_92088_;
            case SPRINT -> options.f_92091_;
            case SNEAK -> options.f_92090_;
            case OPEN_SKILL_SCREEN -> EpicFightKeyMappings.SKILL_EDIT;
            case OPEN_CONFIG_SCREEN -> EpicFightKeyMappings.OPEN_CONFIG_SCREEN;
            case SWITCH_VANILLA_MODEL_DEBUGGING -> EpicFightKeyMappings.SWITCH_VANILLA_MODEL_DEBUGGING;
        };
    }

    @Nullable
    public static EpicFightInputActions fromKeyMapping(@NotNull KeyMapping keyMapping) {
        return BY_KEY_MAPPING.get(keyMapping);
    }

    @NotNull
    public static Set<EpicFightInputActions> nonVanillaActions() {
        EnumSet<EpicFightInputActions> result = EnumSet.noneOf(EpicFightInputActions.class);
        for (EpicFightInputActions action : EpicFightInputActions.values()) {
            if (action.isVanilla()) continue;
            result.add(action);
        }
        return result;
    }

    static {
        HashMap<KeyMapping, EpicFightInputActions> map = new HashMap<KeyMapping, EpicFightInputActions>();
        for (EpicFightInputActions action : EpicFightInputActions.values()) {
            map.put(action.keyMapping(), action);
        }
        BY_KEY_MAPPING = Collections.unmodifiableMap(map);
    }
}

