/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client;

import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.client.events.engine.ControlEngine;
import yesman.epicfight.client.events.engine.RenderEngine;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.main.AuthenticationHelper;
import yesman.epicfight.network.server.SPPlayUISound;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;

@OnlyIn(value=Dist.CLIENT)
public class ClientEngine {
    private static ClientEngine instance = new ClientEngine();
    public Minecraft minecraft;
    public RenderEngine renderEngine;
    public ControlEngine controlEngine;
    private boolean vanillaModelDebuggingMode = false;
    private AuthenticationHelper authenticationHelper = new AuthenticationHelper(){

        @Override
        public boolean valid() {
            return false;
        }
    };

    public static ClientEngine getInstance() {
        return instance;
    }

    public ClientEngine() {
        instance = this;
        this.minecraft = Minecraft.m_91087_();
        this.renderEngine = new RenderEngine();
        this.controlEngine = new ControlEngine();
    }

    public boolean switchVanillaModelDebuggingMode() {
        this.vanillaModelDebuggingMode = !this.vanillaModelDebuggingMode;
        return this.vanillaModelDebuggingMode;
    }

    public boolean isVanillaModelDebuggingMode() {
        return this.vanillaModelDebuggingMode;
    }

    @Nullable
    public LocalPlayerPatch getPlayerPatch() {
        return EpicFightCapabilities.getEntityPatch((Entity)this.minecraft.f_91074_, LocalPlayerPatch.class);
    }

    public void initAuthHelper(AuthenticationHelper authHelper) {
        this.authenticationHelper = authHelper;
    }

    public AuthenticationHelper getAuthHelper() {
        return this.authenticationHelper;
    }

    public void playUISound(SPPlayUISound msg) {
        SimpleSoundInstance soundinstance = SimpleSoundInstance.m_119755_((SoundEvent)msg.sound(), (float)msg.pitch(), (float)msg.volume());
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)soundinstance);
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)soundinstance);
    }

    public boolean isBattleMode() {
        LocalPlayerPatch localPlayerPatch = EpicFightCapabilities.getEntityPatch((Entity)this.minecraft.f_91074_, LocalPlayerPatch.class);
        if (localPlayerPatch == null) {
            return false;
        }
        return localPlayerPatch.isEpicFightMode();
    }

    public static Comparator<ParticleRenderType> makeCustomLowestParticleRenderTypeComparator(List<ParticleRenderType> renderOrder) {
        Comparator<ParticleRenderType> vanillaComparator = Comparator.comparingInt(renderOrder::indexOf);
        return (typeOne, typeTwo) -> {
            boolean vanillaOne = renderOrder.contains(typeOne);
            boolean vanillaTwo = renderOrder.contains(typeTwo);
            if (vanillaOne && vanillaTwo) {
                return vanillaComparator.compare((ParticleRenderType)typeOne, (ParticleRenderType)typeTwo);
            }
            if (!vanillaOne && !vanillaTwo) {
                return Integer.compare(System.identityHashCode(typeOne), System.identityHashCode(typeTwo));
            }
            if (typeOne == ParticleRenderType.f_107433_) {
                return 1;
            }
            if (typeTwo == ParticleRenderType.f_107433_) {
                return -1;
            }
            return vanillaOne ? -1 : 1;
        };
    }
}

