/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.gui.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.mutable.MutableInt;
import yesman.epicfight.api.data.reloader.SkillManager;
import yesman.epicfight.client.gui.screen.SkillBookScreen;
import yesman.epicfight.main.EpicFightMod;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.client.CPChangeSkill;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.world.capabilities.skill.CapabilitySkill;
import yesman.epicfight.world.gamerule.EpicFightGameRules;

@OnlyIn(value=Dist.CLIENT)
public class SkillEditScreen
extends Screen {
    public static final ResourceLocation EMPTY_SKILL_SLOT_ICON = ResourceLocation.fromNamespaceAndPath((String)"epicfight", (String)"textures/gui/empty.png");
    public static final ResourceLocation SCROLL_ARROW_UP = ResourceLocation.fromNamespaceAndPath((String)"epicfight", (String)"textures/gui/scroll_arrow_up.png");
    public static final ResourceLocation SCROLL_ARROW_DOWN = ResourceLocation.fromNamespaceAndPath((String)"epicfight", (String)"textures/gui/scroll_arrow_down.png");
    private static final ResourceLocation SKILL_EDIT_UI = ResourceLocation.fromNamespaceAndPath((String)"epicfight", (String)"textures/gui/screen/skill_edit.png");
    private static final MutableComponent NO_SKILLS = Component.m_237115_((String)EpicFightMod.format("gui.%s.no_skills"));
    private static final int MAX_SKILL_OPTIONS_ROWS = 6;
    private static final int MAX_SLOT_ROWS = 9;
    private static final int STRIDE = 18;
    private final Player player;
    private final CapabilitySkill skills;
    private final Map<SkillSlot, SlotButton> slotButtons = new LinkedHashMap<SkillSlot, SlotButton>();
    private final List<EquipSkillButton> equipSkillButtons = new ArrayList<EquipSkillButton>();
    private ScrollArrow up;
    private ScrollArrow down;
    private SlotButton selectedSlotButton;
    private int start;
    private int maxScroll;
    private int scroll = 0;

    public SkillEditScreen(Player player, CapabilitySkill skills) {
        super((Component)Component.m_237115_((String)EpicFightMod.format("gui.%s.skill_edit")));
        this.player = player;
        this.skills = skills;
    }

    public void m_7856_() {
        this.slotButtons.clear();
        this.equipSkillButtons.clear();
        this.up = null;
        this.down = null;
        this.maxScroll = Math.max(SkillSlot.ENUM_MANAGER.universalValues().stream().filter(skillSlot -> skillSlot.category().learnable()).toList().size() - 9, 0);
        if (this.maxScroll > 0) {
            this.up = new ScrollArrow(this.f_96543_ / 2 - 95, this.f_96544_ / 2 - 114, 16, 16, button -> this.scrollUp(), true);
            this.down = new ScrollArrow(this.f_96543_ / 2 - 95, this.f_96544_ / 2 + 98, 16, 16, button -> this.scrollDown(), false);
            this.m_142416_((GuiEventListener)this.up);
            this.m_142416_((GuiEventListener)this.down);
        }
        int left = this.f_96543_ / 2 - 96;
        int top = this.f_96544_ / 2 - 82;
        for (SkillSlot skillSlot2 : SkillSlot.ENUM_MANAGER.universalValues()) {
            if ((this.player.m_7500_() || !this.skills.getSkillContainersFor(skillSlot2.category()).isEmpty()) && skillSlot2.category().learnable()) {
                SkillContainer skillContainer = this.skills.getSkillContainerFor(skillSlot2);
                SlotButton slotButton = new SlotButton(left, top, skillContainer, button -> {
                    this.start = 0;
                    for (Button button2 : this.equipSkillButtons) {
                        this.m_6702_().remove(button2);
                    }
                    this.equipSkillButtons.clear();
                    int k = this.f_96543_ / 2 - 69;
                    MutableInt mutableInt = new MutableInt(this.f_96544_ / 2 - 78);
                    Stream<Skill> learnedSkill = this.player.m_7500_() ? SkillManager.getSkills(skill -> skill.getCategory() == skillSlot2.category()).stream() : this.skills.listAcquiredSkills().filter(skill -> skill.getCategory() == skillSlot2.category());
                    learnedSkill.forEach(skill -> {
                        this.equipSkillButtons.add(new EquipSkillButton(k, widgetHeight.intValue(), 147, 24, (Skill)skill, (Component)Component.m_237115_((String)skill.getTranslationKey()), replaceSkillButton -> {
                            if (!this.isButtonVisible(replaceSkillButton)) {
                                return;
                            }
                            skillContainer.setSkill((Skill)skill);
                            EpicFightNetworkManager.sendToServer(new CPChangeSkill(skillSlot2, -1, (Skill)skill));
                            this.skills.addLearnedSkill((Skill)skill);
                            this.m_7379_();
                        }).setActive(this.skills.getSkillContainer((Skill)skill) == null));
                        widgetHeight.add(26);
                    });
                    for (Button button3 : this.equipSkillButtons) {
                        this.m_142416_((GuiEventListener)button3);
                    }
                    this.selectedSlotButton = (SlotButton)button;
                }, (Component)Component.m_237115_((String)SkillSlot.ENUM_MANAGER.toTranslated(skillSlot2)));
                this.slotButtons.put(skillSlot2, slotButton);
                this.m_142416_((GuiEventListener)slotButton);
                top += 18;
            }
            this.scroll = 0;
            this.setScrollVisibilities();
        }
        if (this.selectedSlotButton != null) {
            this.selectedSlotButton = this.slotButtons.get(this.selectedSlotButton.skillContainer.getSlot());
            this.selectedSlotButton.m_5691_();
        }
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        if (this.canScroll()) {
            int scrollPosition = (int)(140.0f * ((float)this.start / (float)(this.equipSkillButtons.size() - 6)));
            guiGraphics.m_280411_(SKILL_EDIT_UI, this.f_96543_ / 2 + 80, this.f_96544_ / 2 - 80 + scrollPosition, 12, 15, 231.0f, 2.0f, 12, 15, 256, 256);
        }
        int maxShowingButtons = Math.min(this.equipSkillButtons.size(), 6);
        for (int i = this.start; i < maxShowingButtons + this.start; ++i) {
            this.equipSkillButtons.get(i).m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        }
        for (SlotButton sb : this.slotButtons.values()) {
            sb.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        }
        if (this.up != null) {
            this.up.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        }
        if (this.down != null) {
            this.down.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        }
        if (this.slotButtons.isEmpty()) {
            int lineHeight = 0;
            for (FormattedCharSequence s : this.f_96547_.m_92923_((FormattedText)NO_SKILLS, 140)) {
                guiGraphics.m_280649_(this.f_96547_, s, this.f_96543_ / 2 - 65, this.f_96544_ / 2 - 72 + lineHeight, 0x303030, false);
                lineHeight += 10;
            }
        }
    }

    public void m_280273_(GuiGraphics guiGraphics) {
        super.m_280273_(guiGraphics);
        guiGraphics.m_280218_(SKILL_EDIT_UI, this.f_96543_ / 2 - 104, this.f_96544_ / 2 - 100, 0, 0, 208, 200);
    }

    private boolean canScroll() {
        return this.equipSkillButtons.size() > 6;
    }

    private boolean isButtonVisible(Button button) {
        int buttonOrder = this.equipSkillButtons.indexOf(button);
        return buttonOrder >= this.start && buttonOrder <= this.start + 6;
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        int left = this.f_96543_ / 2 - 96;
        int top = this.f_96544_ / 2 - 82;
        if ((double)left <= mouseX && (double)top <= mouseY && (double)(left + 18) >= mouseX && (double)(top + 162) >= mouseY) {
            if (delta > 0.0) {
                this.scrollUp();
            } else {
                this.scrollDown();
            }
            return true;
        }
        if (!this.canScroll()) {
            return false;
        }
        if (delta > 0.0) {
            if (this.start > 0) {
                --this.start;
                for (Button button : this.equipSkillButtons) {
                    button.m_253211_(button.m_252907_() + 26);
                }
                return true;
            }
        } else if (this.start < this.equipSkillButtons.size() - 6) {
            ++this.start;
            for (Button button : this.equipSkillButtons) {
                button.m_253211_(button.m_252907_() - 26);
            }
            return true;
        }
        return false;
    }

    public boolean m_7043_() {
        return false;
    }

    protected void scrollUp() {
        int nextScroll = Mth.m_14045_((int)(this.scroll - 1), (int)0, (int)this.maxScroll);
        if (this.scroll != nextScroll) {
            this.scroll = nextScroll;
            this.slotButtons.values().forEach(button -> button.m_253211_(button.m_252907_() + 18));
            this.setScrollVisibilities();
        }
    }

    protected void scrollDown() {
        int nextScroll = Mth.m_14045_((int)(this.scroll + 1), (int)0, (int)this.maxScroll);
        if (this.scroll != nextScroll) {
            this.scroll = nextScroll;
            this.slotButtons.values().forEach(button -> button.m_253211_(button.m_252907_() - 18));
            this.setScrollVisibilities();
        }
    }

    protected void setScrollVisibilities() {
        int i = 0;
        for (SlotButton slotButton : this.slotButtons.values()) {
            slotButton.f_93624_ = i >= this.scroll && i < this.scroll + 9;
            ++i;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    class ScrollArrow
    extends Button {
        final boolean up;

        protected ScrollArrow(int x, int y, int width, int height, Button.OnPress onPress, boolean up) {
            super(x, y, width, height, (Component)Component.m_237119_(), onPress, Button.f_252438_);
            this.up = up;
        }

        protected void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            if (this.up && SkillEditScreen.this.scroll != 0) {
                guiGraphics.m_280411_(SCROLL_ARROW_UP, this.m_252754_(), this.m_252907_(), this.f_93618_, this.f_93619_, 0.0f, 0.0f, 16, 16, 16, 16);
            } else if (!this.up && SkillEditScreen.this.scroll != SkillEditScreen.this.maxScroll) {
                guiGraphics.m_280411_(SCROLL_ARROW_DOWN, this.m_252754_(), this.m_252907_(), this.f_93618_, this.f_93619_, 0.0f, 0.0f, 16, 16, 16, 16);
            }
        }

        protected boolean m_93680_(double mouseX, double mouseY) {
            return super.m_93680_(mouseX, mouseY) && (this.up && SkillEditScreen.this.scroll != 0 || !this.up && SkillEditScreen.this.scroll != SkillEditScreen.this.maxScroll);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    class SlotButton
    extends Button {
        private final SkillContainer skillContainer;
        private final Component slotExplanation;

        public SlotButton(int x, int y, SkillContainer skillContainer, Button.OnPress pressedAction, Component tooltipMessage) {
            super(x, y, 18, 18, (Component)Component.m_237119_(), pressedAction, Button.f_252438_);
            this.skillContainer = skillContainer;
            this.slotExplanation = tooltipMessage;
            this.m_257544_(Tooltip.m_257550_((Component)this.slotExplanation));
        }

        protected void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            int y = (this.f_93622_ || SkillEditScreen.this.selectedSlotButton == this) && !this.skillContainer.onReplaceCooldown() ? 35 : 17;
            guiGraphics.m_280218_(SKILL_EDIT_UI, this.m_252754_(), this.m_252907_(), 237, y, this.f_93618_, this.f_93619_);
            if (!this.skillContainer.isEmpty()) {
                RenderSystem.enableBlend();
                guiGraphics.m_280411_(this.skillContainer.getSkill().getSkillTexture(), this.m_252754_() + 1, this.m_252907_() + 1, this.m_5711_() - 2, this.m_93694_() - 2, 0.0f, 0.0f, 128, 128, 128, 128);
                RenderSystem.disableBlend();
            } else {
                guiGraphics.m_280411_(EMPTY_SKILL_SLOT_ICON, this.m_252754_() + 1, this.m_252907_() + 1, this.m_5711_() - 2, this.m_93694_() - 2, 0.0f, 0.0f, 128, 128, 128, 128);
            }
            if (this.skillContainer.onReplaceCooldown()) {
                int maxCooldown = EpicFightGameRules.SKILL_REPLACE_COOLDOWN.getRuleValue(SkillEditScreen.this.player.m_9236_());
                float lerp = Mth.m_144920_((float)0.0f, (float)16.0f, (float)(1.0f - (float)this.skillContainer.getReplaceCooldown() / (float)maxCooldown));
                guiGraphics.m_280509_(this.m_252754_() + 1, this.m_252907_() + 1 + (int)lerp, this.m_252754_() + 17, this.m_252907_() + 17, 0x78000000);
                if (this.f_93622_) {
                    this.m_257544_(Tooltip.m_257550_((Component)Component.m_237110_((String)EpicFightMod.format("gui.%s.container_on_cooldown"), (Object[])new Object[]{this.skillContainer.getReplaceCooldown() / 20})));
                }
            } else {
                this.m_257544_(Tooltip.m_257550_((Component)this.slotExplanation));
            }
        }

        protected boolean m_93680_(double mouseX, double mouseY) {
            return super.m_93680_(mouseX, mouseY) && !this.skillContainer.onReplaceCooldown();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    class EquipSkillButton
    extends Button {
        private final Skill skill;

        public EquipSkillButton(int x, int y, int width, int height, Skill skill, Component title, Button.OnPress pressedAction) {
            super(x, y, width, height, title, pressedAction, Button.f_252438_);
            this.skill = skill;
        }

        public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            this.f_93622_ = mouseX >= this.m_252754_() && mouseY >= this.m_252907_() && mouseX < this.m_252754_() + this.f_93618_ && mouseY < this.m_252907_() + this.f_93619_;
            int texY = this.f_93622_ || !this.f_93623_ ? 224 : 200;
            guiGraphics.m_280218_(SKILL_EDIT_UI, this.m_252754_(), this.m_252907_(), 0, texY, this.f_93618_, this.f_93619_);
            RenderSystem.enableBlend();
            guiGraphics.m_280411_(this.skill.getSkillTexture(), this.m_252754_() + 5, this.m_252907_() + 4, 16, 16, 0.0f, 0.0f, 128, 128, 128, 128);
            guiGraphics.m_280614_(SkillEditScreen.this.f_96547_, this.m_6035_(), this.m_252754_() + 26, this.m_252907_() + 2, -1, false);
            if (!this.f_93623_) {
                guiGraphics.m_280614_(SkillEditScreen.this.f_96547_, (Component)Component.m_237113_((String)SkillEditScreen.this.skills.getSkillContainer(this.skill).getSlot().toString().toLowerCase(Locale.ROOT)), this.m_252754_() + 26, this.m_252907_() + 12, 0xFF6060, false);
            }
        }

        public boolean m_6375_(double x, double y, int pressType) {
            boolean flag;
            if (this.f_93624_ && pressType == 1 && (flag = this.clickedNoCountActive(x, y))) {
                this.m_7435_(Minecraft.m_91087_().m_91106_());
                SkillEditScreen.this.f_96541_.m_91152_((Screen)new SkillBookScreen(SkillEditScreen.this.player, this.skill, null, SkillEditScreen.this));
                return true;
            }
            return super.m_6375_(x, y, pressType);
        }

        protected boolean clickedNoCountActive(double x, double y) {
            return this.f_93624_ && x >= (double)this.m_252754_() && y >= (double)this.m_252907_() && x < (double)(this.m_252754_() + this.f_93618_) && y < (double)(this.m_252907_() + this.f_93619_);
        }

        public EquipSkillButton setActive(boolean active) {
            this.f_93623_ = active;
            return this;
        }
    }
}

