/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.renderer.shader.compute.backend.buffers;

import java.io.Closeable;
import java.nio.FloatBuffer;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL15C;
import org.lwjgl.opengl.GL30C;
import yesman.epicfight.client.renderer.shader.compute.backend.buffers.DynamicSSBO;

@OnlyIn(value=Dist.CLIENT)
public class StaticSSBO<T>
implements Closeable {
    public final int glSSBO;
    private int lastBinding = -1;

    public StaticSSBO(List<T> data, int dataSize, @NotNull BiConsumer<T, FloatBuffer> uploader) {
        FloatBuffer buffer = BufferUtils.createFloatBuffer((int)(data.size() * dataSize));
        for (T d : data) {
            uploader.accept(d, buffer);
        }
        buffer.flip();
        this.glSSBO = GL15C.glGenBuffers();
        GL15C.glBindBuffer((int)37074, (int)this.glSSBO);
        GL15C.glBufferData((int)37074, (FloatBuffer)buffer, (int)DynamicSSBO.DataMode.STATIC.glMode);
    }

    public void bindBufferBase(int binding) {
        this.unbind();
        this.lastBinding = binding;
        GL30C.glBindBufferBase((int)37074, (int)binding, (int)this.glSSBO);
    }

    public void unbind() {
        if (this.lastBinding >= 0) {
            GL30C.glBindBufferBase((int)37074, (int)this.lastBinding, (int)0);
        }
    }

    @Override
    public void close() {
        if (this.glSSBO != 0) {
            GL15C.glDeleteBuffers((int)this.glSSBO);
        }
    }
}

