/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.world.capabilites.entitypatch.player;

import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PlayerRideableJumping;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.Event;
import org.joml.Vector4f;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.JointTransform;
import yesman.epicfight.api.animation.LivingMotion;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.Pose;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.animation.types.ActionAnimation;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.client.animation.ClientAnimator;
import yesman.epicfight.api.client.animation.Layer;
import yesman.epicfight.api.client.forgeevent.RenderEpicFightPlayerEvent;
import yesman.epicfight.api.client.forgeevent.UpdatePlayerMotionEvent;
import yesman.epicfight.api.client.online.EpicSkins;
import yesman.epicfight.api.client.physics.cloth.ClothSimulatable;
import yesman.epicfight.api.client.physics.cloth.ClothSimulator;
import yesman.epicfight.api.physics.PhysicsSimulator;
import yesman.epicfight.api.physics.SimulationTypes;
import yesman.epicfight.api.utils.EntitySnapshot;
import yesman.epicfight.api.utils.math.MathUtils;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.config.ClientConfig;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.network.EntityPairingPacketTypes;
import yesman.epicfight.network.server.SPEntityPairingPacket;
import yesman.epicfight.particle.EpicFightParticles;
import yesman.epicfight.world.capabilities.entitypatch.EntityDecorations;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

@OnlyIn(value=Dist.CLIENT)
public class AbstractClientPlayerPatch<T extends AbstractClientPlayer>
extends PlayerPatch<T>
implements ClothSimulatable {
    private Item prevHeldItem;
    private Item prevHeldItemOffHand;
    protected EpicSkins epicSkinsInformation;
    private final ClothSimulator clothSimulator = new ClothSimulator();
    public float modelYRotO2;
    public double xPosO2;
    public double yPosO2;
    public double zPosO2;
    public double xCloakO2;
    public double yCloakO2;
    public double zCloakO2;

    @Override
    public void onJoinWorld(T entity, EntityJoinLevelEvent event) {
        super.onJoinWorld(entity, event);
        this.prevHeldItem = Items.f_41852_;
        this.prevHeldItemOffHand = Items.f_41852_;
        EpicSkins.initEpicSkins(this);
    }

    @Override
    public void updateMotion(boolean considerInaction) {
        if (((AbstractClientPlayer)this.original).m_21223_() <= 0.0f) {
            this.currentLivingMotion = LivingMotions.DEATH;
        } else if (!this.state.updateLivingMotion() && considerInaction) {
            this.currentLivingMotion = LivingMotions.INACTION;
        } else if (((AbstractClientPlayer)this.original).m_21255_() || ((AbstractClientPlayer)this.original).m_21209_()) {
            this.currentLivingMotion = LivingMotions.FLY;
        } else if (((AbstractClientPlayer)this.original).m_20202_() != null) {
            this.currentLivingMotion = ((AbstractClientPlayer)this.original).m_20202_() instanceof PlayerRideableJumping ? LivingMotions.MOUNT : LivingMotions.SIT;
        } else if (((AbstractClientPlayer)this.original).m_6067_()) {
            this.currentLivingMotion = LivingMotions.SWIM;
        } else if (((AbstractClientPlayer)this.original).m_5803_()) {
            this.currentLivingMotion = LivingMotions.SLEEP;
        } else if (!((AbstractClientPlayer)this.original).m_20096_() && ((AbstractClientPlayer)this.original).m_6147_()) {
            this.currentLivingMotion = LivingMotions.CLIMB;
        } else if (!((AbstractClientPlayer)this.original).m_150110_().f_35935_) {
            ClientAnimator animator = this.getClientAnimator();
            if (((AbstractClientPlayer)this.original).m_5842_() && ((AbstractClientPlayer)this.original).m_20186_() - this.yo < -0.005) {
                this.currentLivingMotion = LivingMotions.FLOAT;
            } else if (((AbstractClientPlayer)this.original).m_20186_() - this.yo < (double)-0.4f || this.isAirborneState()) {
                this.currentLivingMotion = LivingMotions.FALL;
            } else if (this.isMoving()) {
                this.currentLivingMotion = ((AbstractClientPlayer)this.original).m_6047_() ? LivingMotions.SNEAK : (((AbstractClientPlayer)this.original).m_20142_() ? LivingMotions.RUN : LivingMotions.WALK);
                animator.baseLayer.animationPlayer.setReversed(this.dz < 0.0);
            } else {
                animator.baseLayer.animationPlayer.setReversed(false);
                this.currentLivingMotion = ((AbstractClientPlayer)this.original).m_6047_() ? LivingMotions.KNEEL : LivingMotions.IDLE;
            }
        } else {
            this.currentLivingMotion = this.isMoving() ? LivingMotions.CREATIVE_FLY : LivingMotions.CREATIVE_IDLE;
        }
        UpdatePlayerMotionEvent.BaseLayer baseLayerEvent = new UpdatePlayerMotionEvent.BaseLayer(this, this.currentLivingMotion, !this.state.updateLivingMotion() && considerInaction);
        this.eventListeners.triggerEvents(PlayerEventListener.EventType.UPDATE_BASE_LIVING_MOTION_EVENT, baseLayerEvent);
        MinecraftForge.EVENT_BUS.post((Event)baseLayerEvent);
        this.currentLivingMotion = baseLayerEvent.getMotion();
        if (!this.state.updateLivingMotion() && considerInaction) {
            this.currentCompositeMotion = LivingMotions.NONE;
        } else {
            UseAnim useAnim;
            CapabilityItem mainhandItemCap = this.getHoldingItemCapability(InteractionHand.MAIN_HAND);
            CapabilityItem offhandItemCap = this.getHoldingItemCapability(InteractionHand.OFF_HAND);
            LivingMotion customLivingMotion = mainhandItemCap.getLivingMotion(this, InteractionHand.MAIN_HAND);
            if (customLivingMotion == null) {
                customLivingMotion = offhandItemCap.getLivingMotion(this, InteractionHand.OFF_HAND);
            }
            this.currentCompositeMotion = customLivingMotion != null ? customLivingMotion : (((AbstractClientPlayer)this.original).m_6117_() ? ((useAnim = ((AbstractClientPlayer)this.original).m_21211_().m_41780_()) == UseAnim.BLOCK ? LivingMotions.BLOCK_SHIELD : (useAnim == UseAnim.CROSSBOW ? LivingMotions.RELOAD : (useAnim == UseAnim.DRINK ? LivingMotions.DRINK : (useAnim == UseAnim.EAT ? LivingMotions.EAT : (useAnim == UseAnim.SPYGLASS ? LivingMotions.SPECTATE : this.currentLivingMotion))))) : (this.getClientAnimator().getCompositeLayer((Layer.Priority)Layer.Priority.MIDDLE).animationPlayer.getRealAnimation().get().isReboundAnimation() ? LivingMotions.SHOT : (((AbstractClientPlayer)this.original).f_20911_ && ((AbstractClientPlayer)this.original).m_21257_().isEmpty() ? LivingMotions.DIGGING : this.currentLivingMotion)));
            UpdatePlayerMotionEvent.CompositeLayer compositeLayerEvent = new UpdatePlayerMotionEvent.CompositeLayer(this, this.currentCompositeMotion);
            this.eventListeners.triggerEvents(PlayerEventListener.EventType.UPDATE_COMPOSITE_LIVING_MOTION_EVENT, compositeLayerEvent);
            MinecraftForge.EVENT_BUS.post((Event)compositeLayerEvent);
            this.currentCompositeMotion = compositeLayerEvent.getMotion();
        }
    }

    @Override
    public void onOldPosUpdate() {
        this.modelYRotO2 = this.modelYRotO;
        this.xPosO2 = (float)((AbstractClientPlayer)this.original).f_19790_;
        this.yPosO2 = (float)((AbstractClientPlayer)this.original).f_19791_;
        this.zPosO2 = (float)((AbstractClientPlayer)this.original).f_19792_;
    }

    @Override
    protected void clientTick(LivingEvent.LivingTickEvent event) {
        boolean isOffHandChanged;
        this.xCloakO2 = ((AbstractClientPlayer)this.original).f_36102_;
        this.yCloakO2 = ((AbstractClientPlayer)this.original).f_36103_;
        this.zCloakO2 = ((AbstractClientPlayer)this.original).f_36104_;
        super.clientTick(event);
        if (!this.getEntityState().updateLivingMotion()) {
            ((AbstractClientPlayer)this.original).f_20883_ = ((AbstractClientPlayer)this.original).m_146908_();
        }
        boolean isMainHandChanged = this.prevHeldItem != ((AbstractClientPlayer)this.original).m_150109_().m_36056_().m_41720_();
        boolean bl = isOffHandChanged = this.prevHeldItemOffHand != ((ItemStack)((AbstractClientPlayer)this.original).m_150109_().f_35976_.get(0)).m_41720_();
        if (isMainHandChanged || isOffHandChanged) {
            this.updateHeldItem(this.getHoldingItemCapability(InteractionHand.MAIN_HAND), this.getHoldingItemCapability(InteractionHand.OFF_HAND));
            if (isMainHandChanged) {
                this.prevHeldItem = ((AbstractClientPlayer)this.original).m_150109_().m_36056_().m_41720_();
            }
            if (isOffHandChanged) {
                this.prevHeldItemOffHand = ((ItemStack)((AbstractClientPlayer)this.original).m_150109_().f_35976_.get(0)).m_41720_();
            }
        }
        if (((AbstractClientPlayer)this.original).f_20919_ == 1) {
            this.getClientAnimator().playDeathAnimation();
        }
        this.clothSimulator.tick(this);
    }

    protected boolean isMoving() {
        return Math.abs(this.dx) > (double)0.01f || Math.abs(this.dz) > (double)0.01f;
    }

    public void updateHeldItem(CapabilityItem mainHandCap, CapabilityItem offHandCap) {
        this.cancelItemUse();
        this.getClientAnimator().iterAllLayers(layer -> {
            if (layer.isOff()) {
                return;
            }
            layer.animationPlayer.getRealAnimation().get().getProperty(AnimationProperty.StaticAnimationProperty.ON_ITEM_CHANGE_EVENT).ifPresent(event -> {
                event.params(mainHandCap, offHandCap);
                event.execute(this, layer.animationPlayer.getRealAnimation(), layer.animationPlayer.getPrevElapsedTime(), layer.animationPlayer.getElapsedTime());
            });
        });
    }

    @Override
    public void entityPairing(SPEntityPairingPacket packet) {
        super.entityPairing(packet);
        if (packet.getPairingPacketType().is(EntityPairingPacketTypes.class)) {
            switch (packet.getPairingPacketType().toEnum(EntityPairingPacketTypes.class)) {
                case TECHNICIAN_ACTIVATED: {
                    ((AbstractClientPlayer)this.original).m_9236_().m_7106_((ParticleOptions)EpicFightParticles.WHITE_AFTERIMAGE.get(), ((AbstractClientPlayer)this.original).m_20185_(), ((AbstractClientPlayer)this.original).m_20186_(), ((AbstractClientPlayer)this.original).m_20189_(), Double.longBitsToDouble(((AbstractClientPlayer)this.original).m_19879_()), 0.0, 0.0);
                    break;
                }
                case ADRENALINE_ACTIVATED: {
                    if (((AbstractClientPlayer)this.original).m_7578_()) {
                        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)((SoundEvent)EpicFightSounds.ADRENALINE.get()), (float)1.0f, (float)1.0f));
                    } else {
                        ((AbstractClientPlayer)this.original).m_216990_((SoundEvent)EpicFightSounds.ADRENALINE.get());
                    }
                    ((AbstractClientPlayer)this.original).m_9236_().m_7106_((ParticleOptions)EpicFightParticles.ADRENALINE_PLAYER_BEATING.get(), ((AbstractClientPlayer)this.original).m_20185_(), ((AbstractClientPlayer)this.original).m_20186_(), ((AbstractClientPlayer)this.original).m_20189_(), Double.longBitsToDouble(((AbstractClientPlayer)this.original).m_19879_()), 0.0, 0.0);
                    break;
                }
                case EMERGENCY_ESCAPE_ACTIVATED: {
                    float yRot = packet.getBuffer().readFloat();
                    ((AbstractClientPlayer)this.original).m_9236_().m_7106_((ParticleOptions)EpicFightParticles.AIR_BURST.get(), ((AbstractClientPlayer)this.original).m_20185_(), ((AbstractClientPlayer)this.original).m_20186_() + (double)(((AbstractClientPlayer)this.original).m_20206_() * 0.5f), ((AbstractClientPlayer)this.original).m_20189_(), 90.0, (double)yRot, 0.0);
                    this.entityDecorations.addColorModifier(EntityDecorations.EMERGENCY_ESCAPE_TRANSPARENCY_MODIFIER, new EntityDecorations.RenderAttributeModifier<Vector4f>(){
                        private int tickCount;

                        @Override
                        public void modifyValue(Vector4f val, float partialTick) {
                            val.w = (float)Math.pow((double)((float)this.tickCount + partialTick) / 6.0, 2.0) - 0.4f;
                        }

                        @Override
                        public boolean shouldRemove() {
                            return this.tickCount > 6;
                        }

                        @Override
                        public void tick() {
                            ++this.tickCount;
                        }
                    });
                }
            }
        }
    }

    @Override
    public boolean overrideRender() {
        RenderEpicFightPlayerEvent renderepicfightplayerevent = new RenderEpicFightPlayerEvent(this, !ClientConfig.enableOriginalModel || this.isEpicFightMode());
        MinecraftForge.EVENT_BUS.post((Event)renderepicfightplayerevent);
        return renderepicfightplayerevent.getShouldRender();
    }

    @Override
    public boolean shouldMoveOnCurrentSide(ActionAnimation actionAnimation) {
        return false;
    }

    @Override
    public void poseTick(DynamicAnimation animation, Pose pose, float elapsedTime, float partialTick) {
        if (pose.hasTransform("Head") && this.armature.hasJoint("Head") && animation.doesHeadRotFollowEntityHead()) {
            float headRotO = this.modelYRotO - ((AbstractClientPlayer)this.original).f_20886_;
            float headRot = this.modelYRot - ((AbstractClientPlayer)this.original).f_20885_;
            float partialHeadRot = Mth.m_14177_((float)MathUtils.lerpBetween(headRotO, headRot, partialTick));
            float xRot = -((AbstractClientPlayer)this.original).m_146909_();
            partialHeadRot = Mth.m_14036_((float)partialHeadRot, (float)-90.0f, (float)90.0f);
            OpenMatrix4f toOriginalRotation = this.armature.getBoundTransformFor(pose, this.armature.searchJointByName("Head")).removeScale().removeTranslation().invert();
            Vec3f xAxis = OpenMatrix4f.transform3v(toOriginalRotation, Vec3f.X_AXIS, null);
            Vec3f yAxis = OpenMatrix4f.transform3v(toOriginalRotation, Vec3f.Y_AXIS, null);
            OpenMatrix4f headRotation = OpenMatrix4f.createRotatorDeg(partialHeadRot, yAxis).rotateDeg(xRot, xAxis);
            pose.orElseEmpty("Head").frontResult(JointTransform.fromMatrix(headRotation), OpenMatrix4f::mul);
        }
    }

    @Override
    public OpenMatrix4f getModelMatrix(float partialTick) {
        float yRot;
        float yRotO;
        if (((AbstractClientPlayer)this.original).m_21209_()) {
            OpenMatrix4f mat = MathUtils.getModelMatrixIntegral(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, partialTick, 0.9375f, 0.9375f, 0.9375f);
            float yRot2 = MathUtils.lerpBetween(((AbstractClientPlayer)this.original).f_19859_, ((AbstractClientPlayer)this.original).m_146908_(), partialTick);
            float xRot = MathUtils.lerpBetween(((AbstractClientPlayer)this.original).f_19860_, ((AbstractClientPlayer)this.original).m_146909_(), partialTick);
            mat.rotateDeg(-yRot2, Vec3f.Y_AXIS).rotateDeg(-xRot, Vec3f.X_AXIS).rotateDeg(((float)((AbstractClientPlayer)this.original).f_19797_ + partialTick) * -55.0f, Vec3f.Z_AXIS).translate(0.0f, -0.39f, 0.0f);
            return mat;
        }
        if (((AbstractClientPlayer)this.original).m_21255_()) {
            OpenMatrix4f mat = MathUtils.getModelMatrixIntegral(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, partialTick, 0.9375f, 0.9375f, 0.9375f);
            float f1 = (float)((AbstractClientPlayer)this.original).m_21256_() + partialTick;
            float f2 = Mth.m_14036_((float)(f1 * f1 / 100.0f), (float)0.0f, (float)1.0f);
            mat.rotateDeg(-Mth.m_14189_((float)partialTick, (float)((AbstractClientPlayer)this.original).f_20884_, (float)((AbstractClientPlayer)this.original).f_20883_), Vec3f.Y_AXIS).rotateDeg(f2 * -((AbstractClientPlayer)this.original).m_146909_(), Vec3f.X_AXIS);
            Vec3 vec3d = ((AbstractClientPlayer)this.original).m_20252_(partialTick);
            Vec3 vec3d1 = ((AbstractClientPlayer)this.original).m_272267_(partialTick);
            double d0 = vec3d1.m_165925_();
            double d1 = vec3d.m_165925_();
            if (d0 > 0.0 && d1 > 0.0) {
                double d2 = (vec3d1.f_82479_ * vec3d.f_82479_ + vec3d1.f_82481_ * vec3d.f_82481_) / (Math.sqrt(d0) * Math.sqrt(d1));
                double d3 = vec3d1.f_82479_ * vec3d.f_82481_ - vec3d1.f_82481_ * vec3d.f_82479_;
                mat.rotate((float)(-(Math.signum(d3) * Math.acos(d2))), Vec3f.Z_AXIS);
            }
            return mat;
        }
        if (((AbstractClientPlayer)this.original).m_5803_()) {
            BlockState blockstate = ((AbstractClientPlayer)this.original).m_146900_();
            float yRot3 = 0.0f;
            if (blockstate.isBed((BlockGetter)((AbstractClientPlayer)this.original).m_9236_(), (BlockPos)((AbstractClientPlayer)this.original).m_21257_().orElse(null), (LivingEntity)this.original) && blockstate.m_61138_((Property)BlockStateProperties.f_61374_)) {
                switch ((Direction)blockstate.m_61143_((Property)BlockStateProperties.f_61374_)) {
                    case EAST: {
                        yRot3 = 90.0f;
                        break;
                    }
                    case WEST: {
                        yRot3 = -90.0f;
                        break;
                    }
                    case SOUTH: {
                        yRot3 = 180.0f;
                        break;
                    }
                }
            }
            return MathUtils.getModelMatrixIntegral(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, yRot3, yRot3, 0.0f, 0.9375f, 0.9375f, 0.9375f);
        }
        float xRotO = 0.0f;
        float xRot = 0.0f;
        Entity d0 = ((AbstractClientPlayer)this.original).m_20202_();
        if (d0 instanceof LivingEntity) {
            LivingEntity ridingEntity = (LivingEntity)d0;
            yRotO = ridingEntity.f_20884_;
            yRot = ridingEntity.f_20883_;
        } else {
            yRotO = this.modelYRotO;
            yRot = this.modelYRot;
        }
        if (!this.getEntityState().inaction() && ((AbstractClientPlayer)this.original).m_20089_() == net.minecraft.world.entity.Pose.SWIMMING) {
            float f4;
            float f = ((AbstractClientPlayer)this.original).m_20998_(partialTick);
            float f3 = ((AbstractClientPlayer)this.original).m_20069_() ? ((AbstractClientPlayer)this.original).m_146909_() : 0.0f;
            xRotO = f4 = Mth.m_14179_((float)f, (float)0.0f, (float)f3);
            xRot = f4;
        }
        return MathUtils.getModelMatrixIntegral(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, xRotO, xRot, yRotO, yRot, partialTick, 0.9375f, 0.9375f, 0.9375f);
    }

    public void setEpicSkinsInformation(EpicSkins epicSkinsInformation) {
        this.epicSkinsInformation = epicSkinsInformation;
    }

    public EpicSkins getEpicSkinsInformation() {
        return this.epicSkinsInformation;
    }

    public boolean isEpicSkinsLoaded() {
        return this.epicSkinsInformation != null;
    }

    @Override
    public EntitySnapshot<?> captureEntitySnapshot() {
        return EntitySnapshot.capturePlayer(this);
    }

    @Override
    public <SIM extends PhysicsSimulator<?, ?, ?, ?, ?>> Optional<SIM> getSimulator(SimulationTypes<?, ?, ?, ?, ?, SIM> simulationType) {
        if (simulationType == SimulationTypes.CLOTH) {
            return Optional.of(this.clothSimulator);
        }
        return Optional.empty();
    }

    @Override
    public ClothSimulator getClothSimulator() {
        return this.clothSimulator;
    }

    @Override
    public Vec3 getAccurateCloakLocation(float partialFrame) {
        if (partialFrame < 0.0f) {
            partialFrame = 1.0f - partialFrame;
            double x = Mth.m_14139_((double)partialFrame, (double)this.xCloakO2, (double)((AbstractClientPlayer)this.original).f_36102_) - Mth.m_14139_((double)partialFrame, (double)this.xPosO2, (double)((AbstractClientPlayer)this.original).f_19854_);
            double y = Mth.m_14139_((double)partialFrame, (double)this.yCloakO2, (double)((AbstractClientPlayer)this.original).f_36103_) - Mth.m_14139_((double)partialFrame, (double)this.yPosO2, (double)((AbstractClientPlayer)this.original).f_19855_);
            double z = Mth.m_14139_((double)partialFrame, (double)this.zCloakO2, (double)((AbstractClientPlayer)this.original).f_36104_) - Mth.m_14139_((double)partialFrame, (double)this.zPosO2, (double)((AbstractClientPlayer)this.original).f_19856_);
            return new Vec3(x, y, z);
        }
        double x = Mth.m_14139_((double)partialFrame, (double)((AbstractClientPlayer)this.original).f_36102_, (double)((AbstractClientPlayer)this.original).f_36105_) - Mth.m_14139_((double)partialFrame, (double)((AbstractClientPlayer)this.original).f_19854_, (double)((AbstractClientPlayer)this.original).m_20185_());
        double y = Mth.m_14139_((double)partialFrame, (double)((AbstractClientPlayer)this.original).f_36103_, (double)((AbstractClientPlayer)this.original).f_36106_) - Mth.m_14139_((double)partialFrame, (double)((AbstractClientPlayer)this.original).f_19855_, (double)((AbstractClientPlayer)this.original).m_20186_());
        double z = Mth.m_14139_((double)partialFrame, (double)((AbstractClientPlayer)this.original).f_36104_, (double)((AbstractClientPlayer)this.original).f_36075_) - Mth.m_14139_((double)partialFrame, (double)((AbstractClientPlayer)this.original).f_19856_, (double)((AbstractClientPlayer)this.original).m_20189_());
        return new Vec3(x, y, z);
    }

    @Override
    public Vec3 getAccuratePartialLocation(float partialFrame) {
        if (partialFrame < 0.0f) {
            partialFrame = 1.0f + partialFrame;
            double x = Mth.m_14139_((double)partialFrame, (double)this.xPosO2, (double)((AbstractClientPlayer)this.original).f_19790_);
            double y = Mth.m_14139_((double)partialFrame, (double)this.yPosO2, (double)((AbstractClientPlayer)this.original).f_19791_);
            double z = Mth.m_14139_((double)partialFrame, (double)this.zPosO2, (double)((AbstractClientPlayer)this.original).f_19792_);
            return new Vec3(x, y, z);
        }
        double x = Mth.m_14139_((double)partialFrame, (double)((AbstractClientPlayer)this.original).f_19790_, (double)((AbstractClientPlayer)this.original).m_20185_());
        double y = Mth.m_14139_((double)partialFrame, (double)((AbstractClientPlayer)this.original).f_19791_, (double)((AbstractClientPlayer)this.original).m_20186_());
        double z = Mth.m_14139_((double)partialFrame, (double)((AbstractClientPlayer)this.original).f_19792_, (double)((AbstractClientPlayer)this.original).m_20189_());
        return new Vec3(x, y, z);
    }

    @Override
    public Vec3 getObjectVelocity() {
        return new Vec3(((AbstractClientPlayer)this.original).m_20185_() - ((AbstractClientPlayer)this.original).f_19790_, ((AbstractClientPlayer)this.original).m_20186_() - ((AbstractClientPlayer)this.original).f_19791_, ((AbstractClientPlayer)this.original).m_20189_() - ((AbstractClientPlayer)this.original).f_19792_);
    }

    @Override
    public float getAccurateYRot(float partialFrame) {
        if (partialFrame < 0.0f) {
            partialFrame = 1.0f + partialFrame;
            return Mth.m_14189_((float)partialFrame, (float)this.modelYRotO2, (float)this.getYRotO());
        }
        return Mth.m_14189_((float)partialFrame, (float)this.getYRotO(), (float)this.getYRot());
    }

    @Override
    public float getYRotDelta(float partialFrame) {
        if (partialFrame < 0.0f) {
            partialFrame = 1.0f + partialFrame;
            return Mth.m_14189_((float)partialFrame, (float)this.modelYRotO2, (float)this.getYRotO()) - this.modelYRotO2;
        }
        return Mth.m_14189_((float)partialFrame, (float)this.getYRotO(), (float)this.getYRot()) - this.getYRotO();
    }

    @Override
    public boolean invalid() {
        return ((AbstractClientPlayer)this.original).m_213877_();
    }

    @Override
    public float getScale() {
        return 0.9375f;
    }

    @Override
    public Animator getSimulatableAnimator() {
        return this.animator;
    }

    @Override
    public float getGravity() {
        return ((AbstractClientPlayer)this.getOriginal()).m_5842_() ? 0.98f : 9.8f;
    }
}

