/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.config;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.compress.utils.Lists;
import yesman.epicfight.api.client.online.EpicFightServerConnectionHelper;
import yesman.epicfight.api.utils.CirculatableEnum;
import yesman.epicfight.api.utils.ParseUtil;
import yesman.epicfight.api.utils.math.Vec2i;
import yesman.epicfight.client.ClientEngine;
import yesman.epicfight.client.gui.ScreenCalculations;
import yesman.epicfight.client.gui.screen.config.ItemsPreferenceScreen;
import yesman.epicfight.client.gui.widgets.ColorSlider;
import yesman.epicfight.main.AuthenticationHelper;
import yesman.epicfight.main.EpicFightMod;

@Mod.EventBusSubscriber(modid="epicfight", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
@OnlyIn(value=Dist.CLIENT)
public class ClientConfig {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec.BooleanValue SHOW_TARGET_INDICATOR = BUILDER.define("ingame.show_target_indicator", () -> true);
    public static final ForgeConfigSpec.EnumValue<HealthBarVisibility> HEALTH_BAR_VISIBILITY = BUILDER.defineEnum("ingame.health_bar_show_option", (Enum)HealthBarVisibility.HURT);
    public static final ForgeConfigSpec.IntValue MAX_STUCK_PROJECTILES = BUILDER.defineInRange("ingame.max_hit_projectiles", 30, 0, 30);
    public static final ForgeConfigSpec.DoubleValue AIM_HELPER_COLOR = BUILDER.defineInRange("ingame.laser_pointer_color", 0.328125, 0.0, 1.0);
    public static final ForgeConfigSpec.BooleanValue ENABLE_AIM_HELPER = BUILDER.define("ingame.enable_laser_pointer", () -> true);
    public static final ForgeConfigSpec.BooleanValue BLOOD_EFFECTS = BUILDER.define("ingame.blood_effects", () -> true);
    public static final ForgeConfigSpec.BooleanValue AIMING_POV_CORRECTION = BUILDER.define("ingame.aiming_correction", () -> true);
    public static final ForgeConfigSpec.BooleanValue SHOW_EPICFIGHT_ATTRIBUTES_IN_TOOLTIP = BUILDER.define("ingame.show_epicfight_attributes", () -> true);
    public static final ForgeConfigSpec.BooleanValue ACTIVATE_COMPUTE_SHADER = BUILDER.define("ingame.use_compute_shader", () -> false);
    public static final ForgeConfigSpec.BooleanValue ENABLE_ANIMATED_FIRST_PERSON_MODEL = BUILDER.define("ingame.first_person_model", () -> true);
    public static final ForgeConfigSpec.EnumValue<BlockGuideOptions> MINE_BLOCK_GUIDE_OPTION = BUILDER.defineEnum("ingame.mine_block_guide_option", (Enum)BlockGuideOptions.CROSSHAIR);
    public static final ForgeConfigSpec.BooleanValue ENABLE_TARGET_ENTITY_GUIDE = BUILDER.define("ingame.enable_target_entity_guide", () -> true);
    public static final ForgeConfigSpec.BooleanValue ENABLE_POV_ACTION = BUILDER.define("ingame.enable_pov_action", () -> true);
    public static final ForgeConfigSpec.BooleanValue ENABLE_COSMETICS = BUILDER.define("ingame.enable_cosmetics", () -> true);
    public static final ForgeConfigSpec.BooleanValue ENABLE_PLAYER_VANILLA_MODEL = BUILDER.define("ingame.enable_player_vanilla_model", () -> true);
    public static final ForgeConfigSpec.IntValue LONG_PRESS_COUNTER = BUILDER.defineInRange("ingame.long_press_count", 2, 1, 10);
    public static final ForgeConfigSpec.BooleanValue AUTO_SWITCH_CAMERA = BUILDER.define("ingame.camera_auto_switch", () -> false);
    public static final ForgeConfigSpec.EnumValue<KeyConflictResolveScope> KEY_CONFLICT_RESOLVE_SCOPE = BUILDER.defineEnum("ingame.key_conflict_resolve_scope", (Enum)KeyConflictResolveScope.INTERACTION);
    public static final ForgeConfigSpec.EnumValue<PreferenceWork> PREFERENCE_WORK = BUILDER.defineEnum("ingame.preference_work", (Enum)PreferenceWork.ADAPTIVE);
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> BATTLE_MODE_SWITCHING_ITEMS = BUILDER.defineList("ingame.combat_preferred_items", (List)Lists.newArrayList(), element -> {
        if (element instanceof String) {
            String str = (String)element;
            return str.contains(":");
        }
        return false;
    });
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> MINING_MODE_SWITCHING_ITEMS = BUILDER.defineList("ingame.mining_preferred_items", (List)Lists.newArrayList(), element -> {
        if (element instanceof String) {
            String str = (String)element;
            return str.contains(":");
        }
        return false;
    });
    public static final ForgeConfigSpec.ConfigValue<Integer> STAMINA_BAR_X = BUILDER.define("ingame.ui.stamina_bar_x", (Object)120);
    public static final ForgeConfigSpec.ConfigValue<Integer> STAMINA_BAR_Y = BUILDER.define("ingame.ui.stamina_bar_y", (Object)10);
    public static final ForgeConfigSpec.EnumValue<ScreenCalculations.HorizontalBasis> STAMINA_BAR_BASE_X = BUILDER.defineEnum("ingame.ui.stamina_bar_x_base", (Enum)ScreenCalculations.HorizontalBasis.RIGHT);
    public static final ForgeConfigSpec.EnumValue<ScreenCalculations.VerticalBasis> STAMINA_BAR_BASE_Y = BUILDER.defineEnum("ingame.ui.stamina_bar_y_base", (Enum)ScreenCalculations.VerticalBasis.BOTTOM);
    public static final ForgeConfigSpec.ConfigValue<Integer> WEAPON_INNATE_X = BUILDER.define("ingame.ui.weapon_innate_x", (Object)42);
    public static final ForgeConfigSpec.ConfigValue<Integer> WEAPON_INNATE_Y = BUILDER.define("ingame.ui.weapon_innate_y", (Object)48);
    public static final ForgeConfigSpec.EnumValue<ScreenCalculations.HorizontalBasis> WEAPON_INNATE_BASE_X = BUILDER.defineEnum("ingame.ui.weapon_innate_x_base", (Enum)ScreenCalculations.HorizontalBasis.RIGHT);
    public static final ForgeConfigSpec.EnumValue<ScreenCalculations.VerticalBasis> WEAPON_INNATE_BASE_Y = BUILDER.defineEnum("ingame.ui.weapon_innate_y_base", (Enum)ScreenCalculations.VerticalBasis.BOTTOM);
    public static final ForgeConfigSpec.ConfigValue<Integer> PASSIVE_X = BUILDER.define("ingame.ui.passives_x", (Object)70);
    public static final ForgeConfigSpec.ConfigValue<Integer> PASSIVE_Y = BUILDER.define("ingame.ui.passives_y", (Object)36);
    public static final ForgeConfigSpec.EnumValue<ScreenCalculations.HorizontalBasis> PASSIVE_BASE_X = BUILDER.defineEnum("ingame.ui.passives_x_base", (Enum)ScreenCalculations.HorizontalBasis.RIGHT);
    public static final ForgeConfigSpec.EnumValue<ScreenCalculations.VerticalBasis> PASSIVE_BASE_Y = BUILDER.defineEnum("ingame.ui.passives_y_base", (Enum)ScreenCalculations.VerticalBasis.BOTTOM);
    public static final ForgeConfigSpec.EnumValue<ScreenCalculations.AlignDirection> PASSIVE_ALIGN_DIRECTION = BUILDER.defineEnum("ingame.ui.passives_align_direction", (Enum)ScreenCalculations.AlignDirection.HORIZONTAL);
    public static final ForgeConfigSpec.ConfigValue<Integer> CHARGING_BAR_X = BUILDER.define("ingame.ui.charging_bar_x", (Object)-119);
    public static final ForgeConfigSpec.ConfigValue<Integer> CHARGING_BAR_Y = BUILDER.define("ingame.ui.charging_bar_y", (Object)60);
    public static final ForgeConfigSpec.EnumValue<ScreenCalculations.HorizontalBasis> CHARGING_BAR_BASE_X = BUILDER.defineEnum("ingame.ui.charging_bar_x_base", (Enum)ScreenCalculations.HorizontalBasis.CENTER);
    public static final ForgeConfigSpec.EnumValue<ScreenCalculations.VerticalBasis> CHARGING_BAR_BASE_Y = BUILDER.defineEnum("ingame.ui.charging_bar_y_base", (Enum)ScreenCalculations.VerticalBasis.CENTER);
    public static final ForgeConfigSpec.ConfigValue<String> ACCESS_TOKEN = BUILDER.comment("Login information for epic fight patron server. Do not change these values manually").define("access_token", (Object)"");
    public static final ForgeConfigSpec.ConfigValue<String> REFRESH_TOKNE = BUILDER.define("refresh_token", (Object)"");
    public static final ForgeConfigSpec.EnumValue<AuthenticationHelper.AuthenticationProvider> PROVIDER = BUILDER.defineEnum("provider", (Enum)AuthenticationHelper.AuthenticationProvider.NULL);
    public static final ForgeConfigSpec SPEC = BUILDER.build();
    public static int maxStuckProjectiles;
    public static double aimHelperColor;
    public static int aimHelperPackedColor;
    public static boolean enableAimHelper;
    public static boolean bloodEffects;
    public static boolean aimingPovCorrection;
    public static boolean showEpicFightAttributesInTooltip;
    public static boolean activateComputeShader;
    public static boolean enableAnimatedFirstPersonModel;
    public static BlockGuideOptions mineBlockGuideOption;
    public static boolean enableTargetEntityGuide;
    public static boolean enablePovAction;
    public static boolean enableCosmetics;
    public static boolean enableOriginalModel;
    public static int longPressCounter;
    public static boolean authSwitchCamera;
    public static KeyConflictResolveScope keyConflictResolveScope;
    public static PreferenceWork preferenceWork;
    public static Set<Item> combatPreferredItems;
    public static Set<Item> miningPreferredItems;
    public static boolean showTargetIndicator;
    public static HealthBarVisibility healthBarVisibility;
    public static int staminaBarX;
    public static int staminaBarY;
    public static ScreenCalculations.HorizontalBasis staminaBarBaseX;
    public static ScreenCalculations.VerticalBasis staminaBarBaseY;
    public static int weaponInnateX;
    public static int weaponInnateY;
    public static ScreenCalculations.HorizontalBasis weaponInnateBaseX;
    public static ScreenCalculations.VerticalBasis weaponInnateBaseY;
    public static int passiveX;
    public static int passiveY;
    public static ScreenCalculations.HorizontalBasis passiveBaseX;
    public static ScreenCalculations.VerticalBasis passiveBaseY;
    public static ScreenCalculations.AlignDirection passiveAlignDirection;
    public static int chargingBarX;
    public static int chargingBarY;
    public static ScreenCalculations.HorizontalBasis chargingBarBaseX;
    public static ScreenCalculations.VerticalBasis chargingBarBaseY;

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
        if (event.getConfig().getType() != ModConfig.Type.CLIENT) {
            return;
        }
        maxStuckProjectiles = (Integer)MAX_STUCK_PROJECTILES.get();
        aimHelperColor = (Double)AIM_HELPER_COLOR.get();
        aimHelperPackedColor = ColorSlider.rgbColor(aimHelperColor);
        enableAimHelper = (Boolean)ENABLE_AIM_HELPER.get();
        bloodEffects = (Boolean)BLOOD_EFFECTS.get();
        aimingPovCorrection = (Boolean)AIMING_POV_CORRECTION.get();
        showEpicFightAttributesInTooltip = (Boolean)SHOW_EPICFIGHT_ATTRIBUTES_IN_TOOLTIP.get();
        activateComputeShader = (Boolean)ACTIVATE_COMPUTE_SHADER.get();
        enableAnimatedFirstPersonModel = (Boolean)ENABLE_ANIMATED_FIRST_PERSON_MODEL.get();
        mineBlockGuideOption = (BlockGuideOptions)MINE_BLOCK_GUIDE_OPTION.get();
        enableTargetEntityGuide = (Boolean)ENABLE_TARGET_ENTITY_GUIDE.get();
        enablePovAction = (Boolean)ENABLE_POV_ACTION.get();
        enableCosmetics = (Boolean)ENABLE_COSMETICS.get();
        enableOriginalModel = (Boolean)ENABLE_PLAYER_VANILLA_MODEL.get();
        longPressCounter = (Integer)LONG_PRESS_COUNTER.get();
        authSwitchCamera = (Boolean)AUTO_SWITCH_CAMERA.get();
        keyConflictResolveScope = (KeyConflictResolveScope)KEY_CONFLICT_RESOLVE_SCOPE.get();
        preferenceWork = (PreferenceWork)PREFERENCE_WORK.get();
        combatPreferredItems = ((List)BATTLE_MODE_SWITCHING_ITEMS.get()).stream().map(itemName -> (Item)ForgeRegistries.ITEMS.getValue(ResourceLocation.parse((String)itemName))).collect(Collectors.toSet());
        miningPreferredItems = ((List)MINING_MODE_SWITCHING_ITEMS.get()).stream().map(itemName -> (Item)ForgeRegistries.ITEMS.getValue(ResourceLocation.parse((String)itemName))).collect(Collectors.toSet());
        if (combatPreferredItems.isEmpty() && miningPreferredItems.isEmpty()) {
            ItemsPreferenceScreen.resetItems();
        }
        showTargetIndicator = (Boolean)SHOW_TARGET_INDICATOR.get();
        healthBarVisibility = (HealthBarVisibility)HEALTH_BAR_VISIBILITY.get();
        staminaBarX = (Integer)STAMINA_BAR_X.get();
        staminaBarY = (Integer)STAMINA_BAR_Y.get();
        staminaBarBaseX = (ScreenCalculations.HorizontalBasis)((Object)STAMINA_BAR_BASE_X.get());
        staminaBarBaseY = (ScreenCalculations.VerticalBasis)((Object)STAMINA_BAR_BASE_Y.get());
        weaponInnateX = (Integer)WEAPON_INNATE_X.get();
        weaponInnateY = (Integer)WEAPON_INNATE_Y.get();
        weaponInnateBaseX = (ScreenCalculations.HorizontalBasis)((Object)WEAPON_INNATE_BASE_X.get());
        weaponInnateBaseY = (ScreenCalculations.VerticalBasis)((Object)WEAPON_INNATE_BASE_Y.get());
        passiveX = (Integer)PASSIVE_X.get();
        passiveY = (Integer)PASSIVE_Y.get();
        passiveBaseX = (ScreenCalculations.HorizontalBasis)((Object)PASSIVE_BASE_X.get());
        passiveBaseY = (ScreenCalculations.VerticalBasis)((Object)PASSIVE_BASE_Y.get());
        passiveAlignDirection = (ScreenCalculations.AlignDirection)((Object)PASSIVE_ALIGN_DIRECTION.get());
        chargingBarX = (Integer)CHARGING_BAR_X.get();
        chargingBarY = (Integer)CHARGING_BAR_Y.get();
        chargingBarBaseX = (ScreenCalculations.HorizontalBasis)((Object)CHARGING_BAR_BASE_X.get());
        chargingBarBaseY = (ScreenCalculations.VerticalBasis)((Object)CHARGING_BAR_BASE_Y.get());
        if (EpicFightServerConnectionHelper.init(event.getConfig().getFullPath().getParent().toString())) {
            EpicFightMod.LOGGER.info("Epic Fight web server connection helper: supported");
            try {
                Class.forName("yesman.epicfight.epicskins.user.AuthenticationHelperImpl");
            }
            catch (Exception e) {
                EpicFightMod.LOGGER.info("Epic Fight web server status: Failed at initializing Authentication provider: " + e);
            }
        } else {
            EpicFightMod.LOGGER.info("Epic Fight web server connection helper: unsupported");
        }
        if (EpicFightServerConnectionHelper.supported() && ClientEngine.getInstance().getAuthHelper().valid()) {
            ClientEngine.getInstance().getAuthHelper().initialize(ACCESS_TOKEN, REFRESH_TOKNE, PROVIDER);
        }
    }

    public static void saveChanges() {
        if (maxStuckProjectiles != (Integer)MAX_STUCK_PROJECTILES.get()) {
            MAX_STUCK_PROJECTILES.set((Object)maxStuckProjectiles);
        }
        if (aimHelperColor != (Double)AIM_HELPER_COLOR.get()) {
            AIM_HELPER_COLOR.set((Object)aimHelperColor);
            aimHelperPackedColor = ColorSlider.rgbColor(aimHelperColor);
        }
        if (enableAimHelper != (Boolean)ENABLE_AIM_HELPER.get()) {
            ENABLE_AIM_HELPER.set((Object)enableAimHelper);
        }
        if (bloodEffects != (Boolean)BLOOD_EFFECTS.get()) {
            BLOOD_EFFECTS.set((Object)bloodEffects);
        }
        if (aimingPovCorrection != (Boolean)AIMING_POV_CORRECTION.get()) {
            AIMING_POV_CORRECTION.set((Object)aimingPovCorrection);
        }
        if (showEpicFightAttributesInTooltip != (Boolean)SHOW_EPICFIGHT_ATTRIBUTES_IN_TOOLTIP.get()) {
            SHOW_EPICFIGHT_ATTRIBUTES_IN_TOOLTIP.set((Object)showEpicFightAttributesInTooltip);
        }
        if (activateComputeShader != (Boolean)ACTIVATE_COMPUTE_SHADER.get()) {
            ACTIVATE_COMPUTE_SHADER.set((Object)activateComputeShader);
        }
        if (enableAnimatedFirstPersonModel != (Boolean)ENABLE_ANIMATED_FIRST_PERSON_MODEL.get()) {
            ENABLE_ANIMATED_FIRST_PERSON_MODEL.set((Object)enableAnimatedFirstPersonModel);
        }
        if (mineBlockGuideOption != MINE_BLOCK_GUIDE_OPTION.get()) {
            MINE_BLOCK_GUIDE_OPTION.set((Object)mineBlockGuideOption);
        }
        if (enableTargetEntityGuide != (Boolean)ENABLE_TARGET_ENTITY_GUIDE.get()) {
            ENABLE_TARGET_ENTITY_GUIDE.set((Object)enableTargetEntityGuide);
        }
        if (enablePovAction != (Boolean)ENABLE_POV_ACTION.get()) {
            ENABLE_POV_ACTION.set((Object)enablePovAction);
        }
        if (enableCosmetics != (Boolean)ENABLE_COSMETICS.get()) {
            ENABLE_COSMETICS.set((Object)enableCosmetics);
        }
        if (enableOriginalModel != (Boolean)ENABLE_PLAYER_VANILLA_MODEL.get()) {
            ENABLE_PLAYER_VANILLA_MODEL.set((Object)enableOriginalModel);
        }
        if (longPressCounter != (Integer)LONG_PRESS_COUNTER.get()) {
            LONG_PRESS_COUNTER.set((Object)longPressCounter);
        }
        if (authSwitchCamera != (Boolean)AUTO_SWITCH_CAMERA.get()) {
            AUTO_SWITCH_CAMERA.set((Object)authSwitchCamera);
        }
        if (keyConflictResolveScope != KEY_CONFLICT_RESOLVE_SCOPE.get()) {
            KEY_CONFLICT_RESOLVE_SCOPE.set((Object)keyConflictResolveScope);
        }
        if (preferenceWork != PREFERENCE_WORK.get()) {
            PREFERENCE_WORK.set((Object)preferenceWork);
        }
        if (!combatPreferredItems.equals(((List)BATTLE_MODE_SWITCHING_ITEMS.get()).stream().map(itemName -> (Item)ForgeRegistries.ITEMS.getValue(ResourceLocation.parse((String)itemName))).collect(Collectors.toSet()))) {
            BATTLE_MODE_SWITCHING_ITEMS.set(combatPreferredItems.stream().map(item -> ForgeRegistries.ITEMS.getKey(item).toString()).collect(Collectors.toList()));
        }
        if (!miningPreferredItems.equals(((List)MINING_MODE_SWITCHING_ITEMS.get()).stream().map(itemName -> (Item)ForgeRegistries.ITEMS.getValue(ResourceLocation.parse((String)itemName))).collect(Collectors.toSet()))) {
            MINING_MODE_SWITCHING_ITEMS.set(miningPreferredItems.stream().map(item -> ForgeRegistries.ITEMS.getKey(item).toString()).collect(Collectors.toList()));
        }
        if (showTargetIndicator != (Boolean)SHOW_TARGET_INDICATOR.get()) {
            SHOW_TARGET_INDICATOR.set((Object)showTargetIndicator);
        }
        if (healthBarVisibility != HEALTH_BAR_VISIBILITY.get()) {
            HEALTH_BAR_VISIBILITY.set((Object)healthBarVisibility);
        }
        if (staminaBarX != (Integer)STAMINA_BAR_X.get()) {
            STAMINA_BAR_X.set((Object)staminaBarX);
        }
        if (staminaBarY != (Integer)STAMINA_BAR_Y.get()) {
            STAMINA_BAR_Y.set((Object)staminaBarY);
        }
        if (staminaBarBaseX != STAMINA_BAR_BASE_X.get()) {
            STAMINA_BAR_BASE_X.set((Object)staminaBarBaseX);
        }
        if (staminaBarBaseY != STAMINA_BAR_BASE_Y.get()) {
            STAMINA_BAR_BASE_Y.set((Object)staminaBarBaseY);
        }
        if (weaponInnateX != (Integer)WEAPON_INNATE_X.get()) {
            WEAPON_INNATE_X.set((Object)weaponInnateX);
        }
        if (weaponInnateX != (Integer)WEAPON_INNATE_Y.get()) {
            WEAPON_INNATE_Y.set((Object)weaponInnateY);
        }
        if (weaponInnateBaseX != WEAPON_INNATE_BASE_X.get()) {
            WEAPON_INNATE_BASE_X.set((Object)weaponInnateBaseX);
        }
        if (weaponInnateBaseY != WEAPON_INNATE_BASE_Y.get()) {
            WEAPON_INNATE_BASE_Y.set((Object)weaponInnateBaseY);
        }
        if (passiveX != (Integer)PASSIVE_X.get()) {
            PASSIVE_X.set((Object)passiveX);
        }
        if (passiveY != (Integer)PASSIVE_Y.get()) {
            PASSIVE_Y.set((Object)passiveY);
        }
        if (passiveBaseX != PASSIVE_BASE_X.get()) {
            PASSIVE_BASE_X.set((Object)passiveBaseX);
        }
        if (passiveBaseY != PASSIVE_BASE_Y.get()) {
            PASSIVE_BASE_Y.set((Object)passiveBaseY);
        }
        if (passiveAlignDirection != PASSIVE_ALIGN_DIRECTION.get()) {
            PASSIVE_ALIGN_DIRECTION.set((Object)passiveAlignDirection);
        }
        if (chargingBarX != (Integer)CHARGING_BAR_X.get()) {
            CHARGING_BAR_X.set((Object)chargingBarX);
        }
        if (chargingBarY != (Integer)CHARGING_BAR_Y.get()) {
            CHARGING_BAR_Y.set((Object)chargingBarY);
        }
        if (chargingBarBaseX != CHARGING_BAR_BASE_X.get()) {
            CHARGING_BAR_BASE_X.set((Object)chargingBarBaseX);
        }
        if (chargingBarBaseY != CHARGING_BAR_BASE_Y.get()) {
            CHARGING_BAR_BASE_Y.set((Object)chargingBarBaseY);
        }
    }

    public static Vec2i getStaminaPosition(int width, int height) {
        int posX = ClientConfig.staminaBarBaseX.positionGetter.apply(width, staminaBarX);
        int posY = ClientConfig.staminaBarBaseY.positionGetter.apply(height, staminaBarY);
        return new Vec2i(posX, posY);
    }

    public static Vec2i getWeaponInnatePosition(int width, int height) {
        int posX = ClientConfig.weaponInnateBaseX.positionGetter.apply(width, weaponInnateX);
        int posY = ClientConfig.weaponInnateBaseY.positionGetter.apply(height, weaponInnateY);
        return new Vec2i(posX, posY);
    }

    public static Vec2i getChargingBarPosition(int width, int height) {
        int posX = ClientConfig.chargingBarBaseX.positionGetter.apply(width, chargingBarX);
        int posY = ClientConfig.chargingBarBaseY.positionGetter.apply(height, chargingBarY);
        return new Vec2i(posX, posY);
    }

    static {
        aimHelperPackedColor = -1;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum BlockGuideOptions implements CirculatableEnum<BlockGuideOptions>,
    StringRepresentable
    {
        NONE(false, false),
        CROSSHAIR(true, false),
        HIGHLIGHT(false, true),
        CROSSHAIR_AND_HIGHLIGHT(true, true);

        boolean showCrosshair;
        boolean showBlockHighlight;

        private BlockGuideOptions(boolean showCrosshair, boolean showBlockHighlight) {
            this.showCrosshair = showCrosshair;
            this.showBlockHighlight = showBlockHighlight;
        }

        public boolean switchCrosshair() {
            return this.showCrosshair;
        }

        public boolean showBlockHighlight() {
            return this.showBlockHighlight;
        }

        @Override
        public BlockGuideOptions nextEnum() {
            return BlockGuideOptions.values()[(this.ordinal() + 1) % 4];
        }

        public String m_7912_() {
            return ParseUtil.toLowerCase(this.name());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum KeyConflictResolveScope implements CirculatableEnum<KeyConflictResolveScope>,
    StringRepresentable
    {
        NONE(false, false),
        INTERACTION(true, false),
        ITEM_USE(false, true),
        INTERACTION_AND_ITEMUSE(true, true);

        boolean cancelInteraction;
        boolean cancelItemUse;

        private KeyConflictResolveScope(boolean cancelBlockInteraction, boolean cancelItemInteraction) {
            this.cancelInteraction = cancelBlockInteraction;
            this.cancelItemUse = cancelItemInteraction;
        }

        public boolean cancelInteraction() {
            return this.cancelInteraction;
        }

        public boolean cancelItemUse() {
            return this.cancelItemUse;
        }

        @Override
        public KeyConflictResolveScope nextEnum() {
            return KeyConflictResolveScope.values()[(this.ordinal() + 1) % 4];
        }

        public String m_7912_() {
            return ParseUtil.toLowerCase(this.name());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum PreferenceWork implements CirculatableEnum<PreferenceWork>,
    StringRepresentable
    {
        ADAPTIVE(true),
        SWITCH_MODE(false);

        boolean checkHitResult;

        private PreferenceWork(boolean checkHitResult) {
            this.checkHitResult = checkHitResult;
        }

        public boolean checkHitResult() {
            return this.checkHitResult;
        }

        public String m_7912_() {
            return ParseUtil.toLowerCase(this.name());
        }

        @Override
        public PreferenceWork nextEnum() {
            return PreferenceWork.values()[(this.ordinal() + 1) % 2];
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum HealthBarVisibility implements CirculatableEnum<HealthBarVisibility>,
    StringRepresentable
    {
        NONE,
        HURT,
        TARGET,
        TARGET_AND_HURT;


        @Override
        public HealthBarVisibility nextEnum() {
            return HealthBarVisibility.values()[(this.ordinal() + 1) % 4];
        }

        public String m_7912_() {
            return ParseUtil.toLowerCase(this.name());
        }
    }
}

