/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.data.loot.function;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import it.unimi.dsi.fastutil.floats.FloatObjectPair;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraftforge.fml.ModList;
import yesman.epicfight.api.data.reloader.SkillManager;
import yesman.epicfight.data.loot.EpicFightLootTables;
import yesman.epicfight.skill.Skill;

public class SetSkillFunction
implements LootItemFunction {
    private final List<FloatObjectPair<String>> skillsAndWeight;

    public SetSkillFunction(List<FloatObjectPair<String>> skillsAndWeight) {
        this.skillsAndWeight = skillsAndWeight;
    }

    private Skill getSkillForSeed(float seed) {
        for (FloatObjectPair<String> pair : this.skillsAndWeight) {
            if (!(seed < pair.firstFloat())) continue;
            return SkillManager.getSkill((String)pair.second());
        }
        return this.skillsAndWeight.isEmpty() ? null : SkillManager.getSkill((String)this.skillsAndWeight.get(0).second());
    }

    public ItemStack apply(ItemStack itemstack, LootContext lootContext) {
        if (ModList.get().isLoaded("epicskills")) {
            return ItemStack.f_41583_;
        }
        float val = lootContext.m_230907_().m_188501_();
        Skill skill = this.getSkillForSeed(val);
        if (skill != null) {
            itemstack.m_41784_().m_128359_("skill", skill.toString());
        }
        return itemstack;
    }

    public static LootItemFunction.Builder builder(final String ... skills) {
        return new LootItemFunction.Builder(){

            public LootItemFunction m_7453_() {
                ArrayList list = Lists.newArrayList();
                float weight = 1.0f / (float)skills.length;
                float weightSum = 0.0f;
                for (String skill : skills) {
                    list.add(FloatObjectPair.of((float)(weightSum += weight), (Object)skill));
                }
                return new SetSkillFunction(list);
            }
        };
    }

    public static LootItemFunction.Builder builder(final Object ... skillAndWeight) {
        return new LootItemFunction.Builder(){

            public LootItemFunction m_7453_() {
                int i;
                ArrayList list = Lists.newArrayList();
                float weightTotal = 0.0f;
                float weightSum = 0.0f;
                for (i = 0; i < skillAndWeight.length / 2; ++i) {
                    weightTotal += ((Float)skillAndWeight[i * 2]).floatValue();
                }
                for (i = 0; i < skillAndWeight.length / 2; ++i) {
                    list.add(FloatObjectPair.of((float)((weightSum += ((Float)skillAndWeight[i * 2]).floatValue()) / weightTotal), (Object)((String)skillAndWeight[i * 2 + 1])));
                }
                return new SetSkillFunction(list);
            }
        };
    }

    public LootItemFunctionType m_7162_() {
        return EpicFightLootTables.SET_SKILLBOOK_SKILL;
    }

    public static class Serializer
    implements net.minecraft.world.level.storage.loot.Serializer<SetSkillFunction> {
        public void serialize(JsonObject jsonObj, SetSkillFunction skillFunction, JsonSerializationContext jsonDeserializationContext) {
            JsonArray skillArray = new JsonArray();
            JsonArray weightArray = new JsonArray();
            for (FloatObjectPair<String> pair : skillFunction.skillsAndWeight) {
                skillArray.add((String)pair.second());
                weightArray.add((Number)Float.valueOf(pair.firstFloat()));
            }
            jsonObj.add("skills", (JsonElement)skillArray);
            jsonObj.add("weights", (JsonElement)weightArray);
        }

        public SetSkillFunction deserialize(JsonObject jsonObj, JsonDeserializationContext jsonDeserializationContext) {
            int i;
            JsonArray skillArray = jsonObj.getAsJsonArray("skills");
            JsonArray weightArray = jsonObj.getAsJsonArray("weights");
            ArrayList list = Lists.newArrayList();
            float totalWeights = 0.0f;
            for (i = 0; i < skillArray.size(); ++i) {
                totalWeights += weightArray.get(i).getAsFloat();
            }
            for (i = 0; i < skillArray.size(); ++i) {
                if (SkillManager.getSkill(skillArray.get(i).getAsString()) == null) {
                    new NoSuchElementException("SetSkillFunction: There is no skill named " + skillArray.get(i).getAsString()).printStackTrace();
                    continue;
                }
                list.add(FloatObjectPair.of((float)(weightArray.get(i).getAsFloat() / totalWeights), (Object)skillArray.get(i).getAsString()));
            }
            return new SetSkillFunction(list);
        }
    }
}

