/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.skill.mover;

import java.util.UUID;
import net.minecraft.client.KeyMapping;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.client.input.handlers.InputManager;
import yesman.epicfight.api.utils.LevelUtil;
import yesman.epicfight.api.utils.math.ValueModifier;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.client.events.engine.ControlEngine;
import yesman.epicfight.client.gui.screen.SkillBookScreen;
import yesman.epicfight.client.input.EpicFightKeyMappings;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.network.server.SPSkillExecutionFeedback;
import yesman.epicfight.particle.EpicFightParticles;
import yesman.epicfight.particle.HitParticleType;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillBuilder;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillDataKeys;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.skill.modules.ChargeableSkill;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class DemolitionLeapSkill
extends Skill
implements ChargeableSkill {
    private static final UUID EVENT_UUID = UUID.fromString("3d142bf4-0dcd-11ee-be56-0242ac120002");
    private AnimationManager.AnimationAccessor<? extends StaticAnimation> chargingAnimation = Animations.BIPED_DEMOLITION_LEAP_CHARGING;
    private AnimationManager.AnimationAccessor<? extends StaticAnimation> shootAnimation = Animations.BIPED_DEMOLITION_LEAP;

    public DemolitionLeapSkill(SkillBuilder<? extends Skill> builder) {
        super(builder);
    }

    @Override
    public void onInitiate(SkillContainer container) {
        PlayerEventListener listener = container.getExecutor().getEventListener();
        listener.addEventListener(PlayerEventListener.EventType.MOVEMENT_INPUT_EVENT, EVENT_UUID, event -> {
            if (((LocalPlayerPatch)event.getPlayerPatch()).isHoldingSkill(this)) {
                InputManager.setInputState(event.getInputState().withJumping(false));
            }
        });
        listener.addEventListener(PlayerEventListener.EventType.TAKE_DAMAGE_EVENT_HURT, EVENT_UUID, event -> {
            if (event.getDamageSource().m_269533_(DamageTypeTags.f_268549_) && ((Boolean)container.getDataManager().getDataValue((SkillDataKey)SkillDataKeys.PROTECT_NEXT_FALL.get())).booleanValue()) {
                event.attachValueModifier(ValueModifier.multiplier(0.5f));
                container.getDataManager().setData((SkillDataKey)SkillDataKeys.PROTECT_NEXT_FALL.get(), false);
            }
        }, 1);
        listener.addEventListener(PlayerEventListener.EventType.FALL_EVENT, EVENT_UUID, event -> {
            if (LevelUtil.calculateLivingEntityFallDamage(event.getForgeEvent().getEntity(), event.getForgeEvent().getDamageMultiplier(), event.getForgeEvent().getDistance()) == 0) {
                container.getDataManager().setData((SkillDataKey)SkillDataKeys.PROTECT_NEXT_FALL.get(), false);
            }
        });
    }

    @Override
    public void onRemoved(SkillContainer container) {
        super.onRemoved(container);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.MOVEMENT_INPUT_EVENT, EVENT_UUID);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.TAKE_DAMAGE_EVENT_HURT, EVENT_UUID, 1);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.FALL_EVENT, EVENT_UUID);
    }

    @Override
    public boolean isExecutableState(PlayerPatch<?> executor) {
        return super.isExecutableState(executor) && ((Player)executor.getOriginal()).m_20096_();
    }

    @Override
    public void cancelOnClient(SkillContainer container, FriendlyByteBuf args) {
        super.cancelOnClient(container, args);
        container.getExecutor().resetHolding();
        container.getExecutor().playAnimationSynchronized(Animations.BIPED_IDLE, 0.0f);
    }

    @Override
    public void executeOnClient(SkillContainer container, FriendlyByteBuf args) {
        args.readInt();
        int ticks = args.readInt();
        int modifiedTicks = (int)((double)7.4668f * Math.log10((float)ticks + 1.0f) / Math.log10(2.0));
        Vec3f jumpDirection = new Vec3f(0.0f, (float)modifiedTicks * 0.05f, 0.0f);
        float xRot = Mth.m_14036_((float)(70.0f + Mth.m_14036_((float)container.getExecutor().getCameraXRot(), (float)-90.0f, (float)0.0f)), (float)0.0f, (float)70.0f);
        jumpDirection.add(0.0f, xRot / 70.0f * 0.05f, 0.0f);
        jumpDirection.rotate(xRot, Vec3f.X_AXIS);
        jumpDirection.rotate(-container.getExecutor().getCameraYRot(), Vec3f.Y_AXIS);
        ((Player)container.getExecutor().getOriginal()).m_20256_(jumpDirection.toDoubleVector());
        container.getExecutor().resetHolding();
    }

    @Override
    public void gatherHoldArguments(SkillContainer container, ControlEngine controlEngine, FriendlyByteBuf buffer) {
        controlEngine.setHoldingKey(SkillSlots.MOVER, this.getKeyMapping());
        container.getExecutor().startSkillHolding(this);
    }

    @Override
    public void startHolding(SkillContainer caster) {
        if (!caster.getExecutor().isLogicalClient()) {
            caster.getExecutor().playAnimationSynchronized(this.chargingAnimation, 0.0f);
        }
    }

    @Override
    public void onStopHolding(SkillContainer container, SPSkillExecutionFeedback feedback) {
        if (container.getExecutor().getSkillChargingTicks(1.0f) > (float)this.getAllowedMaxChargingTicks()) {
            feedback.setFeedbackType(SPSkillExecutionFeedback.FeedbackType.EXPIRED);
        } else {
            container.getServerExecutor().playSound((SoundEvent)EpicFightSounds.ROCKET_JUMP.get(), 1.0f, 0.0f, 0.0f);
            container.getServerExecutor().playSound((SoundEvent)EpicFightSounds.ENTITY_MOVE.get(), 1.0f, 0.0f, 0.0f);
            int accumulatedTicks = container.getExecutor().getChargingAmount();
            LevelUtil.circleSlamFracture(null, ((ServerPlayer)container.getServerExecutor().getOriginal()).m_9236_(), ((ServerPlayer)container.getServerExecutor().getOriginal()).m_20182_().m_82492_(0.0, 1.0, 0.0), (double)accumulatedTicks * 0.05, true, false, false);
            Vec3 entityEyepos = ((ServerPlayer)container.getServerExecutor().getOriginal()).m_146892_();
            ((HitParticleType)((Object)EpicFightParticles.AIR_BURST.get())).spawnParticleWithArgument(((ServerPlayer)container.getServerExecutor().getOriginal()).m_284548_(), entityEyepos.f_82479_, entityEyepos.f_82480_, entityEyepos.f_82481_, 0.0, 0.0, 2.0 + 0.05 * (double)container.getServerExecutor().getAccumulatedChargeAmount());
            container.getServerExecutor().playAnimationSynchronized(this.shootAnimation, 0.0f);
            feedback.getBuffer().writeInt(accumulatedTicks);
            container.getDataManager().setData((SkillDataKey)SkillDataKeys.PROTECT_NEXT_FALL.get(), true);
        }
    }

    @Override
    public int getAllowedMaxChargingTicks() {
        return 80;
    }

    @Override
    public int getMaxChargingTicks() {
        return 40;
    }

    @Override
    public int getMinChargingTicks() {
        return 12;
    }

    @Override
    public KeyMapping getKeyMapping() {
        return EpicFightKeyMappings.MOVER_SKILL;
    }

    @Override
    public void holdTick(SkillContainer container) {
        int chargingTicks = container.getExecutor().getSkillChargingTicks();
        if (chargingTicks % 5 == 0 && container.getExecutor().getAccumulatedChargeAmount() < this.getMaxChargingTicks() && container.getExecutor().consumeForSkill((Skill)this, Skill.Resource.STAMINA, this.consumption)) {
            container.getExecutor().setChargingAmount(container.getExecutor().getChargingAmount() + 5);
        }
    }

    @Override
    public boolean getCustomConsumptionTooltips(SkillBookScreen.AttributeIconList consumptionList) {
        consumptionList.add((Component)Component.m_237115_((String)"attribute.name.epicfight.stamina.consume.tooltip"), (Component)Component.m_237110_((String)"attribute.name.epicfight.stamina_per_second.consume", (Object[])new Object[]{ItemStack.f_41584_.format(this.consumption), "0.25"}), SkillBookScreen.STAMINA_TEXTURE_INFO);
        return true;
    }
}

