/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.skill.weaponinnate;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.utils.math.ValueModifier;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.weaponinnate.SimpleWeaponInnateSkill;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class GuillotineAxeSkill
extends SimpleWeaponInnateSkill {
    private static final UUID EVENT_UUID = UUID.fromString("b84e577a-c653-11ed-afa1-0242ac120002");

    public GuillotineAxeSkill(SimpleWeaponInnateSkill.Builder builder) {
        super(builder);
    }

    @Override
    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.DEAL_DAMAGE_EVENT_HURT, EVENT_UUID, event -> {
            if (event.getDamageSource().getAnimation() == Animations.THE_GUILLOTINE) {
                ValueModifier.ResultCalculator executionMinHealth = ValueModifier.calculator();
                this.getProperty(AnimationProperty.AttackPhaseProperty.DAMAGE_MODIFIER, (Map)this.properties.get(0)).ifPresent(executionMinHealth::attach);
                executionMinHealth.multiply(0.8f);
                float health = event.getTarget().m_21223_();
                float baseDamage = (float)((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_21133_(Attributes.f_22281_);
                float modifiedBaseDamage = ((ServerPlayerPatch)event.getPlayerPatch()).getModifiedBaseDamage(baseDamage);
                float executionHealth = executionMinHealth.getResult(modifiedBaseDamage);
                if (health < executionHealth && event.getDamageSource() != null) {
                    event.getDamageSource().setExecute();
                }
            }
        });
    }

    @Override
    public void onRemoved(SkillContainer container) {
        super.onRemoved(container);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.DEAL_DAMAGE_EVENT_HURT, EVENT_UUID);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<Component> getTooltipOnItem(ItemStack itemstack, CapabilityItem cap, PlayerPatch<?> playerpatch) {
        ArrayList list = Lists.newArrayList();
        ArrayList tooltipArgs = Lists.newArrayList();
        String traslatableText = this.getTranslationKey();
        double itemBaseDamage = ((Player)playerpatch.getOriginal()).m_21051_(Attributes.f_22281_).m_22115_() + (double)EnchantmentHelper.m_44833_((ItemStack)itemstack, (MobType)MobType.f_21640_);
        HashSet<AttributeModifier> attributeModifiers = new HashSet<AttributeModifier>();
        attributeModifiers.addAll(((Player)playerpatch.getOriginal()).m_21051_(Attributes.f_22281_).m_22122_());
        attributeModifiers.addAll(CapabilityItem.getAttributeModifiers(Attributes.f_22281_, EquipmentSlot.MAINHAND, itemstack, playerpatch));
        for (AttributeModifier modifier : attributeModifiers) {
            itemBaseDamage += modifier.m_22218_();
        }
        ValueModifier.ResultCalculator executionMinHealth = ValueModifier.calculator();
        this.getProperty(AnimationProperty.AttackPhaseProperty.DAMAGE_MODIFIER, (Map)this.properties.get(0)).ifPresent(executionMinHealth::attach);
        executionMinHealth.multiply(0.8f);
        tooltipArgs.add(ChatFormatting.RED + ItemStack.f_41584_.format(executionMinHealth.getResult((float)itemBaseDamage)));
        list.add(Component.m_237115_((String)traslatableText).m_130940_(ChatFormatting.WHITE).m_7220_((Component)Component.m_237113_((String)String.format("[%.0f]", Float.valueOf(this.consumption))).m_130940_(ChatFormatting.AQUA)));
        list.add(Component.m_237110_((String)(traslatableText + ".tooltip"), (Object[])tooltipArgs.toArray(new Object[0])).m_130940_(ChatFormatting.DARK_GRAY));
        this.generateTooltipforPhase(list, itemstack, cap, playerpatch, (Map)this.properties.get(0), "Each Strike:");
        return list;
    }
}

