/*
 * Decompiled with CFR 0.152.
 */
package com.yesman.epicskills.client.gui.screen;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.datafixers.util.Pair;
import com.yesman.epicskills.EpicSkills;
import com.yesman.epicskills.client.gui.screen.BackgroundRenderableScreen;
import com.yesman.epicskills.client.gui.screen.CategorySlotTexture;
import com.yesman.epicskills.client.gui.screen.SkillInfoScreen;
import com.yesman.epicskills.client.gui.widget.HoverSoundPlayer;
import com.yesman.epicskills.network.NetworkManager;
import com.yesman.epicskills.network.client.ClientBoundSetAbilityPoints;
import com.yesman.epicskills.network.server.ServerBoundConvertAbilityPointRequest;
import com.yesman.epicskills.registry.entry.EpicSkillsSounds;
import com.yesman.epicskills.skilltree.SkillTree;
import com.yesman.epicskills.world.capability.AbilityPoints;
import com.yesman.epicskills.world.capability.SkillTreeProgression;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.FastColor;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import yesman.epicfight.api.utils.ExtendableEnum;
import yesman.epicfight.api.utils.ParseUtil;
import yesman.epicfight.api.utils.math.Vec2i;
import yesman.epicfight.client.gui.screen.SkillEditScreen;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.main.EpicFightMod;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.world.capabilities.skill.CapabilitySkill;
import yesman.epicfight.world.item.EpicFightItems;

@OnlyIn(value=Dist.CLIENT)
public class SkillTreeScreen
extends Screen
implements BackgroundRenderableScreen {
    public static final Function<Holder.Reference<SkillTree>, ResourceLocation> SKILL_TREE_BACKGROUND_TEXTURES = Util.m_143827_(skillTree -> ResourceLocation.fromNamespaceAndPath((String)skillTree.m_205785_().m_135782_().m_135827_(), (String)String.format("textures/gui/skill_tree/background/%s.png", skillTree.m_205785_().m_135782_().m_135815_())));
    public static final Function<Holder.Reference<SkillTree>, ResourceLocation> SKILL_TREE_ICON_TEXTURES = Util.m_143827_(skillTree -> ResourceLocation.fromNamespaceAndPath((String)skillTree.m_205785_().m_135782_().m_135827_(), (String)String.format("textures/gui/skill_tree/icon/%s.png", skillTree.m_205785_().m_135782_().m_135815_())));
    private final Player player;
    private final CapabilitySkill playerSkills;
    private final AbilityPoints playerAbilityPoints;
    private final SkillTreeProgression playerSkillTreeProgression;
    private final Map<Holder.Reference<SkillTree>, Integer> skillTreeIndices = new HashMap<Holder.Reference<SkillTree>, Integer>();
    private final Map<Integer, TreePage> skillTreePages = new HashMap<Integer, TreePage>();
    private final Map<Integer, TreeSelectButton> skillTreeButtons = new HashMap<Integer, TreeSelectButton>();
    private final ExpToAbilityPointConverstionButton expConversionButton;
    private final Button scaleUpButton;
    private final Button scaleDownButton;
    private TreePage currentPage;
    private LayoutElement hoveringWidget;
    private boolean backgroundMode;
    private boolean synclock;
    private boolean discarded = false;
    private boolean disableMouseDragging = false;
    private int nodeScale = -1;

    public SkillTreeScreen(LocalPlayerPatch playerpatch) {
        super((Component)Component.m_237115_((String)"gui.epicskills.skill_tree"));
        this.player = (Player)playerpatch.getOriginal();
        this.playerSkills = playerpatch.getSkillCapability();
        this.playerAbilityPoints = (AbilityPoints)((LocalPlayer)playerpatch.getOriginal()).getCapability(AbilityPoints.ABILITY_POINTS).orElseThrow(() -> new NoSuchElementException("Player doesn't have ability point capability"));
        this.playerSkillTreeProgression = (SkillTreeProgression)((LocalPlayer)playerpatch.getOriginal()).getCapability(SkillTreeProgression.SKILL_TREE_PROGRESSION).orElseThrow(() -> new NoSuchElementException("Player doesn't have skill tree capability"));
        HolderLookup skillTreeLookup = this.player.m_9236_().m_246945_(SkillTree.SKILL_TREE_REGISTRY_KEY);
        MutableInt index = new MutableInt(0);
        skillTreeLookup.m_214062_().sorted((page1, page2) -> {
            if (((SkillTree)page1.get()).priority() == ((SkillTree)page2.get()).priority()) {
                return page1.m_205785_().m_135782_().toString().compareTo(page2.m_205785_().m_135782_().toString());
            }
            return Integer.compare(((SkillTree)page1.get()).priority(), ((SkillTree)page2.get()).priority());
        }).forEach(skillTree -> {
            if (((SkillTree)skillTree.get()).disabled()) {
                return;
            }
            SkillTreeProgression.TreeState treeState = this.playerSkillTreeProgression.getTreeState((Holder.Reference<SkillTree>)skillTree);
            if (treeState != SkillTreeProgression.TreeState.LOCKED || !((SkillTree)skillTree.get()).hiddenWhenLocked()) {
                this.skillTreePages.put(index.intValue(), new TreePage(this.playerSkillTreeProgression.getNodes((Holder<SkillTree>)skillTree), (Holder.Reference<SkillTree>)skillTree));
                this.skillTreeIndices.put((Holder.Reference<SkillTree>)skillTree, index.intValue());
                TreeSelectButton skillTreeButton = new TreeSelectButton(index.intValue(), (Holder.Reference<SkillTree>)skillTree);
                skillTreeButton.f_93623_ = treeState != SkillTreeProgression.TreeState.LOCKED;
                MutableComponent tooltip = Component.m_237115_((String)SkillTree.toDescriptionId((ResourceKey<SkillTree>)skillTree.m_205785_()));
                if (treeState == SkillTreeProgression.TreeState.LOCKED && ((SkillTree)skillTree.m_203334_()).unlockTip() != null) {
                    tooltip.m_7220_((Component)Component.m_237113_((String)"\n")).m_7220_(((SkillTree)skillTree.m_203334_()).unlockTip());
                }
                skillTreeButton.m_257544_(Tooltip.m_257550_((Component)tooltip));
                this.skillTreeButtons.put(index.intValue(), skillTreeButton);
            }
            index.add(1);
        });
        this.expConversionButton = new ExpToAbilityPointConverstionButton(0, 0, 16, 16);
        this.expConversionButton.f_93623_ = this.playerAbilityPoints.hasEnoughExp();
        this.scaleUpButton = Button.m_253074_((Component)Component.m_237113_((String)"+"), button -> this.scaleUp()).m_253046_(12, 12).m_253136_();
        this.scaleDownButton = Button.m_253074_((Component)Component.m_237113_((String)"-"), button -> this.scaleDown()).m_253046_(12, 12).m_253136_();
        this.f_96547_ = Minecraft.m_91087_().f_91062_;
        if (this.skillTreePages.isEmpty()) {
            Minecraft.m_91087_().f_91065_.m_93076_().m_93785_((Component)Component.m_237115_((String)"chat.epicskills.messages.no_page"));
            this.discarded = true;
        } else {
            this.setTreeIndex(0);
        }
    }

    public void m_7856_() {
        MutableInt posY = new MutableInt(10);
        this.backgroundMode = false;
        this.skillTreeButtons.values().forEach(button -> {
            button.m_253211_(posY.intValue());
            this.m_142416_((GuiEventListener)button);
            posY.add(36);
        });
        this.expConversionButton.m_264152_(this.f_96543_ - (this.expConversionButton.m_5711_() + 90), 9);
        this.m_142416_((GuiEventListener)this.expConversionButton);
        this.m_142416_((GuiEventListener)this.scaleUpButton);
        this.m_142416_((GuiEventListener)this.scaleDownButton);
        this.m_142416_((GuiEventListener)new OpenSkillEditorButton(this.f_96543_ - 30, 8, 20, 20));
        this.m_169394_((Renderable)new ExperienceMeter(this.f_96543_ - (this.expConversionButton.m_5711_() + 70), 14));
        this.m_169394_((Renderable)new AbilityPointsMeter(this.f_96543_ - (this.expConversionButton.m_5711_() + 150), 10));
    }

    public void relocateScaleButtons() {
        int titleWidth = this.f_96547_.m_92852_((FormattedText)this.currentPage.title);
        this.scaleUpButton.m_264152_(53 + titleWidth, 16);
        this.scaleDownButton.m_264152_(66 + titleWidth, 16);
    }

    public void m_86600_() {
        this.expConversionButton.tick();
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        ResourceLocation background = SKILL_TREE_BACKGROUND_TEXTURES.apply(this.currentPage.skillTree);
        Vec3i menuBarColor = ((SkillTree)this.currentPage.skillTree.m_203334_()).menuBarColor();
        guiGraphics.m_280479_(background, 0, this.f_96543_, 0, this.f_96544_, -1, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
        guiGraphics.m_280509_(0, 0, 39, this.f_96544_, FastColor.ARGB32.m_13660_((int)200, (int)menuBarColor.m_123341_(), (int)menuBarColor.m_123342_(), (int)menuBarColor.m_123343_()));
        guiGraphics.m_280430_(this.f_96547_, this.currentPage.getTitle(), 46, 18, -1);
        guiGraphics.m_280509_(44, 32, this.f_96543_ - 10, 34, FastColor.ARGB32.m_13660_((int)200, (int)menuBarColor.m_123341_(), (int)menuBarColor.m_123342_(), (int)menuBarColor.m_123343_()));
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        if (!this.isBackgroundMode()) {
            boolean hasAny = false;
            for (GuiEventListener child : this.m_6702_()) {
                HoverSoundPlayer hoverSoundPlayer;
                SoundEvent event;
                LayoutElement layoutElement;
                if (!(child instanceof LayoutElement) || (layoutElement = (LayoutElement)child).m_252754_() >= mouseX || mouseX >= layoutElement.m_252754_() + layoutElement.m_5711_() || layoutElement.m_252907_() >= mouseY || mouseY >= layoutElement.m_252907_() + layoutElement.m_93694_()) continue;
                hasAny = true;
                if (this.hoveringWidget == layoutElement) continue;
                this.hoveringWidget = layoutElement;
                LayoutElement layoutElement2 = this.hoveringWidget;
                if (!(layoutElement2 instanceof HoverSoundPlayer) || (event = (hoverSoundPlayer = (HoverSoundPlayer)layoutElement2).getHoverSound()) == null) break;
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)hoverSoundPlayer.getHoverSound(), (float)1.0f));
                break;
            }
            if (!hasAny) {
                this.hoveringWidget = null;
            }
        }
        this.currentPage.render(guiGraphics, mouseX, mouseY, partialTicks);
    }

    public boolean m_6375_(double mouseX, double mouseY, int pButton) {
        if (super.m_6375_(mouseX, mouseY, pButton)) {
            return true;
        }
        float correctScale = this.nodeScale != -1 ? (float)this.nodeScale / (float)this.f_96541_.m_91268_().m_85449_() : 1.0f;
        int correctedMouseX = (int)((mouseX - (double)this.currentPage.pageLeft) / (double)correctScale);
        int correctedMouseY = (int)((mouseY - (double)this.currentPage.pageTop) / (double)correctScale);
        for (TreePage.NodeButton button : this.currentPage.treeNodes.values()) {
            if (!button.m_6375_(correctedMouseX, correctedMouseY, pButton)) continue;
            return true;
        }
        return false;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isDisableMouseDragging()) {
            return false;
        }
        if (!super.m_7979_(mouseX, mouseY, button, dragX, dragY)) {
            this.moveViewport((float)dragX, (float)dragY);
            return false;
        }
        return true;
    }

    public void moveViewport(float deltaX, float deltaY) {
        this.currentPage.pageLeft += deltaX;
        this.currentPage.pageTop += deltaY;
    }

    public boolean m_6050_(double x, double y, double wheel) {
        if (!super.m_6050_(x, y, wheel)) {
            if (wheel > 0.0) {
                this.scaleUp();
            } else {
                this.scaleDown();
            }
            return false;
        }
        return true;
    }

    private void setTreeIndex(int index) {
        this.currentPage = this.skillTreePages.get(index);
        this.relocateScaleButtons();
    }

    public boolean navigateTreePage(boolean isNextPage) {
        boolean canNavigate;
        int currentPageIndex = this.skillTreePages.entrySet().stream().filter(entry -> entry.getValue() == this.currentPage).map(Map.Entry::getKey).findFirst().orElse(-1);
        if (currentPageIndex == -1) {
            return false;
        }
        int newIndex = isNextPage ? currentPageIndex + 1 : currentPageIndex - 1;
        boolean bl = canNavigate = this.skillTreePages.containsKey(newIndex) && this.skillTreeButtons.get(newIndex).m_142518_();
        if (!canNavigate) {
            return false;
        }
        this.setTreeIndex(newIndex);
        this.skillTreeButtons.forEach((index, button) -> button.m_93692_(index == newIndex));
        return true;
    }

    public void scaleUp() {
        int maxScale;
        int nextScale = Math.min(6, (this.nodeScale == -1 ? (int)this.f_96541_.m_91268_().m_85449_() : this.nodeScale) + 1);
        if (nextScale <= (maxScale = this.f_96541_.m_91268_().m_85385_(0x7FFFFFFE, ((Boolean)this.f_96541_.f_91066_.m_231819_().m_231551_()).booleanValue()))) {
            this.nodeScale = nextScale;
        }
    }

    public void scaleDown() {
        this.nodeScale = Math.max(1, (this.nodeScale == -1 ? (int)this.f_96541_.m_91268_().m_85449_() : this.nodeScale) - 1);
    }

    @Override
    public boolean isBackgroundMode() {
        return this.backgroundMode;
    }

    @Override
    public void setBackgroundMode(boolean flag) {
        this.backgroundMode = flag;
    }

    public void setFocus(Skill skill) {
        TreePage.NodeButton nodeButton = this.currentPage.treeNodes.get(skill);
        if (nodeButton != null) {
            Vec2i pos = nodeButton.treeNode.nodeInfo().positionInScreen();
            this.currentPage.pageLeft = -pos.x + this.f_96543_ / 2;
            this.currentPage.pageTop = -pos.y + this.f_96544_ / 2;
        }
    }

    public void onSyncPacketArrived(ClientBoundSetAbilityPoints feedbackPacket) {
        if (feedbackPacket.success()) {
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)((SoundEvent)EpicSkillsSounds.GAIN_ABILITY_POINTS.get()), (float)1.0f, (float)1.0f));
            this.synclock = false;
        }
    }

    public ExpToAbilityPointConverstionButton getExpConversionButton() {
        return this.expConversionButton;
    }

    public boolean discarded() {
        return this.discarded;
    }

    public boolean isDisableMouseDragging() {
        return this.disableMouseDragging;
    }

    public void setDisableMouseDragging(boolean disableMouseDragging) {
        this.disableMouseDragging = disableMouseDragging;
    }

    public static void playSkillTreeDownSound(@NotNull SoundManager manager) {
        manager.m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)((SoundEvent)EpicSkillsSounds.HOVER.get()), (float)1.0f, (float)1.0f));
    }

    public void openSkillEditorScreen() {
        Objects.requireNonNull(this.f_96541_).m_91152_((Screen)new SkillEditScreen(this.player, this.playerSkills));
    }

    @OnlyIn(value=Dist.CLIENT)
    public class ExpToAbilityPointConverstionButton
    extends AbstractButton {
        private static final ResourceLocation EXPERIENCE_ORB_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/entity/experience_orb.png");
        private static final int MAX_HOVER_TICK = 6;
        private int hoverTickO;
        private int hoverTick;

        public ExpToAbilityPointConverstionButton(int pX, int pY, int pWidth, int pHeight) {
            super(pX, pY, pWidth, pHeight, (Component)Component.m_237119_());
        }

        public void tick() {
            this.f_93623_ = this.canConvert();
            this.hoverTickO = this.hoverTick;
            this.hoverTick = this.m_274382_() && this.f_93623_ ? Math.min(6, this.hoverTick + 1) : Math.max(0, this.hoverTick - 1);
        }

        protected void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            float delta = Mth.m_14179_((float)partialTick, (float)((float)this.hoverTickO / 6.0f), (float)((float)this.hoverTick / 6.0f));
            guiGraphics.m_280479_(EXPERIENCE_ORB_LOCATION, this.m_252754_(), this.m_252754_() + this.m_5711_(), this.m_252907_(), this.m_252907_() + this.m_93694_(), 0, 0.0f, 0.25f, 0.25f, 0.5f, 0.32f, 1.0f, 0.18f, 1.0f);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            guiGraphics.m_280479_(EXPERIENCE_ORB_LOCATION, this.m_252754_(), this.m_252754_() + this.m_5711_(), this.m_252907_(), this.m_252907_() + this.m_93694_(), 0, 0.0f, 0.25f, 0.5f, 0.75f, 0.67f, 1.0f, 0.0f, delta);
            RenderSystem.disableBlend();
        }

        public void m_5691_() {
            this.convert();
        }

        protected void m_168797_(NarrationElementOutput narrationElementOutput) {
            this.m_168802_(narrationElementOutput);
        }

        public void m_7435_(SoundManager handler) {
        }

        private boolean canConvert() {
            return SkillTreeScreen.this.player.f_36079_ >= SkillTreeScreen.this.playerAbilityPoints.getRequiredExp();
        }

        public void convert() {
            if (!this.m_142518_()) {
                return;
            }
            if (!SkillTreeScreen.this.synclock) {
                NetworkManager.sendToServer(new ServerBoundConvertAbilityPointRequest());
                SkillTreeScreen.this.synclock = true;
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class OpenSkillEditorButton
    extends AbstractButton {
        public OpenSkillEditorButton(int x, int y, int width, int height) {
            super(x, y, width, height, (Component)Component.m_237119_());
            this.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)EpicSkills.format("gui.%s.openskilleditor.tooltip"))));
        }

        protected void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            super.m_87963_(guiGraphics, mouseX, mouseY, partialTick);
            guiGraphics.m_280480_(((Item)EpicFightItems.SKILLBOOK.get()).m_7968_(), this.m_252754_() + 2, this.m_252907_() + 2);
        }

        protected void m_168797_(NarrationElementOutput narrationElementOutput) {
            this.m_168802_(narrationElementOutput);
        }

        public void m_5691_() {
            SkillTreeScreen.this.openSkillEditorScreen();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class ExperienceMeter
    extends AbstractWidget {
        private static final Component EXP_METER_TOOLTIP = Component.m_237115_((String)"gui.epicskills.exp_meter.tooltip");

        public ExperienceMeter(int x, int y) {
            super(x, y, 0, 9, (Component)Component.m_237119_());
            this.m_257544_(Tooltip.m_257550_((Component)EXP_METER_TOOLTIP));
        }

        protected void m_87963_(GuiGraphics pGuiGraphics, int mouseX, int mouseY, float pPartialTick) {
            String expState = String.format("%d / %d", SkillTreeScreen.this.player.f_36079_, SkillTreeScreen.this.playerAbilityPoints.getRequiredExp());
            this.f_93618_ = SkillTreeScreen.this.f_96547_.m_92895_(expState);
            pGuiGraphics.m_280488_(SkillTreeScreen.this.f_96547_, expState, this.m_252754_(), this.m_252907_(), -1);
        }

        protected void m_168797_(NarrationElementOutput pNarrationElementOutput) {
            this.m_168802_(pNarrationElementOutput);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class AbilityPointsMeter
    extends AbstractWidget {
        private static final ResourceLocation ABILITY_POINTS_ICON = ResourceLocation.fromNamespaceAndPath((String)"epicskills", (String)"textures/gui/widget/ability_points.png");
        private static final Component ABILITY_POINTS_TOOLTIP = Component.m_237115_((String)"gui.epicskills.abilitypoints.tooltip");

        public AbilityPointsMeter(int x, int y) {
            super(x, y, 0, 14, (Component)Component.m_237119_());
            this.m_257544_(Tooltip.m_257550_((Component)ABILITY_POINTS_TOOLTIP));
        }

        protected void m_87963_(GuiGraphics pGuiGraphics, int mouseX, int mouseY, float pPartialTick) {
            pGuiGraphics.m_280398_(ABILITY_POINTS_ICON, this.m_252754_(), this.m_252907_(), 0, 0.0f, 0.0f, 16, 16, 16, 16);
            String abilityPoints = String.valueOf(SkillTreeScreen.this.playerAbilityPoints.getAbilityPoints());
            this.f_93618_ = SkillTreeScreen.this.f_96547_.m_92895_(abilityPoints) + 24;
            pGuiGraphics.m_280488_(SkillTreeScreen.this.f_96547_, abilityPoints, this.m_252754_() + 24, this.m_252907_() + 4, -1);
        }

        protected void m_168797_(NarrationElementOutput pNarrationElementOutput) {
            this.m_168802_(pNarrationElementOutput);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class TreePage {
        private float pageLeft;
        private float pageTop;
        private final Map<Skill, NodeButton> treeNodes;
        private final Holder.Reference<SkillTree> skillTree;
        private final Component title;

        public TreePage(Map<Skill, SkillTreeProgression.TopDownTreeNode> nodesProgression, Holder.Reference<SkillTree> skillTree) {
            this.skillTree = skillTree;
            this.pageLeft = 44.0f;
            this.pageTop = 34.0f;
            this.title = Component.m_237115_((String)String.format("skill_tree.%s.%s", skillTree.m_205785_().m_135782_().m_135827_(), skillTree.m_205785_().m_135782_().m_135815_()));
            this.treeNodes = new LinkedHashMap<Skill, NodeButton>();
            nodesProgression.forEach((skill, topDownTreeNode) -> {
                NodeButton skillTreeNodeButton = new NodeButton((SkillTreeProgression.TopDownTreeNode)topDownTreeNode);
                this.treeNodes.put(topDownTreeNode.nodeInfo().skill(), skillTreeNodeButton);
                if (topDownTreeNode.nodeInfo().parents() != null) {
                    topDownTreeNode.nodeInfo().parents().forEach(parent -> {
                        if (this.treeNodes.containsKey(parent.parentSkill())) {
                            skillTreeNodeButton.parents.add((Pair<NodeButton, List<Vec2i>>)Pair.of((Object)((Object)this.treeNodes.get(parent.parentSkill())), parent.controlPoints()));
                        } else {
                            EpicFightMod.logAndStacktraceIfDevSide(Logger::error, (String)String.format("Can't add skill %s to skill tree: Can't find parent skill %s", topDownTreeNode.nodeInfo().skill(), parent.parentSkill()), IllegalArgumentException::new);
                        }
                    });
                }
            });
        }

        public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
            float correctScale;
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280588_(44, 34, SkillTreeScreen.this.f_96543_, SkillTreeScreen.this.f_96544_);
            guiGraphics.m_280168_().m_252880_(this.pageLeft, this.pageTop, 0.0f);
            float f = correctScale = SkillTreeScreen.this.nodeScale != -1 ? (float)SkillTreeScreen.this.nodeScale / (float)SkillTreeScreen.this.f_96541_.m_91268_().m_85449_() : 1.0f;
            if (SkillTreeScreen.this.nodeScale != -1) {
                guiGraphics.m_280168_().m_85841_(correctScale, correctScale, 1.0f);
            }
            RenderSystem.enableDepthTest();
            int correctedMouseX = (int)(((float)mouseX - this.pageLeft) / correctScale);
            int correctedMouseY = (int)(((float)mouseY - this.pageTop) / correctScale);
            for (NodeButton nodeButton : this.treeNodes.values()) {
                nodeButton.m_87963_(guiGraphics, correctedMouseX, correctedMouseY, partialTicks);
            }
            RenderSystem.disableDepthTest();
            guiGraphics.m_280618_();
            guiGraphics.m_280168_().m_85849_();
        }

        public Component getTitle() {
            return this.title;
        }

        @OnlyIn(value=Dist.CLIENT)
        public class NodeButton
        extends AbstractButton {
            private final SkillTreeProgression.TopDownTreeNode treeNode;
            private final List<Pair<NodeButton, List<Vec2i>>> parents;
            private final CategorySlotTexture categoryTexture;
            private final boolean importedNode;

            public NodeButton(SkillTreeProgression.TopDownTreeNode treeNode) {
                super(treeNode.nodeInfo().positionInScreen().x, treeNode.nodeInfo().positionInScreen().y, 32, 32, (Component)Component.m_237119_());
                this.parents = new ArrayList<Pair<NodeButton, List<Vec2i>>>();
                this.treeNode = treeNode;
                this.categoryTexture = (CategorySlotTexture)CategorySlotTexture.ENUM_MANAGER.get(treeNode.nodeInfo().skill().getCategory().toString());
                this.importedNode = treeNode.nodeInfo().importFrom() != null;
            }

            public Skill getSkill() {
                return this.treeNode.nodeInfo().skill();
            }

            protected boolean m_93680_(double pMouseX, double pMouseY) {
                double widthHalf = (double)this.f_93618_ / 2.0;
                double heightHalf = (double)this.f_93619_ / 2.0;
                return this.f_93623_ && this.f_93624_ && pMouseX >= (double)this.m_252754_() - widthHalf && pMouseY >= (double)this.m_252907_() - heightHalf && pMouseX < (double)this.m_252754_() + widthHalf && pMouseY < (double)this.m_252907_() + heightHalf;
            }

            public void m_5691_() {
                if (this.importedNode) {
                    SkillTreeScreen.this.setTreeIndex(SkillTreeScreen.this.skillTreeIndices.get(((SkillTreeProgression.ImportedNode)this.treeNode).getImportedTree()));
                    SkillTreeScreen.this.setFocus(this.treeNode.nodeInfo().skill());
                } else {
                    SkillTreeScreen.this.backgroundMode = true;
                    Minecraft.m_91087_().m_91152_((Screen)new SkillInfoScreen(SkillTreeScreen.this.player, TreePage.this.skillTree, this.treeNode, SkillTreeScreen.this));
                }
            }

            protected void m_168797_(NarrationElementOutput pNarrationElementOutput) {
                this.m_168802_(pNarrationElementOutput);
            }

            protected void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
                guiGraphics.m_280168_().m_85836_();
                guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 100.0f);
                ButtonStateTexture buttonTexture = ButtonStateTexture.STATE_MAPPING.get((Object)this.treeNode.nodeState());
                if (buttonTexture == ButtonStateTexture.ACQUIRED && SkillTreeScreen.this.playerSkills.isEquipping(this.getSkill())) {
                    buttonTexture = ButtonStateTexture.EQUIPPED;
                }
                ResourceLocation nodeTexture = ResourceLocation.fromNamespaceAndPath((String)"epicskills", (String)String.format("textures/gui/widget/node/%s/%s.png", ParseUtil.toLowerCase((String)this.treeNode.nodeInfo().skill().getCategory().toString()), ParseUtil.toLowerCase((String)buttonTexture.name())));
                if (this.importedNode) {
                    RenderSystem.enableBlend();
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.4f);
                }
                int widthHalf = this.f_93618_ / 2;
                int heightHalf = this.f_93619_ / 2;
                guiGraphics.m_280411_(nodeTexture, this.m_252754_() - widthHalf - this.categoryTexture.offsetX(), this.m_252907_() - heightHalf - this.categoryTexture.offsetY(), this.categoryTexture.texWidth(), this.categoryTexture.texHeight(), 0.0f, 0.0f, this.categoryTexture.texWidth(), this.categoryTexture.texHeight(), this.categoryTexture.texWidth(), this.categoryTexture.texHeight());
                guiGraphics.m_280479_(this.treeNode.nodeInfo().skill().getSkillTexture(), this.m_252754_() - widthHalf, this.m_252754_() + widthHalf, this.m_252907_() - heightHalf, this.m_252907_() + heightHalf, 0, 0.0f, 1.0f, 0.0f, 1.0f, (float)buttonTexture.r / 255.0f, (float)buttonTexture.g / 255.0f, (float)buttonTexture.b / 255.0f, 1.0f);
                if (buttonTexture == ButtonStateTexture.LOCKED && !this.treeNode.nodeInfo().noUnlockConditions()) {
                    guiGraphics.m_280479_(ResourceLocation.fromNamespaceAndPath((String)"epicskills", (String)"textures/gui/widget/locker.png"), this.m_252754_() - widthHalf, this.m_252754_() + widthHalf, this.m_252907_() - heightHalf, this.m_252907_() + heightHalf, 0, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
                }
                if (this.importedNode) {
                    RenderSystem.disableBlend();
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                }
                if (!SkillTreeScreen.this.backgroundMode && this.m_252754_() - widthHalf - 2 < mouseX && mouseX < this.m_252754_() + widthHalf && this.m_252907_() - heightHalf - 2 < mouseY && mouseY < this.m_252907_() + heightHalf) {
                    if (this.importedNode) {
                        SkillTreeScreen.this.m_257959_(List.of(this.treeNode.nodeInfo().skill().getDisplayName().m_7532_(), Component.m_237110_((String)"gui.epicskills.skill_tree.imported_node", (Object[])new Object[]{Component.m_237115_((String)SkillTree.toDescriptionId((ResourceKey<SkillTree>)((SkillTreeProgression.ImportedNode)this.treeNode).getImportedTree().m_205785_())).getString()}).m_7532_()));
                    } else {
                        ArrayList<FormattedCharSequence> lines = new ArrayList<FormattedCharSequence>();
                        lines.add(this.treeNode.nodeInfo().skill().getDisplayName().m_7532_());
                        if (buttonTexture == ButtonStateTexture.LOCKED && this.treeNode.nodeInfo().unlockTip() != null) {
                            lines.addAll(SkillTreeScreen.this.f_96547_.m_92923_((FormattedText)this.treeNode.nodeInfo().unlockTip(), SkillTreeScreen.this.f_96543_ / 2));
                        }
                        SkillTreeScreen.this.m_257959_(lines);
                    }
                }
                if (!(buttonTexture != ButtonStateTexture.LOCKED && buttonTexture != ButtonStateTexture.UNLOCKABLE || this.importedNode)) {
                    int markerX = this.m_252754_() + widthHalf - 7;
                    int markerY = this.m_252907_() + heightHalf - 8;
                    guiGraphics.m_280509_(markerX, markerY, markerX + 11, markerY + 12, -9934744);
                    guiGraphics.m_280509_(markerX + 1, markerY + 1, markerX + 10, markerY + 11, -16777216);
                    guiGraphics.m_280488_(SkillTreeScreen.this.f_96547_, String.valueOf(this.treeNode.nodeInfo().requiredAbilityPoints()), markerX + 3, markerY + 2, SkillTreeScreen.this.playerAbilityPoints.getAbilityPoints() >= this.treeNode.nodeInfo().requiredAbilityPoints() ? -1 : -65536);
                }
                guiGraphics.m_280168_().m_85849_();
                for (Pair<NodeButton, List<Vec2i>> parentTree : this.parents) {
                    boolean unlocked;
                    NodeButton parentButton = (NodeButton)((Object)parentTree.getFirst());
                    ArrayList<Vec2i> controlPoints = new ArrayList<Vec2i>();
                    controlPoints.add(new Vec2i(parentButton.m_252754_(), parentButton.m_252907_()));
                    if (parentTree.getSecond() == null || ((List)parentTree.getSecond()).isEmpty()) {
                        controlPoints.add(new Vec2i(this.m_252754_(), parentButton.m_252907_()));
                    } else {
                        controlPoints.addAll((Collection)parentTree.getSecond());
                    }
                    controlPoints.add(new Vec2i(this.m_252754_(), this.m_252907_()));
                    boolean bl = unlocked = ((NodeButton)((Object)parentTree.getFirst())).treeNode.nodeState() == SkillTreeProgression.NodeState.UNLOCKED;
                    if (unlocked) {
                        guiGraphics.m_280168_().m_85836_();
                        guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 1.0f);
                    }
                    for (int i = 0; i < controlPoints.size() - 1; ++i) {
                        Vec2i p1 = (Vec2i)controlPoints.get(i);
                        Vec2i p2 = (Vec2i)controlPoints.get(i + 1);
                        Tesselator tesselator = Tesselator.m_85913_();
                        BufferBuilder bufferBuilder = tesselator.m_85915_();
                        float xDiff = p2.x - p1.x;
                        float yDiff = p2.y - p1.y;
                        float length = Mth.m_14116_((float)(xDiff * xDiff + yDiff * yDiff));
                        bufferBuilder.m_166779_(VertexFormat.Mode.LINES, DefaultVertexFormat.f_166851_);
                        bufferBuilder.m_252986_(guiGraphics.m_280168_().m_85850_().m_252922_(), (float)p1.x + 0.5f, (float)p1.y + 0.5f, 0.0f).m_193479_(unlocked ? -2698555 : -16777216).m_5601_(xDiff /= length, yDiff /= length, 0.0f).m_5752_();
                        bufferBuilder.m_252986_(guiGraphics.m_280168_().m_85850_().m_252922_(), (float)p2.x + 0.5f, (float)p2.y + 0.5f, 0.0f).m_193479_(unlocked ? -2698555 : -16777216).m_5601_(xDiff, yDiff, 0.0f).m_5752_();
                        RenderSystem.disableCull();
                        if (SkillTreeScreen.this.nodeScale != -1) {
                            RenderSystem.lineWidth((float)((float)SkillTreeScreen.this.nodeScale * 2.0f));
                        } else {
                            RenderSystem.lineWidth((float)((float)SkillTreeScreen.this.f_96541_.m_91268_().m_85449_() * 2.0f));
                        }
                        RenderSystem.setShader(GameRenderer::m_172757_);
                        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
                        RenderSystem.enableCull();
                    }
                    if (!unlocked) continue;
                    guiGraphics.m_280168_().m_85849_();
                }
            }

            @OnlyIn(value=Dist.CLIENT)
            public static enum ButtonStateTexture {
                LOCKED(87, 87, 87),
                UNLOCKABLE(152, 152, 152),
                ACQUIRED(224, 218, 206),
                EQUIPPED(251, 252, 238);

                private static final Map<SkillTreeProgression.NodeState, ButtonStateTexture> STATE_MAPPING;
                private int r;
                private int g;
                private int b;

                private ButtonStateTexture(int r, int g, int b) {
                    this.r = r;
                    this.g = g;
                    this.b = b;
                }

                static {
                    STATE_MAPPING = ImmutableMap.of((Object)((Object)SkillTreeProgression.NodeState.LOCKED), (Object)((Object)LOCKED), (Object)((Object)SkillTreeProgression.NodeState.UNLOCKABLE), (Object)((Object)UNLOCKABLE), (Object)((Object)SkillTreeProgression.NodeState.UNLOCKED), (Object)((Object)ACQUIRED));
                }
            }

            @OnlyIn(value=Dist.CLIENT)
            public static enum CategorySlotTextures implements CategorySlotTexture
            {
                DODGE(3, 6, 38, 44),
                GUARD(3, 7, 38, 46),
                IDENTITY(6, 6, 44, 44),
                PASSIVE(3, 3, 38, 38),
                MOVER(5, 5, 42, 42);

                private int offsetX;
                private int offsetY;
                private int texWidth;
                private int texHeight;
                private int universalOrder;

                private CategorySlotTextures(int offsetX, int offsetY, int texWidth, int texHeight) {
                    this.offsetX = offsetX;
                    this.offsetY = offsetY;
                    this.texWidth = texWidth;
                    this.texHeight = texHeight;
                    this.universalOrder = CategorySlotTexture.ENUM_MANAGER.assign((ExtendableEnum)this);
                }

                @Override
                public int offsetX() {
                    return this.offsetX;
                }

                @Override
                public int offsetY() {
                    return this.offsetY;
                }

                @Override
                public int texWidth() {
                    return this.texWidth;
                }

                @Override
                public int texHeight() {
                    return this.texHeight;
                }

                public int universalOrdinal() {
                    return this.universalOrder;
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class TreeSelectButton
    extends Button
    implements HoverSoundPlayer {
        private static final ResourceLocation SKILL_MENU_BUTTON = ResourceLocation.fromNamespaceAndPath((String)"epicskills", (String)"textures/gui/widget/skill_tree_button.png");
        private final Holder.Reference<SkillTree> skillTree;

        protected TreeSelectButton(int treeIndex, Holder.Reference<SkillTree> skillTree) {
            super(4, 0, 32, 32, CommonComponents.f_237098_, button -> {
                if (com$yesman$epicskills$client$gui$screen$SkillTreeScreen$this.currentPage != com$yesman$epicskills$client$gui$screen$SkillTreeScreen$this.skillTreePages.get(treeIndex)) {
                    SkillTreeScreen.this.setTreeIndex(treeIndex);
                }
            }, Button.f_252438_);
            this.skillTree = skillTree;
        }

        public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            if (SkillTreeScreen.this.backgroundMode) {
                this.f_93622_ = false;
            }
            if (this.f_93623_) {
                this.m_280322_(guiGraphics, SKILL_MENU_BUTTON, this.m_252754_(), this.m_252907_(), 0, 0, 32, 32, 32, 64, 64);
            } else {
                guiGraphics.m_280163_(SKILL_MENU_BUTTON, this.m_252754_(), this.m_252907_(), 32.0f, 0.0f, 32, 32, 64, 64);
            }
            if (!this.f_93623_) {
                RenderSystem.setShaderColor((float)0.3f, (float)0.3f, (float)0.3f, (float)1.0f);
            }
            guiGraphics.m_280398_(SKILL_TREE_ICON_TEXTURES.apply(this.skillTree), this.m_252754_(), this.m_252907_(), 0, 0.0f, 0.0f, 32, 32, 32, 32);
            if (!this.f_93623_) {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }

        @Override
        public SoundEvent getHoverSound() {
            return this.f_93623_ ? (SoundEvent)EpicSkillsSounds.HOVER.get() : null;
        }

        public void m_7435_(@NotNull SoundManager pHandler) {
            SkillTreeScreen.playSkillTreeDownSound(pHandler);
        }
    }
}

