/*
 * Decompiled with CFR 0.152.
 */
package com.yesman.epicskills.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.yesman.epicskills.world.capability.AbilityPoints;
import java.util.Collection;
import java.util.function.Supplier;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.GameRules;

public class PlayerAbilityPointsCommand {
    private static final SimpleCommandExceptionType EXCEPTION_NO_PLAYERS_FOUND = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"commands.epicskills.failed.no_players"));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"abilitypoints").requires(commandSourceStack -> commandSourceStack.m_6761_(2))).then(Commands.m_82127_((String)"get").then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91466_()).executes(command -> {
            ServerPlayer player = EntityArgument.m_91474_((CommandContext)command, (String)"target");
            AbilityPoints abilityPoints = (AbilityPoints)player.getCapability(AbilityPoints.ABILITY_POINTS).orElse(null);
            if (abilityPoints != null) {
                ((CommandSourceStack)command.getSource()).m_288197_(() -> Component.m_237110_((String)"commands.epicskills.abilitypoints.value.get.success", (Object[])new Object[]{player.m_7755_(), String.valueOf(abilityPoints.getAbilityPoints())}), false);
                return abilityPoints.getAbilityPoints();
            }
            ((CommandSourceStack)command.getSource()).m_81352_((Component)Component.m_237115_((String)"commands.epicskills.abilitypoints.value.get.fail"));
            return 0;
        })))).then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"value", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(command -> PlayerAbilityPointsCommand.processAbilityPointValueSet((CommandContext<CommandSourceStack>)command, EntityArgument.m_91477_((CommandContext)command, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)command, (String)"value"), "set")))))).then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"value", (ArgumentType)IntegerArgumentType.integer()).executes(command -> PlayerAbilityPointsCommand.processAbilityPointValueSet((CommandContext<CommandSourceStack>)command, EntityArgument.m_91477_((CommandContext)command, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)command, (String)"value"), "add")))))).then(Commands.m_82127_((String)"reset_exp_require").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).executes(command -> PlayerAbilityPointsCommand.processExpReset((CommandContext<CommandSourceStack>)command, EntityArgument.m_91477_((CommandContext)command, (String)"targets"))))));
    }

    private static int processExpReset(CommandContext<CommandSourceStack> command, Collection<ServerPlayer> players) throws CommandSyntaxException {
        int done = 0;
        for (ServerPlayer player : players) {
            if (!PlayerAbilityPointsCommand.resetExpRequirement(player)) continue;
            ++done;
        }
        if (done == 0) {
            throw EXCEPTION_NO_PLAYERS_FOUND.create();
        }
        if (done == 1) {
            ((CommandSourceStack)command.getSource()).m_288197_(PlayerAbilityPointsCommand.wrap(Component.m_237110_((String)"commands.epicskills.abilitypoints.reset_exp_requirement.success.single", (Object[])new Object[]{players.iterator().next().m_5446_()})), true);
        } else {
            for (ServerPlayer serverplayer : players) {
                if (!((CommandSourceStack)command.getSource()).m_81372_().m_46469_().m_46207_(GameRules.f_46144_)) continue;
                serverplayer.m_213846_((Component)Component.m_237110_((String)"commands.epicskills.abilitypoints.reset_exp_requirement.success.other", (Object[])new Object[]{String.valueOf(done)}));
            }
            ((CommandSourceStack)command.getSource()).m_288197_(PlayerAbilityPointsCommand.wrap(Component.m_237110_((String)"commands.epicskills.abilitypoints.reset_exp_requirement.success.other", (Object[])new Object[]{String.valueOf(done)})), true);
        }
        return done;
    }

    private static int processAbilityPointValueSet(CommandContext<CommandSourceStack> command, Collection<ServerPlayer> players, int value, String operation) throws CommandSyntaxException {
        int done = 0;
        for (ServerPlayer player : players) {
            switch (operation) {
                case "set": {
                    if (!PlayerAbilityPointsCommand.setAbilityPoints(player, value)) break;
                    ++done;
                    break;
                }
                case "add": {
                    if (!PlayerAbilityPointsCommand.addAbilityPoints(player, value)) break;
                    ++done;
                }
            }
        }
        if (done == 0) {
            throw EXCEPTION_NO_PLAYERS_FOUND.create();
        }
        if (done == 1) {
            players.iterator().next().getCapability(AbilityPoints.ABILITY_POINTS).ifPresent(abilitypoints -> ((CommandSourceStack)command.getSource()).m_288197_(PlayerAbilityPointsCommand.wrap(Component.m_237110_((String)"commands.epicskills.abilitypoints.success.single", (Object[])new Object[]{((ServerPlayer)players.iterator().next()).m_5446_(), String.valueOf(abilitypoints.getAbilityPoints())})), true));
        } else {
            for (ServerPlayer serverplayer : players) {
                if (!((CommandSourceStack)command.getSource()).m_81372_().m_46469_().m_46207_(GameRules.f_46144_)) continue;
                serverplayer.m_213846_((Component)Component.m_237110_((String)"commands.epicskills.abilitypoints.success.other", (Object[])new Object[]{String.valueOf(done)}));
            }
            ((CommandSourceStack)command.getSource()).m_288197_(PlayerAbilityPointsCommand.wrap(Component.m_237110_((String)"commands.epicskills.abilitypoints.success.other", (Object[])new Object[]{String.valueOf(done)})), true);
        }
        return done;
    }

    private static boolean setAbilityPoints(ServerPlayer player, int value) {
        player.getCapability(AbilityPoints.ABILITY_POINTS).ifPresent(abilitypoints -> {
            abilitypoints.setAbilityPoints(value);
            abilitypoints.markDirty();
        });
        return player.getCapability(AbilityPoints.ABILITY_POINTS).isPresent();
    }

    private static boolean addAbilityPoints(ServerPlayer player, int value) {
        player.getCapability(AbilityPoints.ABILITY_POINTS).ifPresent(abilitypoints -> {
            abilitypoints.setAbilityPoints(abilitypoints.getAbilityPoints() + value);
            abilitypoints.markDirty();
        });
        return player.getCapability(AbilityPoints.ABILITY_POINTS).isPresent();
    }

    public static boolean resetExpRequirement(ServerPlayer player) {
        player.getCapability(AbilityPoints.ABILITY_POINTS).ifPresent(abilitypoints -> {
            abilitypoints.setRequiredExp(7);
            abilitypoints.markDirty();
        });
        return player.getCapability(AbilityPoints.ABILITY_POINTS).isPresent();
    }

    private static <T> Supplier<T> wrap(T value) {
        return () -> value;
    }
}

