/*
 * Decompiled with CFR 0.152.
 */
package com.yesman.epicskills.world.capability;

import com.mojang.datafixers.util.Pair;
import com.yesman.epicskills.EpicSkills;
import com.yesman.epicskills.client.gui.components.toasts.SkillTreeNodeToast;
import com.yesman.epicskills.client.gui.components.toasts.SkillTreeToast;
import com.yesman.epicskills.client.gui.screen.SkillInfoScreen;
import com.yesman.epicskills.network.NetworkManager;
import com.yesman.epicskills.network.client.ClientBoundSetTreeState;
import com.yesman.epicskills.network.client.ClientBoundUnlockNode;
import com.yesman.epicskills.skilltree.SkillTree;
import com.yesman.epicskills.skilltree.SkillTreeEntry;
import com.yesman.epicskills.world.capability.AbilityPoints;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yesman.epicfight.api.data.reloader.SkillManager;
import yesman.epicfight.api.utils.ParseUtil;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;

public class SkillTreeProgression {
    public static final Capability<SkillTreeProgression> SKILL_TREE_PROGRESSION = CapabilityManager.get((CapabilityToken)new CapabilityToken<SkillTreeProgression>(){});
    private final RegistryAccess registryAccess;
    private final Map<Holder.Reference<SkillTree>, TreeState> treeStates = new HashMap<Holder.Reference<SkillTree>, TreeState>();
    private final Map<Holder.Reference<SkillTree>, Map<Skill, TopDownTreeNode>> nodes = new HashMap<Holder.Reference<SkillTree>, Map<Skill, TopDownTreeNode>>();
    private final Map<Holder.Reference<SkillTree>, Map<Skill, TopDownTreeNode>> rootNodes = new HashMap<Holder.Reference<SkillTree>, Map<Skill, TopDownTreeNode>>();
    private final List<Pair<Holder.Reference<SkillTree>, TopDownTreeNode>> unlockAwaitingNodes = new LinkedList<Pair<Holder.Reference<SkillTree>, TopDownTreeNode>>();
    private final Player player;
    private static final ResourceLocation SKILL_TREE_PROGRESSION_CAPABILITY_KEY = ResourceLocation.fromNamespaceAndPath((String)"epicskills", (String)"skill_tree_progression");

    public SkillTreeProgression(RegistryAccess registryAccess, Player player) {
        this.registryAccess = registryAccess;
        this.player = player;
        this.reload(false);
    }

    public void reload(boolean readOldData) {
        CompoundTag compound = null;
        if (readOldData) {
            compound = new CompoundTag();
            this.serializeTo(compound);
        }
        this.treeStates.clear();
        this.nodes.clear();
        this.rootNodes.clear();
        this.unlockAwaitingNodes.clear();
        HolderLookup.RegistryLookup skillTreeRegistry = this.registryAccess.m_255025_(SkillTree.SKILL_TREE_REGISTRY_KEY);
        skillTreeRegistry.m_214062_().forEach(skillTree -> {
            this.treeStates.put((Holder.Reference<SkillTree>)skillTree, ((SkillTree)skillTree.get()).locked() ? TreeState.LOCKED : TreeState.UNLOCKED);
            this.nodes.put((Holder.Reference<SkillTree>)skillTree, new LinkedHashMap());
            this.rootNodes.put((Holder.Reference<SkillTree>)skillTree, new HashMap());
        });
        ArrayList importedNodes = new ArrayList();
        this.registryAccess.m_175515_(SkillTreeEntry.SKILL_TREE_ENTRY_REGISTRY_KEY).m_203611_().sorted((h1, h2) -> SkillTreeEntry.comparator((SkillTreeEntry)h1.get(), (SkillTreeEntry)h2.get())).forEach(arg_0 -> this.lambda$reload$4((HolderLookup)skillTreeRegistry, importedNodes, arg_0));
        importedNodes.forEach(importedNode -> {
            if (!this.nodes.containsKey(importedNode.getImportedTree())) {
                EpicSkills.LOGGER.warn("No skill tree page: " + importedNode.getImportedTree());
                return;
            }
            Map<Skill, TopDownTreeNode> pageNodes = this.nodes.get(importedNode.getImportedTree());
            if (!pageNodes.containsKey(importedNode.nodeInfo().skill())) {
                EpicSkills.LOGGER.warn("No skill " + importedNode.nodeInfo().skill() + " in skill tree page: " + importedNode.getImportedTree());
                return;
            }
            TopDownTreeNode importedOriginalNode = pageNodes.get(importedNode.nodeInfo().skill());
            importedOriginalNode.children().addAll(importedNode.children());
            importedNode.children().forEach(importedNodeChild -> importedNodeChild.parents().add(importedOriginalNode));
        });
        if (readOldData) {
            this.deserializeFrom(compound);
        }
    }

    public void tick() {
        if (this.player.m_9236_().m_5776_()) {
            return;
        }
        ServerPlayer serverplayer = (ServerPlayer)this.player;
        this.treeStates.forEach((tree, state) -> {
            if (state == TreeState.LOCKED && !((SkillTree)tree.get()).noUnlcokConditions() && ((SkillTree)tree.get()).conditions().m_36611_(serverplayer, (Entity)serverplayer)) {
                this.treeStates.put((Holder.Reference<SkillTree>)tree, TreeState.UNLOCKED);
                NetworkManager.sendToPlayer(new ClientBoundSetTreeState((ResourceKey<SkillTree>)tree.m_205785_(), TreeState.UNLOCKED, false), serverplayer);
            }
        });
        this.unlockAwaitingNodes.removeIf(pair -> {
            boolean meets = ((TopDownTreeNode)pair.getSecond()).nodeInfo().unlockCondition().m_36611_(serverplayer, (Entity)serverplayer);
            if (meets) {
                ((TopDownTreeNode)pair.getSecond()).setNodeState(NodeState.UNLOCKABLE, true, false);
                NetworkManager.sendToPlayer(new ClientBoundUnlockNode((ResourceKey<SkillTree>)((Holder.Reference)pair.getFirst()).m_205785_(), ((TopDownTreeNode)pair.getSecond()).nodeInfo().skill(), NodeState.UNLOCKABLE, true, false, false, false), serverplayer);
            }
            return meets;
        });
    }

    public void unlockTree(Holder.Reference<SkillTree> skillTree) {
        this.treeStates.put(skillTree, TreeState.UNLOCKED);
        if (!this.player.m_9236_().m_5776_()) {
            NetworkManager.sendToPlayer(new ClientBoundSetTreeState((ResourceKey<SkillTree>)skillTree.m_205785_(), TreeState.UNLOCKED, true), (ServerPlayer)this.player);
        }
    }

    public boolean canLockTree(Holder.Reference<SkillTree> skillTree) {
        boolean anyUnlocked = false;
        for (TopDownTreeNode node : this.rootNodes.get(skillTree).values()) {
            anyUnlocked |= node.nodeState() == NodeState.UNLOCKED;
        }
        return !anyUnlocked;
    }

    public void lockTree(Holder.Reference<SkillTree> skillTree, boolean unequip) {
        this.treeStates.put(skillTree, TreeState.LOCKED);
        this.rootNodes.get(skillTree).values().forEach(node -> this.lockNode(skillTree, node.nodeInfo.skill(), unequip));
        if (!this.player.m_9236_().m_5776_()) {
            NetworkManager.sendToPlayer(new ClientBoundSetTreeState((ResourceKey<SkillTree>)skillTree.m_205785_(), TreeState.LOCKED, unequip), (ServerPlayer)this.player);
        }
    }

    public boolean canUnlockNode(Holder.Reference<SkillTree> skillTree, Skill skill, AbilityPoints abilityPoints, boolean consume) {
        if (this.treeStates.get(skillTree) != TreeState.UNLOCKED) {
            return false;
        }
        Map<Skill, TopDownTreeNode> treeNodes = this.nodes.get(skillTree);
        if (treeNodes != null) {
            boolean hasEnoughAP;
            TopDownTreeNode treeNode = treeNodes.get(skill);
            if (treeNode.nodeState() != NodeState.UNLOCKABLE) {
                return treeNode.nodeState() == NodeState.UNLOCKED;
            }
            boolean bl = hasEnoughAP = abilityPoints.getAbilityPoints() >= treeNode.nodeInfo().requiredAbilityPoints();
            if (hasEnoughAP && consume) {
                abilityPoints.setAbilityPoints(abilityPoints.getAbilityPoints() - treeNode.nodeInfo().requiredAbilityPoints());
            }
            abilityPoints.markDirty();
            return hasEnoughAP;
        }
        return false;
    }

    public void unlockNode(Holder.Reference<SkillTree> skillTree, Skill skill) {
        Map<Skill, TopDownTreeNode> nodes = this.nodes.get(skillTree);
        TopDownTreeNode node = nodes.get(skill);
        node.setNodeState(NodeState.UNLOCKED, true, false);
    }

    public boolean canLockNode(Holder.Reference<SkillTree> skillTree, Skill skill) {
        if (this.treeStates.get(skillTree) != TreeState.UNLOCKED) {
            return false;
        }
        Map<Skill, TopDownTreeNode> treeNodes = this.nodes.get(skillTree);
        if (treeNodes != null) {
            TopDownTreeNode treeNode = treeNodes.get(skill);
            if (treeNode.nodeState() == NodeState.LOCKED) {
                return false;
            }
            boolean childAllLocked = true;
            for (TopDownTreeNode childNode : treeNode.children) {
                childAllLocked &= childNode.nodeState() == NodeState.LOCKED || childNode.nodeState() == NodeState.UNLOCKABLE;
            }
            return childAllLocked;
        }
        return false;
    }

    public void lockNode(Holder.Reference<SkillTree> skillTree, Skill skill, boolean unequip) {
        Map<Skill, TopDownTreeNode> nodes = this.nodes.get(skillTree);
        TopDownTreeNode node = nodes.get(skill);
        node.setNodeState(NodeState.LOCKED, true, unequip);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void processSyncPacket(ClientBoundSetTreeState packet) {
        Registry registry = this.registryAccess.m_175515_(SkillTree.SKILL_TREE_REGISTRY_KEY);
        Holder.Reference skillTree = registry.m_246971_(packet.skillTree());
        if (this.treeStates.get(skillTree) == TreeState.LOCKED && packet.treeState() == TreeState.UNLOCKED) {
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12496_, (float)1.0f));
            Minecraft.m_91087_().m_91300_().m_94922_((Toast)new SkillTreeToast((Holder.Reference<SkillTree>)skillTree));
        } else if (this.treeStates.get(skillTree) == TreeState.UNLOCKED && packet.treeState() == TreeState.LOCKED) {
            this.rootNodes.get(skillTree).values().forEach(node -> this.lockNode((Holder.Reference<SkillTree>)skillTree, node.nodeInfo.skill(), packet.unequip()));
        }
        this.treeStates.put((Holder.Reference<SkillTree>)skillTree, packet.treeState());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void processSyncPacket(ClientBoundUnlockNode packet) {
        Screen screen;
        Registry registry = this.registryAccess.m_175515_(SkillTree.SKILL_TREE_REGISTRY_KEY);
        Holder.Reference skillTree = registry.m_246971_(packet.skillTree());
        Map<Skill, TopDownTreeNode> nodes = this.nodes.get(skillTree);
        TopDownTreeNode node = nodes.get(packet.skill());
        node.setNodeState(packet.nodeState(), true, packet.unequip());
        if (packet.nodeState() == NodeState.UNLOCKED && packet.unlockAlarm()) {
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12496_, (float)1.0f));
            Minecraft.m_91087_().m_91300_().m_94922_((Toast)new SkillTreeNodeToast(packet.skill()));
        }
        if ((screen = Minecraft.m_91087_().f_91080_) instanceof SkillInfoScreen) {
            SkillInfoScreen skillInfoScreen = (SkillInfoScreen)screen;
            skillInfoScreen.onSyncPacketArrived(packet);
        }
    }

    public TreeState getTreeState(Holder.Reference<SkillTree> skillTree) {
        return this.treeStates.get(skillTree);
    }

    public NodeState getNodeState(Holder.Reference<SkillTree> skillTree, Skill skill) {
        Map<Skill, TopDownTreeNode> treeNodes = this.nodes.get(skillTree);
        if (!treeNodes.containsKey(skill)) {
            throw new NoSuchElementException("The skill " + skill + " doesn't exist in the skill tree " + skillTree.m_205785_().m_135782_());
        }
        return treeNodes.get(skill).nodeState();
    }

    public Map<Skill, TopDownTreeNode> getNodes(Holder<SkillTree> skillTree) {
        return this.nodes.get(skillTree);
    }

    public boolean canLockTree(ResourceKey<SkillTree> skillTreeId) {
        Holder.Reference holder = this.player.m_9236_().m_246945_(SkillTree.SKILL_TREE_REGISTRY_KEY).m_255043_(skillTreeId);
        return this.canLockTree((Holder.Reference<SkillTree>)holder);
    }

    public boolean canUnlockNode(ResourceKey<SkillTree> skillTreeId, Skill skill, AbilityPoints abilityPoints, boolean consume) {
        Holder.Reference holder = this.player.m_9236_().m_246945_(SkillTree.SKILL_TREE_REGISTRY_KEY).m_255043_(skillTreeId);
        return this.canUnlockNode((Holder.Reference<SkillTree>)holder, skill, abilityPoints, consume);
    }

    public boolean canLockNode(ResourceKey<SkillTree> skillTreeId, Skill skill) {
        Holder.Reference holder = this.player.m_9236_().m_246945_(SkillTree.SKILL_TREE_REGISTRY_KEY).m_255043_(skillTreeId);
        return this.canLockNode((Holder.Reference<SkillTree>)holder, skill);
    }

    public void unlockTree(ResourceKey<SkillTree> skillTreeId, ServerPlayer serverplayer) throws IllegalStateException {
        Holder.Reference holder = serverplayer.m_9236_().m_246945_(SkillTree.SKILL_TREE_REGISTRY_KEY).m_255043_(skillTreeId);
        this.unlockTree((Holder.Reference<SkillTree>)holder);
    }

    public void lockTree(ResourceKey<SkillTree> skillTreeId, boolean unequip, ServerPlayer serverplayer) throws IllegalStateException {
        Holder.Reference holder = serverplayer.m_9236_().m_246945_(SkillTree.SKILL_TREE_REGISTRY_KEY).m_255043_(skillTreeId);
        this.lockTree((Holder.Reference<SkillTree>)holder, unequip);
    }

    public void unlockNode(ResourceKey<SkillTree> skillTreeId, Skill skill, ServerPlayer serverplayer) throws IllegalStateException {
        Holder.Reference holder = serverplayer.m_9236_().m_246945_(SkillTree.SKILL_TREE_REGISTRY_KEY).m_255043_(skillTreeId);
        this.unlockNode((Holder.Reference<SkillTree>)holder, skill);
        NetworkManager.sendToPlayer(new ClientBoundUnlockNode(skillTreeId, skill, NodeState.UNLOCKED, false, false, false, false), serverplayer);
    }

    public void lockNode(ResourceKey<SkillTree> skillTreeId, Skill skill, boolean unequip, ServerPlayer serverplayer) throws IllegalStateException {
        Holder.Reference holder = serverplayer.m_9236_().m_246945_(SkillTree.SKILL_TREE_REGISTRY_KEY).m_255043_(skillTreeId);
        this.lockNode((Holder.Reference<SkillTree>)holder, skill, unequip);
        NetworkManager.sendToPlayer(new ClientBoundUnlockNode(skillTreeId, skill, NodeState.LOCKED, false, unequip, false, false), serverplayer);
    }

    public static void addNodesRecursively(TopDownTreeNode topDownNode, ListTag listTag) {
        CompoundTag compound = new CompoundTag();
        compound.m_128359_("name", topDownNode.nodeInfo().skill().getRegistryName().toString());
        compound.m_128359_("state", ParseUtil.toLowerCase((String)topDownNode.nodeState().name()));
        ListTag children = new ListTag();
        topDownNode.children().forEach(childNode -> {
            if (topDownNode.belongedSkillTree.equals(childNode.belongedSkillTree)) {
                SkillTreeProgression.addNodesRecursively(childNode, children);
            }
        });
        if (!children.isEmpty()) {
            compound.m_128365_("children", (Tag)children);
        }
        listTag.add((Object)compound);
    }

    public void deserializeRecursively(Holder.Reference<SkillTree> skilltree, Skill skill, TopDownTreeNode node, CompoundTag nodeCompound, boolean root) {
        NodeState treeState;
        if (!node.nodeInfo().skill().equals(skill)) {
            return;
        }
        try {
            treeState = NodeState.valueOf(ParseUtil.toUpperCase((String)nodeCompound.m_128461_("state")));
        }
        catch (IllegalArgumentException e) {
            return;
        }
        node.setNodeState(treeState, false, false);
        if (treeState == NodeState.LOCKED) {
            boolean parentAllUnlocked = true;
            if (!node.parents().isEmpty()) {
                for (TopDownTreeNode parentNode : node.parents()) {
                    parentAllUnlocked &= parentNode.nodeState() == NodeState.UNLOCKED;
                }
            }
            if (parentAllUnlocked && node.nodeInfo().unlockCondition() != null && !node.nodeInfo().hasCustomUnlockCondition()) {
                this.unlockAwaitingNodes.add((Pair<Holder.Reference<SkillTree>, TopDownTreeNode>)Pair.of(node.belongedSkillTree, (Object)node));
            }
        }
        ListTag children = nodeCompound.m_128437_("children", 10);
        if (!node.children().isEmpty() && !children.isEmpty()) {
            node.children().forEach(childNode -> {
                for (Tag tag : children) {
                    CompoundTag childCompound = (CompoundTag)tag;
                    Skill childSkill = SkillManager.getSkill((String)childCompound.m_128461_("name"));
                    if (!childNode.nodeInfo().skill().equals(childSkill)) continue;
                    this.deserializeRecursively(skilltree, childSkill, (TopDownTreeNode)childNode, childCompound, false);
                    break;
                }
            });
        }
    }

    public void serializeTo(CompoundTag compound) {
        for (Map.Entry<Holder.Reference<SkillTree>, TreeState> entry : this.treeStates.entrySet()) {
            CompoundTag treeCompound = new CompoundTag();
            treeCompound.m_128359_("state", ParseUtil.toLowerCase((String)entry.getValue().name()));
            compound.m_128365_(entry.getKey().m_205785_().m_135782_().toString(), (Tag)treeCompound);
            Collection<TopDownTreeNode> rootNodes = this.rootNodes.get(entry.getKey()).values();
            ListTag children = new ListTag();
            rootNodes.forEach(rootNode -> SkillTreeProgression.addNodesRecursively(rootNode, children));
            treeCompound.m_128365_("nodes", (Tag)children);
        }
    }

    public void deserializeFrom(CompoundTag compound) {
        HolderLookup.RegistryLookup holderLookup = this.registryAccess.m_255025_(SkillTree.SKILL_TREE_REGISTRY_KEY);
        for (String treeId : compound.m_128431_()) {
            Holder.Reference skilltree = holderLookup.m_254902_(ResourceKey.m_135785_(SkillTree.SKILL_TREE_REGISTRY_KEY, (ResourceLocation)ResourceLocation.parse((String)treeId))).orElse(null);
            if (skilltree == null) {
                EpicSkills.LOGGER.warn("Unknown skill tree id " + treeId);
                continue;
            }
            CompoundTag treeCompound = compound.m_128469_(treeId);
            if (treeCompound.m_128425_("state", 8)) {
                try {
                    TreeState treeState = TreeState.valueOf(ParseUtil.toUpperCase((String)treeCompound.m_128461_("state")));
                    this.treeStates.put((Holder.Reference<SkillTree>)skilltree, treeState);
                }
                catch (IllegalArgumentException treeState) {
                    // empty catch block
                }
            }
            if (!treeCompound.m_128425_("nodes", 9)) continue;
            ListTag unlockedSkills = treeCompound.m_128437_("nodes", 10);
            unlockedSkills.forEach(nodeTag -> {
                Map<Skill, TopDownTreeNode> treeRootNodes = this.rootNodes.get(skilltree);
                CompoundTag nodeCompound = (CompoundTag)nodeTag;
                Skill skill = SkillManager.getSkill((String)nodeCompound.m_128461_("name"));
                if (skill == null) {
                    EpicSkills.LOGGER.warn("Skill tree deserialization failed: Unknown root skill id: " + nodeCompound.m_128461_("name"));
                    return;
                }
                if (treeRootNodes.containsKey(skill)) {
                    this.deserializeRecursively((Holder.Reference<SkillTree>)skilltree, skill, treeRootNodes.get(skill), nodeCompound, true);
                }
            });
        }
    }

    public static void epicskills$attachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (((Entity)event.getObject()).m_6095_() == EntityType.f_20532_ && !event.getCapabilities().containsKey(SKILL_TREE_PROGRESSION_CAPABILITY_KEY)) {
            event.addCapability(SKILL_TREE_PROGRESSION_CAPABILITY_KEY, (ICapabilityProvider)new Provider(new SkillTreeProgression(((Entity)event.getObject()).m_9236_().m_9598_(), (Player)event.getObject())));
        }
    }

    private /* synthetic */ void lambda$reload$4(HolderLookup skillTreeRegistry, List importedNodes, Holder.Reference skillTreeEntryHolder) {
        Holder.Reference skillTree = skillTreeRegistry.m_254902_(ResourceKey.m_135785_(SkillTree.SKILL_TREE_REGISTRY_KEY, (ResourceLocation)skillTreeEntryHolder.m_205785_().m_135782_())).orElse(null);
        if (skillTree == null) {
            EpicSkills.LOGGER.warn("Unknown skill tree id: " + skillTreeEntryHolder.m_205785_().m_135782_());
            return;
        }
        if (((SkillTree)skillTree.get()).disabled()) {
            EpicSkills.LOGGER.info(skillTreeEntryHolder.m_205785_().m_135782_() + " is disabled.");
            return;
        }
        Map<Skill, TopDownTreeNode> nodesBySkill = this.nodes.get(skillTree);
        ((SkillTreeEntry)skillTreeEntryHolder.get()).nodes().forEach(treeNode -> {
            TopDownTreeNode node;
            if (!treeNode.skill().getCategory().learnable()) {
                EpicSkills.LOGGER.warn("Skill doesn't belong to a learnable skill category!" + treeNode.skill() + " in " + skillTree.m_205785_().m_135782_() + ". ignored.");
                return;
            }
            if (nodesBySkill.containsKey(treeNode.skill())) {
                EpicSkills.LOGGER.warn("Duplicated skill declaration! " + treeNode.skill() + " in " + skillTree.m_205785_().m_135782_() + ". ignored.");
                return;
            }
            if (treeNode.importFrom() != null) {
                ImportedNode importedNode = new ImportedNode((Holder.Reference<SkillTree>)skillTree, (SkillTreeEntry.Node)treeNode);
                importedNodes.add(importedNode);
                node = importedNode;
            } else {
                node = new CommonTreeNode((Holder.Reference<SkillTree>)skillTree, (SkillTreeEntry.Node)treeNode);
            }
            if (treeNode.parents() != null) {
                treeNode.parents().forEach(parentLink -> {
                    if (nodesBySkill.containsKey(parentLink.parentSkill())) {
                        TopDownTreeNode parentNode = (TopDownTreeNode)nodesBySkill.get(parentLink.parentSkill());
                        parentNode.children().add(node);
                        node.parents().add(parentNode);
                    } else {
                        EpicSkills.LOGGER.warn("Can't find parent skill " + parentLink.parentSkill() + " in " + skillTree.m_205785_().m_135782_() + ". ignored.");
                    }
                });
            } else {
                if (node.nodeInfo.noUnlockConditions()) {
                    node.setNodeState(NodeState.UNLOCKABLE, false, false);
                }
                this.rootNodes.get(skillTree).put(treeNode.skill(), node);
            }
            nodesBySkill.put(treeNode.skill(), node);
        });
    }

    public static enum TreeState {
        LOCKED,
        UNLOCKED;

    }

    public abstract class TopDownTreeNode {
        protected final Holder.Reference<SkillTree> belongedSkillTree;
        protected final List<TopDownTreeNode> parent = new ArrayList<TopDownTreeNode>();
        protected final List<TopDownTreeNode> children = new ArrayList<TopDownTreeNode>();
        protected final SkillTreeEntry.Node nodeInfo;

        public TopDownTreeNode(Holder.Reference<SkillTree> belongedSkillTree, SkillTreeEntry.Node nodeInfo) {
            this.belongedSkillTree = belongedSkillTree;
            this.nodeInfo = nodeInfo;
        }

        public List<TopDownTreeNode> parents() {
            return this.parent;
        }

        public List<TopDownTreeNode> children() {
            return this.children;
        }

        public SkillTreeEntry.Node nodeInfo() {
            return this.nodeInfo;
        }

        public abstract boolean isImported();

        public abstract NodeState nodeState();

        protected abstract void setNodeState(NodeState var1, boolean var2, boolean var3);
    }

    public static enum NodeState {
        LOCKED((Component)Component.m_237115_((String)"gui.epicskills.skillinfo.locked")),
        UNLOCKABLE((Component)Component.m_237115_((String)"gui.epicskills.skillinfo.unlock")),
        UNLOCKED((Component)Component.m_237115_((String)"gui.epicskills.skillinfo.equip"));

        Component displayOnButton;

        private NodeState(Component displayOnButton) {
            this.displayOnButton = displayOnButton;
        }

        public Component displayedOnButton() {
            return this.displayOnButton;
        }
    }

    public static class Provider
    implements ICapabilityProvider,
    ICapabilitySerializable<CompoundTag> {
        private final LazyOptional<SkillTreeProgression> lazyOptional = LazyOptional.of(() -> skillTreeProgression);
        private final SkillTreeProgression skillTreeProgression;

        public Provider(@NonNull SkillTreeProgression skillTreeProgression) {
            this.skillTreeProgression = skillTreeProgression;
        }

        public CompoundTag serializeNBT() {
            CompoundTag compound = new CompoundTag();
            this.skillTreeProgression.serializeTo(compound);
            return compound;
        }

        public void deserializeNBT(CompoundTag compound) {
            this.skillTreeProgression.deserializeFrom(compound);
        }

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
            return cap == SKILL_TREE_PROGRESSION ? this.lazyOptional.cast() : LazyOptional.empty();
        }
    }

    public class ImportedNode
    extends TopDownTreeNode {
        private final Holder.Reference<SkillTree> importedFrom;

        public ImportedNode(Holder.Reference<SkillTree> belongedSkillTree, SkillTreeEntry.Node nodeInfo) {
            super(belongedSkillTree, nodeInfo);
            this.importedFrom = SkillTreeProgression.this.registryAccess.m_255025_(SkillTree.SKILL_TREE_REGISTRY_KEY).m_255043_(ResourceKey.m_135785_(SkillTree.SKILL_TREE_REGISTRY_KEY, (ResourceLocation)nodeInfo.importFrom()));
        }

        @Override
        public boolean isImported() {
            return true;
        }

        public Holder.Reference<SkillTree> getImportedTree() {
            return this.importedFrom;
        }

        @Override
        public NodeState nodeState() {
            return SkillTreeProgression.this.getNodeState(this.importedFrom, this.nodeInfo().skill());
        }

        @Override
        public void setNodeState(NodeState nodeState, boolean propagateChildState, boolean modifyEquip) {
        }
    }

    public class CommonTreeNode
    extends TopDownTreeNode {
        private NodeState nodeState;

        public CommonTreeNode(Holder.Reference<SkillTree> belongedSkillTree, SkillTreeEntry.Node nodeInfo) {
            super(belongedSkillTree, nodeInfo);
            this.nodeState = NodeState.LOCKED;
        }

        @Override
        public boolean isImported() {
            return false;
        }

        @Override
        public void setNodeState(NodeState nodeState, boolean propagateState, boolean modifyEquip) {
            if (nodeState == this.nodeState) {
                return;
            }
            if (propagateState && nodeState == NodeState.UNLOCKED) {
                this.parents().forEach(parentNode -> {
                    if (parentNode.nodeState() == NodeState.UNLOCKABLE || parentNode.nodeState() == NodeState.LOCKED) {
                        parentNode.setNodeState(NodeState.UNLOCKED, true, modifyEquip);
                    }
                });
            }
            if (nodeState == NodeState.LOCKED) {
                boolean parentAllUnlocked = true;
                if (!this.parents().isEmpty()) {
                    for (TopDownTreeNode parentNode2 : this.parents()) {
                        parentAllUnlocked &= parentNode2.nodeState() == NodeState.UNLOCKED;
                    }
                }
                if (parentAllUnlocked) {
                    if (this.nodeInfo().noUnlockConditions()) {
                        this.nodeState = NodeState.UNLOCKABLE;
                    } else {
                        this.nodeState = NodeState.LOCKED;
                        SkillTreeProgression.this.unlockAwaitingNodes.add((Pair<Holder.Reference<SkillTree>, TopDownTreeNode>)Pair.of((Object)this.belongedSkillTree, (Object)this));
                    }
                } else {
                    this.nodeState = NodeState.LOCKED;
                }
                if (modifyEquip) {
                    EpicFightCapabilities.getParameterizedEntityPatch((Entity)SkillTreeProgression.this.player, Player.class, PlayerPatch.class).ifPresent(playerptach -> playerptach.getSkillContainerFor(this.nodeInfo().skill()).ifPresent(container -> container.setSkill(null)));
                }
            } else {
                this.nodeState = nodeState;
            }
            if (propagateState) {
                switch (nodeState) {
                    case LOCKED: {
                        this.children().forEach(childNode -> {
                            boolean parentAllUnlocked = true;
                            if (!childNode.parents().isEmpty()) {
                                for (TopDownTreeNode parentNode : childNode.parents()) {
                                    parentAllUnlocked &= parentNode.nodeState() == NodeState.UNLOCKED;
                                }
                            }
                            if (parentAllUnlocked) {
                                if (childNode.nodeInfo().noUnlockConditions()) {
                                    childNode.setNodeState(NodeState.UNLOCKABLE, true, modifyEquip);
                                } else {
                                    childNode.setNodeState(NodeState.LOCKED, true, modifyEquip);
                                    SkillTreeProgression.this.unlockAwaitingNodes.add((Pair<Holder.Reference<SkillTree>, TopDownTreeNode>)Pair.of(childNode.belongedSkillTree, (Object)childNode));
                                }
                            } else {
                                childNode.setNodeState(NodeState.LOCKED, true, modifyEquip);
                            }
                        });
                        break;
                    }
                    case UNLOCKED: {
                        this.children().forEach(childNode -> {
                            boolean parentAllUnlocked = true;
                            if (!childNode.parents().isEmpty()) {
                                for (TopDownTreeNode parentNode : childNode.parents()) {
                                    parentAllUnlocked &= parentNode.nodeState() == NodeState.UNLOCKED;
                                }
                            }
                            if (parentAllUnlocked) {
                                if (childNode.nodeInfo.noUnlockConditions()) {
                                    childNode.setNodeState(NodeState.UNLOCKABLE, true, modifyEquip);
                                } else if (!childNode.nodeInfo.hasCustomUnlockCondition()) {
                                    SkillTreeProgression.this.unlockAwaitingNodes.add((Pair<Holder.Reference<SkillTree>, TopDownTreeNode>)Pair.of(childNode.belongedSkillTree, (Object)childNode));
                                }
                            }
                        });
                        break;
                    }
                    case UNLOCKABLE: {
                        this.parents().forEach(parentNode -> {
                            if (parentNode.nodeState() != NodeState.UNLOCKED) {
                                parentNode.setNodeState(NodeState.UNLOCKED, true, modifyEquip);
                            }
                        });
                        this.children().forEach(childNode -> {
                            if (childNode.nodeState() != NodeState.LOCKED) {
                                childNode.setNodeState(NodeState.LOCKED, true, modifyEquip);
                            }
                        });
                    }
                }
            }
        }

        @Override
        public NodeState nodeState() {
            return this.nodeState;
        }
    }
}

