/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.command.argument;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.github.mortuusars.exposure.data.ExposureSize;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public class ExposureSizeArgument
implements ArgumentType<ExposureSize> {
    public ExposureSize parse(StringReader reader) throws CommandSyntaxException {
        String string = reader.readString();
        @Nullable ExposureSize size = ExposureSize.byName(string);
        if (size == null) {
            throw new SimpleCommandExceptionType((Message)Component.m_237110_((String)"argument.enum.invalid", (Object[])new Object[]{string})).create();
        }
        return size;
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return SharedSuggestionProvider.m_82981_(Arrays.stream(ExposureSize.values()).map(ExposureSize::m_7912_), (SuggestionsBuilder)builder);
    }

    public static ExposureSize getSize(CommandContext<?> context, String name) {
        return (ExposureSize)((Object)context.getArgument(name, ExposureSize.class));
    }
}

