/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.integration.kubejs;

import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.latvian.mods.kubejs.KubeJSPlugin;
import dev.latvian.mods.kubejs.event.EventJS;
import dev.latvian.mods.kubejs.event.EventResult;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.script.ScriptTypeHolder;
import io.github.mortuusars.exposure.integration.kubejs.event.ExposureJSEvents;
import io.github.mortuusars.exposure.integration.kubejs.event.FrameAddedEventJS;
import io.github.mortuusars.exposure.integration.kubejs.event.ModifyFrameDataEventJS;
import io.github.mortuusars.exposure.integration.kubejs.event.ShutterOpeningEventJS;
import io.github.mortuusars.exposure.integration.kubejs.forge.ExposureJSPluginImpl;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class ExposureJSPlugin
extends KubeJSPlugin {
    public void init() {
        ExposureJSPlugin.subscribeToEvents();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void subscribeToEvents() {
        ExposureJSPluginImpl.subscribeToEvents();
    }

    public void registerEvents() {
        ExposureJSEvents.register();
    }

    public static boolean fireShutterOpeningEvent(Player player, ItemStack cameraStack, int lightLevel, boolean shouldFlashFire) {
        EventResult result = ExposureJSEvents.SHUTTER_OPENING.post((ScriptTypeHolder)(player.m_9236_().f_46443_ ? ScriptType.CLIENT : ScriptType.SERVER), (EventJS)new ShutterOpeningEventJS(player, cameraStack, lightLevel, shouldFlashFire));
        return result.interruptTrue() || result.interruptFalse() || result.interruptDefault();
    }

    public static void fireModifyFrameDataEvent(ServerPlayer player, ItemStack cameraStack, CompoundTag frame, List<Entity> entitiesInFrame) {
        ExposureJSEvents.MODIFY_FRAME_DATA.post((ScriptTypeHolder)ScriptType.SERVER, (EventJS)new ModifyFrameDataEventJS((Player)player, cameraStack, frame, entitiesInFrame));
    }

    public static void fireFrameAddedEvent(ServerPlayer player, ItemStack cameraStack, CompoundTag frame) {
        ExposureJSEvents.FRAME_ADDED.post((ScriptTypeHolder)ScriptType.SERVER, (EventJS)new FrameAddedEventJS((Player)player, cameraStack, frame));
    }
}

