/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.dungeonsdelight.common.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.yirmiri.dungeonsdelight.core.init.DDTags;
import net.yirmiri.dungeonsdelight.core.registry.DDBlocks;

public class EmbeddedEggsBlock
extends Block {
    public static IntegerProperty SCULKING = IntegerProperty.m_61631_((String)"sculking", (int)0, (int)4);

    public EmbeddedEggsBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)super.m_49966_().m_61124_((Property)SCULKING, (Comparable)Integer.valueOf(0)));
    }

    public boolean m_6724_(BlockState state) {
        return true;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{SCULKING});
        super.m_7926_(builder);
    }

    public int getMaxCompostingStage() {
        return 4;
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!level.f_46443_) {
            float chance = 0.0f;
            int maxLight = 0;
            for (BlockPos neighborPos : BlockPos.m_121940_((BlockPos)pos.m_7918_(-1, -1, -1), (BlockPos)pos.m_7918_(1, 1, 1))) {
                int light;
                BlockState neighborState = level.m_8055_(neighborPos);
                if (neighborState.m_204336_(DDTags.BlockT.SCULKING_ACTIVATORS) || neighborState.m_204336_(DDTags.BlockT.MONSTER_HEAT_SOURCES)) {
                    chance += 0.02f;
                }
                if ((light = level.m_45517_(LightLayer.SKY, neighborPos.m_7494_())) <= maxLight || !level.m_46462_()) continue;
                maxLight = light;
            }
            chance += maxLight > 7 ? 0.1f : 0.05f;
            if (level.m_213780_().m_188501_() <= chance) {
                if (((Integer)state.m_61143_((Property)SCULKING)).intValue() == this.getMaxCompostingStage()) {
                    level.m_7731_(pos, ((Block)DDBlocks.HEAP_OF_ANCIENT_EGGS.get()).m_49966_(), 3);
                } else {
                    level.m_7731_(pos, (BlockState)state.m_61124_((Property)SCULKING, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)SCULKING) + 1)), 3);
                }
            }
        }
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState blockState, Level level, BlockPos pos) {
        return this.getMaxCompostingStage() + 1 - (Integer)blockState.m_61143_((Property)SCULKING);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        super.m_214162_(state, level, pos, random);
        if (random.m_188503_(10) == 0) {
            level.m_7106_((ParticleOptions)ParticleTypes.f_123757_, (double)pos.m_123341_() + (double)random.m_188501_(), (double)pos.m_123342_() + 1.1, (double)pos.m_123343_() + (double)random.m_188501_(), 0.0, 0.0, 0.0);
        }
    }
}

